/*
 * Decompiled with CFR 0.152.
 */
package com.cloudpath.gui;

import com.cloudpath.common.app.gui.ExternalInterface;
import com.cloudpath.common.dispatch.AsyncHandler;
import com.cloudpath.common.dispatch.DispatchRequest;
import com.cloudpath.common.dispatch.DispatchResponse;
import com.cloudpath.common.dispatch.ErrorRequest;
import com.cloudpath.common.dispatch.StartOverRequest;
import com.cloudpath.common.dispatch.TerminateRequest;
import com.cloudpath.common.dispatch.WaitRequest;
import com.cloudpath.common.os.common.BrowserProvider;
import com.cloudpath.common.util.GuiShutdownListener;
import com.cloudpath.common.util.Util;
import com.cloudpath.gui.FormProvider;
import com.cloudpath.gui.MainPanel;
import com.cloudpath.gui.component.XpcForm;
import com.cloudpath.gui.component.XpcTabs;
import com.cloudpath.gui.factor.XpcGuiFrame;
import com.cloudpath.gui.form.UpdatableForm;
import com.cloudpath.gui.form.WaitForm;
import com.cloudpath.gui.util.FormListener;
import com.cloudpath.gui.util.MenuProvider;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class GuiController
implements ExternalInterface,
FormListener {
    private static final Logger log = Logger.getLogger(GuiController.class);
    private final XpcGuiFrame cls_Frame;
    private FormProvider cls_FormProvider;
    private WaitForm cls_WaitForm;
    private XpcForm cls_CurrentForm;
    private final AsyncHandler cls_AsyncHandler;
    private final BrowserProvider cls_BrowserProvider;
    private final GuiShutdownListener cls_GuiShutdownListener;
    private final Object cls_SyncObject = new Object();

    public GuiController(GuiShutdownListener guiShutdownListener, FormProvider formProvider, MenuProvider menuProvider, AsyncHandler asyncHandler, boolean bl, BrowserProvider browserProvider) {
        this.cls_GuiShutdownListener = guiShutdownListener;
        this.cls_WaitForm = new WaitForm(this, new WaitRequest("Please Wait...", "We are loading the system configuration information.", "/loading.gif"), browserProvider);
        this.cls_CurrentForm = this.cls_WaitForm;
        this.cls_BrowserProvider = browserProvider;
        this.cls_FormProvider = formProvider;
        this.cls_AsyncHandler = asyncHandler;
        this.cls_Frame = new XpcGuiFrame(menuProvider, guiShutdownListener);
        this.getMainPanel().overlayForm(this.cls_CurrentForm);
        this.cls_Frame.setVisible(bl);
    }

    private MainPanel getMainPanel() {
        return this.cls_Frame.getMainPanel();
    }

    public XpcTabs getTabs() {
        return this.getMainPanel().getTabs();
    }

    public int getSelectedTab() {
        return this.getTabs().getSelectedTab();
    }

    public XpcGuiFrame getFrame() {
        return this.cls_Frame;
    }

    public void setTabs(String[] stringArray, int n) {
        this.getTabs().setTabNames(stringArray, n);
    }

    public void setSelectedTab(String string) {
        this.getTabs().setSelectedTab(string);
    }

    public void setSelectedTab(int n) {
        this.getTabs().setSelectedTab(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRequest(final DispatchRequest dispatchRequest) {
        log.debug((Object)("GuiController received request: " + dispatchRequest));
        if (dispatchRequest instanceof TerminateRequest) {
            log.warn((Object)"User has requested to terminate application.");
            Util.runThread("Closing", new Runnable(){

                public void run() {
                    log.warn((Object)"Application is exiting.");
                    if (GuiController.this.cls_GuiShutdownListener != null) {
                        GuiController.this.cls_GuiShutdownListener.shutdown();
                    } else {
                        System.exit(0);
                    }
                }
            });
        }
        Object object = this.cls_SyncObject;
        synchronized (object) {
            if (this.cls_CurrentForm == null) {
                WaitRequest waitRequest = new WaitRequest("", "", "/loading.gif");
                this.cls_CurrentForm = new WaitForm(this, waitRequest, this.cls_BrowserProvider);
            }
            boolean bl = false;
            XpcForm xpcForm = null;
            if (dispatchRequest instanceof WaitRequest) {
                xpcForm = this.cls_WaitForm;
                this.cls_WaitForm.update(dispatchRequest);
            } else {
                if (dispatchRequest instanceof StartOverRequest) {
                    log.debug((Object)"\n\nStarting Over...\n\n");
                    this.cls_AsyncHandler.processAsync(dispatchRequest);
                    return;
                }
                xpcForm = this.cls_CurrentForm != null && this.cls_CurrentForm instanceof UpdatableForm ? (((UpdatableForm)((Object)this.cls_CurrentForm)).update(dispatchRequest) ? this.cls_CurrentForm : this.cls_FormProvider.getForm(this, dispatchRequest)) : this.cls_FormProvider.getForm(this, dispatchRequest);
            }
            final XpcForm xpcForm2 = this.cls_CurrentForm;
            synchronized (xpcForm2) {
                boolean bl2 = bl = xpcForm != null && xpcForm != this.cls_CurrentForm;
                if (bl) {
                    this.cls_CurrentForm = xpcForm;
                    log.debug((Object)("Setting current form to: " + this.cls_CurrentForm));
                }
            }
            if (bl) {
                xpcForm2 = xpcForm;
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        block2: {
                            try {
                                GuiController.this.getMainPanel().overlayForm(xpcForm2);
                            }
                            catch (Throwable throwable) {
                                log.error((Object)("An error occurred while attempting to display form '" + xpcForm2 + "' for request '" + dispatchRequest + "'."), throwable);
                                if (dispatchRequest instanceof ErrorRequest) break block2;
                                GuiController.this.addRequest(new ErrorRequest("Unexpected Error", "An error occurred while displaying the current page.  <br><br><b>Error:</b> Unable to handle request '" + dispatchRequest + "' to display page '" + xpcForm2 + "'.", false, false));
                            }
                        }
                    }
                });
            }
        }
    }

    public void errorOccurred(Throwable throwable) {
        log.warn((Object)"GuiController has been notified of error.", throwable);
    }

    public void shutdown() {
        log.info((Object)"Will dispose of Frame...");
        if (this.cls_Frame != null) {
            this.cls_Frame.dispose();
        }
    }

    public boolean selectionMade(DispatchResponse dispatchResponse) {
        log.debug((Object)("GuiController received selection: " + dispatchResponse));
        this.cls_AsyncHandler.processAsync(dispatchResponse);
        return true;
    }
}

