/*
 * Decompiled with CFR 0.152.
 */
package com.cloudpath.common.util;

import com.cloudpath.common.util.Xmlable;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XmlUtil {
    public static final String createAttribute(String string, boolean bl, boolean bl2) {
        if (bl != bl2) {
            return XmlUtil.createAttribute(string, XmlUtil.getBooleanAsInt(bl));
        }
        return "";
    }

    public static final String createAttribute(String string, String string2, String string3) {
        if (string2 != null && !string2.equals(string3)) {
            return XmlUtil.createAttribute(string, string2);
        }
        return "";
    }

    public static final String createAttribute(String string, long l, long l2) {
        if (l != l2) {
            return XmlUtil.createAttribute(string, l);
        }
        return "";
    }

    public static final String createAttribute(String string, int n, int n2) {
        if (n != n2) {
            return XmlUtil.createAttribute(string, n);
        }
        return "";
    }

    public static final String createAttribute(String string, int n) {
        return XmlUtil.createAttribute(string, "" + n);
    }

    public static final String createAttribute(String string, long l) {
        return XmlUtil.createAttribute(string, "" + l);
    }

    public static final String createAttribute(String string, String string2) {
        if (string2 == null) {
            return "";
        }
        string2 = string2.replace("&", "&amp;");
        string2 = string2.replace("\"", "&quot;");
        string2 = string2.replace("'", "&#39;");
        string2 = string2.replace("<", "&lt;");
        if ((string2 = string2.replace(">", "&gt;")) != null && string2.length() > 0) {
            return " " + string + "='" + string2 + "'";
        }
        return "";
    }

    public static final String createElement(String string, String string2, String string3) {
        if (string3 != null && string3.equals(string2)) {
            return "";
        }
        return XmlUtil.createElement(string, "", string2, true, false, "");
    }

    public static final String createElement(String string, Long l, Long l2) {
        if (l2 != null && l2.equals(l)) {
            return "";
        }
        return XmlUtil.createElement(string, "", l != null ? l.toString() : "", true, false, "");
    }

    public static final String createElement(String string, String string2) {
        return XmlUtil.createElement(string, string2, false);
    }

    public static final String createElement(String string, String string2, boolean bl) {
        return XmlUtil.createElement(string, "", string2, true, bl, "");
    }

    public static final String createElement(String string, String string2, String string3, boolean bl, boolean bl2, String string4) {
        if (string2.length() > 0) {
            string2 = " " + string2;
        }
        string3 = XmlUtil.delimitXml(string3);
        if (bl2 || string3 != null && string3.length() > 0) {
            if (string4.length() > 0 && string4.equals(string3)) {
                return "";
            }
            if (bl && !XmlUtil.needsCdata(string3)) {
                return "<" + string + string2 + ">" + string3 + "</" + string + ">\n";
            }
            return "<" + string + string2 + "><![CDATA[" + string3 + "]]></" + string + ">\n";
        }
        return "";
    }

    public static final String createElementIsolated(String string) {
        return "<" + string + "/>\n";
    }

    public static final String createElementOpen(String string) {
        return "<" + string + ">\n";
    }

    public static final String createElementClose(String string) {
        return "</" + string + ">\n";
    }

    public static boolean getStringAsBoolean(String string, boolean bl) {
        if (string == null || string.length() == 0) {
            return bl;
        }
        if ("1".equals(string) || "TRUE".equals(string.toUpperCase())) {
            return true;
        }
        if ("0".equals(string) || "FALSE".equals(string.toUpperCase())) {
            return false;
        }
        return bl;
    }

    public static final long getStringAsLong(String string, long l) {
        if (string == null || string.length() == 0) {
            return l;
        }
        try {
            return Long.parseLong(string);
        }
        catch (NumberFormatException numberFormatException) {
            return l;
        }
    }

    public static final int getStringAsInt(String string, int n) {
        if (string == null || string.length() == 0) {
            return n;
        }
        try {
            return Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            return n;
        }
    }

    public static final boolean getBoolean(int n) {
        return n == 1;
    }

    public static int getBooleanAsInt(boolean bl) {
        return bl ? 1 : 0;
    }

    public static final String createElementData(String string) {
        if (XmlUtil.needsCdata(string)) {
            return "<![CDATA[" + string + "]]>";
        }
        if (string != null) {
            string = string.replaceAll("&amp;", "&");
            string = string.replaceAll("&", "&amp;");
        }
        return string;
    }

    public static final boolean needsCdata(String string) {
        if (string == null) {
            return false;
        }
        return string.indexOf("<") >= 0 || string.indexOf(">") >= 0;
    }

    public static String getXml(Xmlable[] xmlableArray, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(XmlUtil.createElementOpen(string));
        for (int i = 0; xmlableArray != null && i < xmlableArray.length; ++i) {
            if (xmlableArray[i] == null) continue;
            stringBuffer.append(xmlableArray[i].getXml());
        }
        stringBuffer.append(XmlUtil.createElementClose(string));
        return stringBuffer.toString();
    }

    public static String getXml(ArrayList<?> arrayList, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(XmlUtil.createElementOpen(string));
        for (int i = 0; arrayList != null && i < arrayList.size(); ++i) {
            if (arrayList.get(i) == null || !(arrayList.get(i) instanceof Xmlable)) continue;
            stringBuffer.append(((Xmlable)arrayList.get(i)).getXml());
        }
        stringBuffer.append(XmlUtil.createElementClose(string));
        return stringBuffer.toString();
    }

    public static String delimitXml(String string) {
        if (string == null) {
            string = "";
        } else if (string.length() > 0) {
            string = string.replace("&amp;", "&");
            string = string.replace("&", "&amp;");
        }
        return string;
    }
}

