/*
 * Decompiled with CFR 0.152.
 */
package com.cloudpath.common.util;

import com.cloudpath.common.util.FileUtil;
import com.cloudpath.common.util.Resources;
import com.cloudpath.common.util.Util;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class TraceFile {
    private static final Logger log = Logger.getLogger(TraceFile.class);
    private static final SimpleDateFormat FULL_DATE = new SimpleDateFormat("yyyyMMdd_hhmmss_SSS", Locale.US);
    private static final File TEMP_DIR = new File(Util.getTempDirectory(), Resources.ResourceString.PRODUCT_NAME.getValue());
    private static final File TRACE_DIR = new File(TEMP_DIR, "tracing");
    private static final String LINE_SEPARATOR = "\n------------------------------------------------------------\n";
    private final String cls_FileName;
    private final boolean cls_IsEnabled;
    private final StringBuffer cls_Text;
    private final Logger cls_Log;
    private final boolean cls_Timestamp;

    public TraceFile(String string, boolean bl, Logger logger) {
        this.cls_FileName = string;
        this.cls_Log = logger;
        this.cls_IsEnabled = TRACE_DIR.exists();
        this.cls_Timestamp = bl;
        if (this.cls_IsEnabled) {
            this.cls_Text = new StringBuffer();
            this.cls_Text.append("Starting at " + Util.FULL_DATE.format(new Date()) + "." + LINE_SEPARATOR + "\n");
        } else {
            this.cls_Text = null;
        }
    }

    public boolean isEnabled() {
        return this.cls_IsEnabled || this.cls_Log != null && this.cls_Log.isDebugEnabled();
    }

    public void startBlock(String string) {
        this.writeBlock("STARTING BLOCK: " + string);
    }

    public void stopBlock(String string) {
        this.writeBlock("STOPPING BLOCK: " + string);
    }

    private void writeBlock(String string) {
        if (this.cls_IsEnabled) {
            this.cls_Text.append(LINE_SEPARATOR);
            this.cls_Text.append("  " + string);
            this.cls_Text.append("\n------------------------------------------------------------\n\n");
        }
    }

    public void debug(String string) {
        this.append((Priority)Level.DEBUG, string, null);
    }

    public void info(String string) {
        this.append((Priority)Level.INFO, string, null);
    }

    public void warn(String string) {
        this.append((Priority)Level.WARN, string, null);
    }

    public void warn(String string, Throwable throwable) {
        this.append((Priority)Level.WARN, string, throwable);
    }

    public void error(String string) {
        this.append((Priority)Level.ERROR, string, null);
    }

    public void error(String string, Throwable throwable) {
        this.append((Priority)Level.ERROR, string, throwable);
    }

    public void debug(Logger logger, String string) {
        this.append((Priority)Level.DEBUG, string, null, logger);
    }

    public void info(Logger logger, String string) {
        this.append((Priority)Level.INFO, string, null, logger);
    }

    public void warn(Logger logger, String string) {
        this.append((Priority)Level.WARN, string, null, logger);
    }

    public void warn(Logger logger, String string, Throwable throwable) {
        this.append((Priority)Level.WARN, string, throwable, logger);
    }

    public void error(Logger logger, String string) {
        this.append((Priority)Level.ERROR, string, null, logger);
    }

    public void error(Logger logger, String string, Throwable throwable) {
        this.append((Priority)Level.ERROR, string, throwable, logger);
    }

    public void append(Priority priority, String string, Throwable throwable) {
        this.append(priority, string, throwable, this.cls_Log);
    }

    public void append(Priority priority, String string, Throwable throwable, Logger logger) {
        if (logger != null && logger.isEnabledFor(priority)) {
            logger.log(priority, (Object)string, throwable);
        }
        if (this.cls_IsEnabled) {
            this.cls_Text.append(string);
            this.cls_Text.append('\n');
        }
    }

    public void save() {
        this.save(this.cls_Timestamp);
    }

    public void save(boolean bl) {
        if (this.cls_IsEnabled) {
            this.cls_Text.append("\n------------------------------------------------------------\nStopping at " + Util.FULL_DATE.format(new Date()) + ".\n");
            log.info((Object)("Saving trace file " + this.cls_FileName + (bl ? " with timestamp." : " without timestamp.")));
            TraceFile.writeTraceFile(this.cls_FileName, bl, this.cls_Text.toString());
        }
    }

    public static final void setEnabled(boolean bl) {
        if (bl) {
            if (!TRACE_DIR.exists()) {
                TRACE_DIR.mkdirs();
            }
        } else {
            Util.delete(TRACE_DIR);
            Util.deleteOnExit(TRACE_DIR);
        }
    }

    public static final boolean isTracingEnabled() {
        return TRACE_DIR.exists();
    }

    public static final void writeTraceFile(String string, boolean bl, String string2) {
        if (TraceFile.isTracingEnabled()) {
            try {
                if (bl) {
                    string = FULL_DATE.format(new Date()) + "_" + string;
                }
                FileUtil.write(new File(TRACE_DIR, string).getAbsolutePath(), string2);
            }
            catch (Throwable throwable) {
                log.debug((Object)("Unable to update the trace file: " + string));
            }
        }
    }

    static {
        if (TRACE_DIR.exists()) {
            log.info((Object)("Tracing is enabled to " + TRACE_DIR.getAbsolutePath()));
            File[] fileArray = TRACE_DIR.listFiles();
            for (int i = 0; i < fileArray.length; ++i) {
                fileArray[i].delete();
            }
        } else {
            log.info((Object)"Tracing is not enabled.");
        }
    }
}

