/*
 * Decompiled with CFR 0.152.
 */
package com.cloudpath.common.util;

public class SystemInformation {
    private static final String WINDOWS_XP = "Windows XP";
    private static final String WINDOWS_VISTA = "Windows Vista";
    private static final String OS_UNKNOWN = "Unknown OS";
    public static final String OS_WINDOWS = "windows";
    public static final String OS_MAC = "mac";
    public static final String OS_LINUX = "linux";
    public static final String OS_VERSION_WIN_XP = "5.1";
    public static final String OS_VERSION_WIN_2003 = "5.2";
    public static final String OS_VERSION_WIN_VISTA = "6.0";
    private String cls_Os;
    private String cls_OsVersion;
    private double cls_OsServicePack;

    public String getOs() {
        return this.cls_Os;
    }

    public String getOsVersion() {
        return this.cls_OsVersion;
    }

    public double getOsServicePack() {
        return this.cls_OsServicePack;
    }

    public boolean getIsWindows() {
        return OS_WINDOWS.equals(this.getOs());
    }

    public boolean getIsWindowsXp() {
        return this.getIsWindows() && OS_VERSION_WIN_XP.equals(this.getOsVersion());
    }

    public boolean getIsWindowsVista() {
        return this.getIsWindows() && OS_VERSION_WIN_VISTA.equals(this.getOsVersion());
    }

    public void override(String string, String string2, double d) {
        this.cls_Os = string;
        this.cls_OsVersion = string2;
        this.cls_OsServicePack = d;
    }

    public String getOsName() {
        if (this.getIsWindowsXp()) {
            return WINDOWS_XP;
        }
        if (this.getIsWindowsVista()) {
            return WINDOWS_VISTA;
        }
        return OS_UNKNOWN;
    }

    public boolean isOsSupported() {
        return this.getIsWindowsVista() || this.getIsWindowsXp();
    }

    public void overrideToXpSp2() {
        this.override(OS_WINDOWS, OS_VERSION_WIN_XP, 2.0);
    }

    public void overrideToVista() {
        this.override(OS_WINDOWS, OS_VERSION_WIN_VISTA, 0.0);
    }
}

