/*
 * Decompiled with CFR 0.152.
 */
package com.cloudpath.common.util;

import com.cloudpath.common.util.AbstractDataType;
import com.cloudpath.common.util.SelectionHandler;
import com.cloudpath.common.util.SelectionListener;
import com.cloudpath.common.util.XmlUtil;
import com.cloudpath.common.util.Xmlable;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.log4j.Logger;

public class SelectionHandlerImpl
implements SelectionHandler {
    private static final Logger log = Logger.getLogger(SelectionHandlerImpl.class);
    private static long NEXT_ID = 1L;
    private final HashMap<AbstractDataType, Object> cls_Map = new HashMap();
    private final ArrayList<SelectionListener> cls_Listeners = new ArrayList();
    private final long cls_Id;
    private final AbstractDataType[] cls_NonResetKeys;
    private final AbstractDataType[] cls_SecretKeys;
    private HashMap<AbstractDataType, String> cls_LastGetMessages = new HashMap();
    private static final String SNAPSHOT_ELEMENT = "SNAPSHOT";

    public SelectionHandlerImpl() {
        this(null, null);
    }

    public SelectionHandlerImpl(AbstractDataType[] abstractDataTypeArray, AbstractDataType[] abstractDataTypeArray2) {
        this.cls_Id = NEXT_ID++;
        this.cls_NonResetKeys = abstractDataTypeArray;
        this.cls_SecretKeys = abstractDataTypeArray2;
    }

    public void setObject(AbstractDataType abstractDataType, Object object) {
        if (object == null || abstractDataType.getStorageDataClass().isInstance(object)) {
            Object object2 = this.getObject(abstractDataType);
            boolean bl = false;
            bl = object2 == null && object != null ? true : (object2 != null && object == null ? true : (object2 == null && object == null ? false : !object2.equals(object)));
            if (bl) {
                String string = "Setting '" + abstractDataType + "' to '" + object + "'.";
                log.info((Object)string);
                this.cls_Map.put(abstractDataType, object);
                for (int i = 0; i < this.cls_Listeners.size(); ++i) {
                    this.cls_Listeners.get(i).selectionUpdated(abstractDataType, object, object2);
                }
            }
        } else {
            log.warn((Object)("Not setting object because data is null or invalid.  Data: " + object));
        }
    }

    public Object getObject(AbstractDataType abstractDataType) {
        Object object = this.cls_Map.get(abstractDataType);
        if (object != null) {
            String string;
            String string2 = "Getting '" + abstractDataType + "' as '" + object + "'.";
            if (!string2.equals(string = this.cls_LastGetMessages.get(abstractDataType))) {
                log.info((Object)string2);
            } else {
                log.debug((Object)string2);
            }
            this.cls_LastGetMessages.put(abstractDataType, string2);
        }
        return object;
    }

    public void addListener(SelectionListener selectionListener) {
        this.cls_Listeners.add(selectionListener);
    }

    public String print() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.cls_Map != null && this.cls_Map.keySet() != null) {
            Object[] objectArray = this.cls_Map.keySet().toArray();
            for (int i = 0; objectArray != null && i < objectArray.length; ++i) {
                if (this.getObject((AbstractDataType)objectArray[i]) == null) continue;
                if (this.isSecret((AbstractDataType)objectArray[i])) {
                    stringBuffer.append(objectArray[i] + " = **PRIVATE**\n");
                    continue;
                }
                stringBuffer.append(objectArray[i] + " = " + this.getObject((AbstractDataType)objectArray[i]) + "\n");
            }
        }
        return stringBuffer.toString();
    }

    private boolean isSecret(AbstractDataType abstractDataType) {
        if (this.cls_SecretKeys != null) {
            for (int i = 0; i < this.cls_SecretKeys.length; ++i) {
                if (!abstractDataType.equals(this.cls_SecretKeys[i])) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isResetable(AbstractDataType abstractDataType) {
        if (this.cls_NonResetKeys != null) {
            for (int i = 0; i < this.cls_NonResetKeys.length; ++i) {
                if (!abstractDataType.equals(this.cls_NonResetKeys[i])) continue;
                return false;
            }
        }
        return true;
    }

    public void reset() {
        log.info((Object)"All selections are being reset.");
        Object[] objectArray = this.cls_Map.keySet().toArray();
        for (int i = 0; i < objectArray.length; ++i) {
            if (!this.isResetable((AbstractDataType)objectArray[i])) continue;
            this.setObject((AbstractDataType)objectArray[i], null);
            this.cls_Map.remove((AbstractDataType)objectArray[i]);
        }
    }

    public String getXml() {
        StringBuffer stringBuffer = new StringBuffer();
        AbstractDataType[] abstractDataTypeArray = new AbstractDataType[this.cls_Map.size()];
        this.cls_Map.keySet().toArray(abstractDataTypeArray);
        for (int i = 0; i < abstractDataTypeArray.length; ++i) {
            Object object = this.cls_Map.get(abstractDataTypeArray[i]);
            if (object == null) continue;
            stringBuffer.append(XmlUtil.createElementOpen(abstractDataTypeArray[i].name()));
            if (object instanceof Xmlable) {
                stringBuffer.append(((Xmlable)object).getXml());
            } else {
                stringBuffer.append(object.toString() + '\n');
            }
            stringBuffer.append(XmlUtil.createElementClose(abstractDataTypeArray[i].name()));
        }
        if (stringBuffer.length() > 0) {
            return XmlUtil.createElementOpen(SNAPSHOT_ELEMENT) + stringBuffer.toString() + XmlUtil.createElementClose(SNAPSHOT_ELEMENT);
        }
        return XmlUtil.createElementIsolated(SNAPSHOT_ELEMENT);
    }

    public String toString() {
        return "[SelectionHandler id=" + this.cls_Id + "]";
    }
}

