/*
 * Decompiled with CFR 0.152.
 */
package com.cloudpath.common.util;

import java.util.HashMap;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.apache.log4j.Logger;

public abstract class Resources {
    private static final Logger log = Logger.getLogger(Resources.class);
    private static final ResourceBundle RESOURCES;
    private static final HashMap<Long, ResourceString> cls_Map;

    public static final ResourceString getResoureString(String string) {
        try {
            return Resources.getResourceString(Long.parseLong(string));
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    private static final ResourceString getResourceString(long l) {
        if (cls_Map.size() == 0) {
            for (ResourceString resourceString : ResourceString.values()) {
                cls_Map.put(resourceString.getId(), resourceString);
            }
        }
        return cls_Map.get(l);
    }

    static {
        try {
            RESOURCES = ResourceBundle.getBundle("resources");
        }
        catch (RuntimeException runtimeException) {
            log.fatal((Object)"Unable to open resources.", (Throwable)runtimeException);
            throw runtimeException;
        }
        cls_Map = new HashMap();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ResourceString {
        BUILD_LABEL(1L),
        COMPANY_NAME(100L),
        PRODUCT_NAME(101L),
        COPYRIGHT(102L),
        LEGAL_COMPANY_NAME(103L),
        WEBSITE(104L),
        APPLICATION_TITLE(105L),
        PRODUCT_SUPPORT_EMAIL(106L),
        UNLOCK_PASSWORD(107L),
        UPPER_LEFT_LINE(108L),
        TOPBAR_HTML(109L),
        SLOGAN(110L),
        CONTACT_US_EMAIL(111L),
        APPLICATION_NAME(112L),
        LICENSE_EMAIL(113L),
        SUPPORT_FYI_EMAIL(114L),
        ANDROID_LINK_PROTOCOL(115L),
        ORANGE_COLOR(118L),
        HOME_URL(119L),
        PAGE_HELP_BACKGROUND_COLOR(120L),
        TABLE_HEADER_BACKGROUND_COLOR(121L),
        UNSELECTED_TAB_BACKGROUND_COLOR(122L),
        UNSELECTED_TAB_FONT_COLOR(123L),
        SLOGAN_FONT_COLOR(124L),
        INTERNAL_DESCRIPTION_BACKGROUND_COLOR(126L),
        SELECTED_TAB_BACKGROUND_COLOR(127L),
        ALLOW_SELF_CREATION(128L),
        WORK_AREA_BACKGROUND_COLOR(129L),
        BOTTOM_BAR_BACKGROUND_COLOR(130L),
        FOOTER_BACKGROUND_COLOR(131L),
        BUTTON_LOCATION_ON_TOP(132L),
        HEADER_TEXT_CENTERED(133L),
        MENU_BACKGROUND_COLOR(134L),
        SELECTED_TAB_FONT_COLOR(135L),
        FONT_FAMILY(136L),
        MENU_ON_TOP(139L),
        MAIN_TAB(140L),
        ADVANCED_TAB(141L),
        NETWORKS_TAB(142L),
        DOWNLOADS_TAB(143L),
        ADMINISTRATIVE_TAB(144L),
        SUPPORT_TAB(145L),
        LOGOUT_TAB(146L),
        MINIMUM_SUPPORT_LEVEL(147L),
        MESSAGE_OF_THE_DAY(148L),
        UNDER_MAINTANANCE(149L),
        LINK_HOVER_COLOR(150L),
        SELECTED_TAB_LINK_HOVER_COLOR(151L),
        ALERT_BOX_BACKGROUND_COLOR(152L),
        MENU_SEPARATOR_COLOR(153L),
        EMAIL_NEW_ACCOUNT_SUBJECT(154L),
        EMAIL_NEW_ACCOUNT_BODY(155L),
        EMAIL_NEW_LICENSE_PERPETUAL_SUBJECT(156L),
        EMAIL_NEW_LICENSE_PERPETUAL_BODY(157L),
        EMAIL_NEW_LICENSE_SUBSCRIPTION_SUBJECT(158L),
        EMAIL_NEW_LICENSE_SUBSCRIPTION_BODY(159L),
        EMAIL_PASSWORD_RESET_SUBJECT(160L),
        EMAIL_PASSWORD_RESET_BODY(161L),
        REQUIRE_EULA_ON_DOWNLOAD(162L),
        PRODUCT_FOLDER_NAME(180L),
        PRODUCT_FILE_NAME(181L),
        LINUX_X86_EXECUTABLE_NAME(182L),
        ANDROID_PACKAGE_NAME(184L),
        ANDROID_MIMETYPE(185L),
        ANDROID_DNS_TARGET(186L),
        LINUX_X86_TAR_NAME(187L),
        LINUX_X64_TAR_NAME(188L),
        LINUX_X64_EXECUTABLE_NAME(189L),
        IDENTITY_SHORT_NAME(201L),
        EULA_STATE(202L),
        SUPPORT_SMTP_SERVER(203L),
        SUPPORT_SMTP_USER_NAME(204L),
        SUPPORT_SMTP_PASSWORD(205L),
        EULA_LABEL(206L),
        WIZARD_PAGE_1_TITLE(210L),
        WIZARD_PAGE_2_TITLE(211L),
        WIZARD_PAGE_3_TITLE(212L),
        WIZARD_PAGE_4_APPLET_TITLE(213L),
        WIZARD_PAGE_4_ACTIVEX_TITLE(214L),
        WIZARD_PAGE_4_DOWNLOAD_TITLE(215L),
        WIZARD_PAGE_5_DOWNLOAD_TITLE(216L),
        WEB_SERVER_URL(217L),
        DEFAULT_ACTION(218L),
        UNSUPPORTED_OS_MESSAGE(219L),
        WIZARD_PAGE_1_INSTRUCTIONS(220L),
        WIZARD_PAGE_1_EULA_PHRASE(221L),
        WIZARD_PAGE_4_MAC_TITLE(222L),
        HTML_LOADER_BACKGROUND_COLOR(227L),
        HTML_LOADER_HEADER_FONT_COLOR(228L),
        HTML_LOADER_TAG_LINE(229L),
        HTML_PAGE_1_TEXT(230L),
        ANDROID_INSTRUCTIONS(231L),
        IOS_INSTRUCTIONS(232L),
        UBUNTU_AND_FEDORA_INSTRUCTIONS(233L),
        MAC_INSTRUCTIONS(234L),
        WINDOWS_INSTRUCTIONS(235L),
        HTML_PAGE_4_TEXT(236L),
        START_BUTTON(237L),
        ACTIVEX_INSTRUCTIONS(238L),
        ACTIVEX_INSTRUCTIONS_2(239L),
        MANUAL_OPTION_TEXT(240L),
        DETECTING_APPLET_TEXT(241L),
        APPLET_INSTRUCTIONS(242L),
        IPHONE_INSTALL_INSTRUCTIONS(243L),
        IPHONE_POSTINSTALL_INSTRUCTIONS(244L),
        WEBSERVER_USERNAME_VARIABLE(245L),
        WEBSERVER_PASSWORD_VARIABLE(246L),
        IOS_CREDENTIAL_PROMPT(247L),
        ACTIVEX_INSTRUCTIONS_IE9(249L),
        APPLICATION_ACTIVE_TAB_FONT_COLOR(250L),
        APPLICATION_ACTIVE_TAB_BACKGROUND_COLOR(251L),
        APPLICATION_ACTIVE_TAB_BORDER_COLOR(252L),
        APPLICATION_INACTIVE_TAB_FONT_COLOR(253L),
        APPLICATION_INACTIVE_TAB_BACKGROUND_COLOR(254L),
        APPLICATION_INACTIVE_TAB_BORDER_COLOR(255L),
        APPLICATION_TAB_SHAPE(256L),
        APPLICATION_LINE_COLOR(257L),
        APPLICATION_PROGRESS_COLOR(258L),
        APPLICATION_OUTLINE_COLOR(259L),
        APPLICATION_BACKGROUND_COLOR(260L),
        APPLICATION_DISABLED_COLOR(261L),
        APPLICATION_DISPLAY_LOGO(262L),
        APPLICATION_SHADOW_WIDTH(263L),
        APPLICATION_SELECTION_COLOR(264L),
        APPLICATION_MAIN_TEXT_COLOR(265L),
        APPLICATION_USES_ROUNDED_CORNERS(266L),
        MAC_LION_THROUGH_MAVERICKS_INSTRUCTIONS(267L),
        MAC_POSTINSTALL_INSTRUCTIONS(269L),
        APPLETV_POSTINSTALL_INSTRUCTIONS(270L),
        WELCOME_TAB_TITLE(300L),
        CONFIGURE_TAB_TITLE(302L),
        CONNECT_TO_NETWORK_TAB_TITLE(305L),
        AUTHENTICATE_TAB_TITLE(306L),
        VALIDATE_CONNECTIVITY_TAB_TITLE(307L),
        CONNECTED_TAB_TITLE(308L),
        WELCOME_TAB_MESSAGE(310L),
        CONFIGURE_TAB_MESSAGE(312L),
        CONNECT_TO_NETWORK_TAB_MESSAGE(315L),
        AUTHENTICATE_TAB_MESSAGE(316L),
        VALIDATE_CONNECTIVITY_TAB_MESSAGE(317L),
        CONNECTED_TAB_MESSAGE(318L),
        INTERFACE_TYPE_WIRED(330L),
        INTERFACE_TYPE_WIRELESS(331L),
        INTERFACE_TYPE_BRIDGE(332L),
        INTERFACE_TYPE_UNKNOWN(333L),
        AUTHENTICATION_WAIT_TIME(334L),
        AUTHENTICATION_ASSISTANCE_TEXT(335L),
        UNSUPPORTED_DEVICE_TEXT(336L),
        PRE_CREDENTIAL_TEXT(337L),
        ADMIN_CREDENTIAL_TEXT(338L),
        APPLICATION_STARTED_MESSAGE(339L),
        LINUX_KEYCHAIN_BEHAVIOR(340L),
        NETWORK_SELECTION_LABEL(341L),
        ERROR_NO_CONFIGURATION(400L),
        ERROR_NIC_FAILED_DISCONNECT(401L),
        ERROR_NIC_FAILED_RECONNECT(402L),
        ERROR_FAILED_AUTHENTICATION(403L),
        ERROR_FAILED_IP(404L),
        ERROR_FAILED_VALIDATION(405L),
        UNSUPPORTED_NETWORK_CARD_MESSAGE(407L),
        UNSUPPORTED_NETWORK_CARD_URL_CAPTION(408L),
        UNSUPPORTED_NETWORK_CARD_URL(409L),
        ERROR_FAILED_AUTHENTICATION_WITH_PREPROMPTING(410L),
        ERROR_FAILED_ASSOCIATION(413L),
        ERROR_INVALID_USERNAME(414L),
        UNSUPPORTED_PHY_TYPE_MESSAGE(415L),
        ERROR_REGISTRATION_URL_401(416L),
        ERROR_FAILED_AUTHENTICATION_ON_WIN8_WITH_PEAP(417L),
        GENERIC_OS_SETTINGS_TITLE(500L),
        SPECIFIC_OS_SETTINGS_TITLE(501L),
        SELECT_NETWORK_TITLE(502L),
        CA_HOST_NAME(10001L),
        CA_NAME(10002L),
        REQUEST_ATTRIBUTES(10003L),
        CA_USE_CONTAINER_AUTH(10004L),
        CA_ALLOW_DOMAIN_LOOKUP(10005L),
        CA_DOMAINS_TO_SEARCH(10006L),
        CA_USE_GUID_FOR_PASSWORD(10007L);

        private final long cls_Id;

        private ResourceString(long l) {
            this.cls_Id = l;
        }

        public long getId() {
            return this.cls_Id;
        }

        public String getValue() {
            try {
                return RESOURCES.getString("" + this.getId());
            }
            catch (MissingResourceException missingResourceException) {
                log.warn((Object)("Resource " + this.getId() + " is missing."), (Throwable)missingResourceException);
                return "";
            }
        }
    }
}

