/*
 * Decompiled with CFR 0.152.
 */
package com.cloudpath.common.util;

import com.cloudpath.common.compare.VersionCompare;
import org.apache.log4j.Logger;

public class OsInfo {
    private static final Logger log = Logger.getLogger(OsInfo.class);
    private final String cls_OsName;
    private final String cls_OsVersion;

    public OsInfo() {
        String string = System.getProperty("os.name").toLowerCase();
        String string2 = System.getProperty("os.version");
        log.info((Object)("Creating OsInfo with OS Name '" + string + "' and OS Version '" + string2 + "'."));
        if (string.contains("windows")) {
            this.cls_OsName = "windows";
            this.cls_OsVersion = string2;
        } else if (string.contains("mac os x")) {
            this.cls_OsName = "mac";
            long[] lArray = VersionCompare.getSplitVersion(string2);
            String string3 = "";
            string3 = lArray != null ? (lArray.length < 2 ? lArray[0] + ".0" : lArray[0] + "." + lArray[1]) : "0.0";
            this.cls_OsVersion = string3;
        } else {
            this.cls_OsName = string;
            this.cls_OsVersion = string2;
        }
        log.info((Object)("Created OsInfo with name '" + this.cls_OsName + "' and version '" + this.cls_OsVersion + "'."));
    }

    public OsInfo(String string, String string2) {
        this.cls_OsName = string;
        this.cls_OsVersion = string2;
    }

    public static String getInfo() {
        return "[OS: " + System.getProperty("os.name") + " - " + System.getProperty("os.version") + "]";
    }

    public String getOsName() {
        return this.cls_OsName;
    }

    public String getOsVersion() {
        return this.cls_OsVersion;
    }

    public boolean isMac() {
        return "mac".equals(this.getOsName());
    }

    public boolean isMacPuma() {
        return this.isMac() && this.getOsVersion().contentEquals("10.1");
    }

    public boolean isMacJaguar() {
        return this.isMac() && this.getOsVersion().contentEquals("10.2");
    }

    public boolean isMacPanther() {
        return this.isMac() && this.getOsVersion().contentEquals("10.3");
    }

    public boolean isMacTiger() {
        return this.isMac() && this.getOsVersion().contentEquals("10.4");
    }

    public boolean isMacLeopard() {
        return this.isMac() && this.getOsVersion().contentEquals("10.5");
    }

    public boolean isMacSnowLeopard() {
        return this.isMac() && this.getOsVersion().contentEquals("10.6");
    }

    public boolean isMacLion() {
        return this.isMac() && this.getOsVersion().contentEquals("10.7");
    }

    public boolean isMacMountainLion() {
        return this.isMac() && this.getOsVersion().contentEquals("10.8");
    }

    public boolean isMacMavericks() {
        return this.isMac() && this.getOsVersion().contentEquals("10.9");
    }

    public boolean isMacYosemite() {
        return this.isMac() && this.getOsVersion().contentEquals("10.10");
    }

    public boolean isMacElCapitan() {
        return this.isMac() && this.getOsVersion().contentEquals("10.11");
    }

    public boolean isMacPumaOrBefore() {
        return this.isMacPuma();
    }

    public boolean isMacJaguarOrBefore() {
        return this.isMacPumaOrBefore() || this.isMacJaguar();
    }

    public boolean isMacPantherOrBefore() {
        return this.isMacJaguarOrBefore() || this.isMacPanther();
    }

    public boolean isMacTigerOrBefore() {
        return this.isMacPantherOrBefore() || this.isMacTiger();
    }

    public boolean isMacLeopardOrBefore() {
        return this.isMacTigerOrBefore() || this.isMacLeopard();
    }

    public boolean isMacSnowLeopardOrBefore() {
        return this.isMacLeopardOrBefore() || this.isMacSnowLeopard();
    }

    public boolean isMacLionOrBefore() {
        return this.isMacSnowLeopardOrBefore() || this.isMacLion();
    }

    public boolean isMacMountainLionOrBefore() {
        return this.isMacLionOrBefore() || this.isMacMountainLion();
    }

    public boolean isMacMavericksOrBefore() {
        return this.isMacMountainLionOrBefore() || this.isMacMavericks();
    }

    public boolean isMacYosemiteOrBefore() {
        return this.isMacMavericksOrBefore() || this.isMacYosemite();
    }

    public boolean isMacElCapitanOrBefore() {
        return this.isMacYosemiteOrBefore() || this.isMacElCapitan();
    }

    public boolean isMacTigerOrLater() {
        return !this.isMacPantherOrBefore();
    }

    public boolean isMacLeopardOrLater() {
        return !this.isMacTigerOrBefore();
    }

    public boolean isMacSnowLeopardOrLater() {
        return !this.isMacLeopardOrBefore();
    }

    public boolean isMacLionOrLater() {
        return !this.isMacSnowLeopardOrBefore();
    }

    public boolean isMacMountainLionOrLater() {
        return !this.isMacLionOrBefore();
    }

    public boolean isMacMavericksOrLater() {
        return !this.isMacMountainLionOrBefore();
    }

    public boolean isMacYosemiteOrLater() {
        return !this.isMacMavericksOrBefore();
    }

    public boolean isMacElCapitanOrLater() {
        return !this.isMacYosemiteOrLater();
    }

    public boolean isMacLeopardBeforeUpdate4() {
        return this.isMacLeopardBeforeUpdate(4);
    }

    public boolean isMacSnowLeopardUpdate2OrGreater() {
        return this.isMacSnowLeopardUpdateOrAfter(2);
    }

    public boolean isBeforeMacMountainLionUpdate2() {
        if (this.isMacLionOrBefore()) {
            return true;
        }
        return this.isMacMountainLion() && OsInfo.getMacUpdateLevelAsInt() < 2;
    }

    public boolean isWindows() {
        return "windows".equals(this.getOsName());
    }

    public boolean isWindows2000() {
        return this.isWindows() && "5.0".equals(this.getOsVersion());
    }

    public boolean isWindows2003() {
        return this.isWindows() && "5.2".equals(this.getOsVersion());
    }

    public boolean isWindowsXp() {
        return this.isWindows() && "5.1".equals(this.getOsVersion());
    }

    public boolean isWindowsVista() {
        return this.isWindows() && "6.0".equals(this.getOsVersion());
    }

    public boolean isWindows2000OrBefore() {
        return this.isWindows2000();
    }

    public boolean isWindows2003OrBefore() {
        return this.isWindows2000OrBefore() || this.isWindows2003();
    }

    public boolean isWindowsXpOrBefore() {
        return this.isWindows2003OrBefore() || this.isWindowsXp();
    }

    public boolean isWindowsVistaOrBefore() {
        return this.isWindowsXpOrBefore() || this.isWindowsVista();
    }

    public boolean isWindows2000OrLater() {
        return this.isWindows2000() || this.isWindows2003OrLater();
    }

    public boolean isWindows2003OrLater() {
        return this.isWindows2003() || this.isWindowsXpOrLater();
    }

    public boolean isWindowsXpOrLater() {
        return !this.isWindows2003OrBefore();
    }

    public boolean isWindowsVistaOrLater() {
        return !this.isWindowsXpOrBefore();
    }

    public boolean isMacLeopardBeforeUpdate(int n) {
        if (!this.isMacLeopard()) {
            return false;
        }
        try {
            String string = this.getOsVersion();
            int n2 = string.lastIndexOf(".");
            int n3 = Integer.parseInt(string.substring(n2 + 1));
            return n3 < n;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public boolean isMacSnowLeopardUpdateOrAfter(int n) {
        if (!this.isMacSnowLeopard()) {
            return false;
        }
        try {
            return Integer.parseInt(OsInfo.getMacUpdateLevel()) >= n;
        }
        catch (Exception exception) {
            return true;
        }
    }

    public static int getMacUpdateLevelAsInt() {
        try {
            return new Integer(OsInfo.getMacUpdateLevel());
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
    }

    public static String getMacUpdateLevel() {
        try {
            return OsInfo.getMacUpdateLevel(System.getProperty("os.version"));
        }
        catch (Exception exception) {
            return "";
        }
    }

    public static String getMacUpdateLevel(String string) {
        if (string == null || string.length() == 0) {
            return "0";
        }
        try {
            int n = 0;
            int n2 = 0;
            while ((n2 = string.indexOf(".", n2)) >= 0) {
                ++n;
                ++n2;
            }
            if (n < 2) {
                return "0";
            }
            int n3 = string.lastIndexOf(".");
            int n4 = Integer.parseInt(string.substring(n3 + 1));
            return "" + n4;
        }
        catch (Exception exception) {
            return "0";
        }
    }
}

