/*
 * Decompiled with CFR 0.152.
 */
package com.cloudpath.common.util;

import java.io.IOException;
import java.net.Socket;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.List;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509ExtendedTrustManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CpnTrustManager
extends X509ExtendedTrustManager {
    private X509ExtendedTrustManager pkixTrustManager;

    public CpnTrustManager(List<X509Certificate> list) throws IOException, CertificateException, NoSuchAlgorithmException, KeyStoreException {
        KeyStore keyStore = KeyStore.getInstance("JKS");
        keyStore.load(null, null);
        for (int i = 0; list != null && i < list.size(); ++i) {
            keyStore.setCertificateEntry("Cert-" + i, list.get(i));
        }
        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance("PKIX");
        trustManagerFactory.init(keyStore);
        TrustManager[] trustManagerArray = trustManagerFactory.getTrustManagers();
        for (int i = 0; i < trustManagerArray.length; ++i) {
            if (!(trustManagerArray[i] instanceof X509ExtendedTrustManager)) continue;
            this.pkixTrustManager = (X509ExtendedTrustManager)trustManagerArray[i];
            return;
        }
    }

    @Override
    public void checkClientTrusted(X509Certificate[] x509CertificateArray, String string) throws CertificateException {
        this.pkixTrustManager.checkClientTrusted(x509CertificateArray, string);
    }

    @Override
    public void checkServerTrusted(X509Certificate[] x509CertificateArray, String string) throws CertificateException {
        this.pkixTrustManager.checkServerTrusted(x509CertificateArray, string);
    }

    @Override
    public void checkClientTrusted(X509Certificate[] x509CertificateArray, String string, Socket socket) throws CertificateException {
        this.pkixTrustManager.checkClientTrusted(x509CertificateArray, string, socket);
    }

    @Override
    public void checkClientTrusted(X509Certificate[] x509CertificateArray, String string, SSLEngine sSLEngine) throws CertificateException {
        this.pkixTrustManager.checkClientTrusted(x509CertificateArray, string, sSLEngine);
    }

    @Override
    public void checkServerTrusted(X509Certificate[] x509CertificateArray, String string, Socket socket) throws CertificateException {
        this.pkixTrustManager.checkServerTrusted(x509CertificateArray, string, socket);
    }

    @Override
    public void checkServerTrusted(X509Certificate[] x509CertificateArray, String string, SSLEngine sSLEngine) throws CertificateException {
        this.pkixTrustManager.checkServerTrusted(x509CertificateArray, string, sSLEngine);
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        return this.pkixTrustManager.getAcceptedIssuers();
    }
}

