/*
 * Decompiled with CFR 0.152.
 */
package com.cloudpath.common.pojo;

import com.cloudpath.common.parse.BasicHelper;
import com.cloudpath.common.parse.ElementAssignment;
import com.cloudpath.common.pojo.IpInfo;
import com.cloudpath.common.util.IpAddress;
import com.cloudpath.common.util.XmlUtil;
import org.apache.log4j.Logger;

public class NetworkInterface {
    private static final Logger log = Logger.getLogger(NetworkInterface.class);
    public static final ElementAssignment ELEMENT_ASSIGNMENT = new ElementAssignment("network_interface", new NetworkInterfaceHelper());
    public static final String ELEMENT = "network_interface";
    public static final String ELEMENT_INDEX = "index";
    public static final String ELEMENT_LOGICAL_GUID = "logical_guid";
    public static final String ELEMENT_NAME = "name";
    public static final String ELEMENT_INTERFACE_TYPE = "interface_type";
    public static final String ELEMENT_PHYSICAL_NAME = "physical_name";
    public static final String ELEMENT_MAC_ADDRESS = "mac_address";
    public static final String ELEMENT_DHCP_ENABLED = "dhcp_enabled";
    public static final String ELEMENT_IP_ADDRESS = "ip_address";
    public static final String ELEMENT_SUBNET_MASK = "subnet_mask";
    public static final String ELEMENT_DEFAULT_GATEWAY = "default_gateway";
    public static final String ELEMENT_GATEWAY_METRIC = "gateway_metric";
    public static final String ELEMENT_DNS_SERVER = "dns_server";
    public static final String ELEMENT_DHCP_LEASE_OBTAINED = "dhcp_lease_obtained";
    public static final String ELEMENT_MANUFACTURER = "manufacturer";
    public static final int INTERFACE_TYPE_BRIDGE = 0;
    public static final int INTERFACE_TYPE_WIRED = 1;
    public static final int INTERFACE_TYPE_WIRELESS = 2;
    public static final int INTERFACE_TYPE_OTHER = 3;
    private int cls_Index;
    private String cls_LogicalGuid;
    private String cls_Name;
    private int cls_InterfaceType;
    private String cls_PhysicalCardName;
    private String cls_MacAddress;
    private boolean cls_DhcpEnabled;
    private String cls_IpAddress;
    private String cls_SubnetMask;
    private String cls_DefaultGateway;
    private int cls_GatewayMetric;
    private String cls_DnsServer;
    private String cls_DhcpLeaseObtainedTimestamp;
    private String cls_Manufacturer;
    private String cls_DriverVersion;
    private String cls_DriverProvider;
    private String cls_ServiceName;
    public static final IpAddress LOCAL_LINK;

    public static int[] getAllInterfaceTypes() {
        return new int[]{0, 1, 2, 3};
    }

    public void setIndex(int n) {
        this.cls_Index = n;
    }

    public int getIndex() {
        return this.cls_Index;
    }

    public void setLogicalGuid(String string) {
        this.cls_LogicalGuid = string;
    }

    public String getLogicalGuid() {
        return this.cls_LogicalGuid;
    }

    public void setName(String string) {
        this.cls_Name = string;
    }

    public String getName() {
        return this.cls_Name;
    }

    public void setServiceName(String string) {
        this.cls_ServiceName = string;
    }

    public String getServiceName() {
        return this.cls_ServiceName;
    }

    public void setInterfaceType(int n) {
        this.cls_InterfaceType = n;
    }

    public int getInterfaceType() {
        return this.cls_InterfaceType;
    }

    public void setDriverVersion(String string) {
        this.cls_DriverVersion = string;
    }

    public String getDriverVersion() {
        return this.cls_DriverVersion;
    }

    public void setDriverProvider(String string) {
        this.cls_DriverProvider = string;
    }

    public String getDriverProvider() {
        return this.cls_DriverProvider;
    }

    public String getInterfaceTypeName() {
        if (this.getInterfaceType() == 2) {
            return "Wireless";
        }
        if (this.getInterfaceType() == 1) {
            return "Wired";
        }
        if (this.getInterfaceType() == 0) {
            return "Bridge";
        }
        return "Other";
    }

    public void setPhysicalCardName(String string) {
        this.cls_PhysicalCardName = string;
    }

    public String getPhysicalCardName() {
        return this.cls_PhysicalCardName;
    }

    public void setMacAddress(String string) {
        this.cls_MacAddress = string;
    }

    public String getMacAddress() {
        return this.cls_MacAddress;
    }

    public String getNicId() {
        if (this.getMacAddress() != null && this.getMacAddress().length() > 0) {
            return this.getMacAddress().toLowerCase();
        }
        return "";
    }

    public void setDhcpEnabled(boolean bl) {
        this.cls_DhcpEnabled = bl;
    }

    public boolean getDhcpEnabled() {
        return this.cls_DhcpEnabled;
    }

    public void setIpAddress(String string) {
        this.cls_IpAddress = string;
    }

    public String getIpAddress() {
        return this.cls_IpAddress;
    }

    public void setSubnetMask(String string) {
        this.cls_SubnetMask = string;
    }

    public String getSubnetMask() {
        return this.cls_SubnetMask;
    }

    public void setDefaultGateway(String string) {
        this.cls_DefaultGateway = string;
    }

    public String getDefaultGateway() {
        return this.cls_DefaultGateway;
    }

    public void setGatewayMetric(int n) {
        this.cls_GatewayMetric = n;
    }

    public int getGatewayMetric() {
        return this.cls_GatewayMetric;
    }

    public void setDnsServer(String string) {
        this.cls_DnsServer = string;
    }

    public String getDnsServer() {
        return this.cls_DnsServer;
    }

    public void setDhcpLeaseObtainedTimestamp(String string) {
        this.cls_DhcpLeaseObtainedTimestamp = string;
    }

    public String getDhcpLeaseObtainedTimestamp() {
        return this.cls_DhcpLeaseObtainedTimestamp;
    }

    public void setManufacturer(String string) {
        this.cls_Manufacturer = string;
    }

    public String getManufacturer() {
        return this.cls_Manufacturer;
    }

    public IpInfo getIpInfo() {
        IpInfo ipInfo = new IpInfo();
        ipInfo.setIp(this.getIpAddress());
        ipInfo.setMask(this.getSubnetMask());
        ipInfo.setGateway(this.getDefaultGateway());
        ipInfo.setGatewayMetric(this.getGatewayMetric());
        return ipInfo;
    }

    public String toString() {
        return "[NetworkInterface name: " + this.getName() + " physical: " + this.getPhysicalCardName() + "]";
    }

    public static boolean isIpAddressInSubnets(String string, String[] stringArray) {
        if (stringArray == null || stringArray.length == 0) {
            return true;
        }
        try {
            IpAddress ipAddress = new IpAddress(string);
            for (int i = 0; i < stringArray.length; ++i) {
                try {
                    IpAddress ipAddress2 = new IpAddress(stringArray[i]);
                    if (!ipAddress2.includes(ipAddress)) continue;
                    return true;
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return false;
    }

    public static boolean isValidIpAddress(String string) {
        if (string == null || string.length() < 7 || "0.0.0.0".equals(string)) {
            return false;
        }
        try {
            IpAddress ipAddress = new IpAddress(string);
            if (LOCAL_LINK.includes(ipAddress)) {
                return false;
            }
        }
        catch (Exception exception) {
            log.warn((Object)("Ip address '" + string + "' failed to parse."), (Throwable)exception);
            return false;
        }
        return true;
    }

    public String getXml() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(XmlUtil.createElementOpen(ELEMENT));
        stringBuffer.append(XmlUtil.createElement(ELEMENT_INDEX, "" + this.getIndex()));
        stringBuffer.append(XmlUtil.createElement(ELEMENT_LOGICAL_GUID, this.getLogicalGuid()));
        stringBuffer.append(XmlUtil.createElement(ELEMENT_NAME, this.getName()));
        stringBuffer.append(XmlUtil.createElement(ELEMENT_INTERFACE_TYPE, "" + this.getInterfaceType()));
        stringBuffer.append(XmlUtil.createElement(ELEMENT_PHYSICAL_NAME, this.getPhysicalCardName()));
        stringBuffer.append(XmlUtil.createElement(ELEMENT_MAC_ADDRESS, this.getMacAddress()));
        stringBuffer.append(XmlUtil.createElement(ELEMENT_DHCP_ENABLED, "" + XmlUtil.getBooleanAsInt(this.getDhcpEnabled())));
        stringBuffer.append(XmlUtil.createElement(ELEMENT_IP_ADDRESS, this.getIpAddress()));
        stringBuffer.append(XmlUtil.createElement(ELEMENT_SUBNET_MASK, this.getSubnetMask()));
        stringBuffer.append(XmlUtil.createElement(ELEMENT_DEFAULT_GATEWAY, this.getDefaultGateway()));
        stringBuffer.append(XmlUtil.createElement(ELEMENT_GATEWAY_METRIC, "" + this.getGatewayMetric()));
        stringBuffer.append(XmlUtil.createElement(ELEMENT_DNS_SERVER, this.getDnsServer()));
        stringBuffer.append(XmlUtil.createElement(ELEMENT_DHCP_LEASE_OBTAINED, this.getDhcpLeaseObtainedTimestamp()));
        stringBuffer.append(XmlUtil.createElement(ELEMENT_MANUFACTURER, this.getManufacturer()));
        stringBuffer.append(XmlUtil.createElementClose(ELEMENT));
        return stringBuffer.toString();
    }

    public void setProperty(String string, String string2) {
        if (ELEMENT_INDEX.equals(string)) {
            this.setIndex(XmlUtil.getStringAsInt(string2, 0));
        } else if (ELEMENT_LOGICAL_GUID.equals(string)) {
            this.setLogicalGuid(string2);
        } else if (ELEMENT_NAME.equals(string)) {
            this.setName(string2);
        } else if (ELEMENT_INTERFACE_TYPE.equals(string)) {
            this.setInterfaceType(XmlUtil.getStringAsInt(string2, 1));
        } else if (ELEMENT_PHYSICAL_NAME.equals(string)) {
            this.setPhysicalCardName(string2);
        } else if (ELEMENT_MAC_ADDRESS.equals(string)) {
            this.setMacAddress(string2);
        } else if (ELEMENT_DHCP_ENABLED.equals(string)) {
            this.setDhcpEnabled(XmlUtil.getStringAsBoolean(string2, true));
        } else if (ELEMENT_IP_ADDRESS.equals(string)) {
            this.setIpAddress(string2);
        } else if (ELEMENT_SUBNET_MASK.equals(string)) {
            this.setSubnetMask(string2);
        } else if (ELEMENT_DEFAULT_GATEWAY.equals(string)) {
            this.setDefaultGateway(string2);
        } else if (ELEMENT_GATEWAY_METRIC.equals(string)) {
            this.setGatewayMetric(XmlUtil.getStringAsInt(string2, 0));
        } else if (ELEMENT_DNS_SERVER.equals(string)) {
            this.setDnsServer(string2);
        } else if (ELEMENT_DHCP_LEASE_OBTAINED.equals(string)) {
            this.setDhcpLeaseObtainedTimestamp(string2);
        } else if (ELEMENT_MANUFACTURER.equals(string)) {
            this.setManufacturer(string2);
        }
    }

    static {
        IpAddress ipAddress = null;
        try {
            ipAddress = new IpAddress("169.254.0.0/16");
        }
        catch (Exception exception) {
            // empty catch block
        }
        LOCAL_LINK = ipAddress;
    }

    public static class NetworkInterfaceHelper
    extends BasicHelper {
        public NetworkInterfaceHelper() {
            super(NetworkInterface.ELEMENT);
        }

        public Object getNewInstance() {
            return new NetworkInterface();
        }

        public void setValue(Object object, String string, String string2) {
            NetworkInterface networkInterface = (NetworkInterface)object;
            if (!this.getElement().equals(string)) {
                networkInterface.setProperty(string, string2);
            }
        }

        public void parseComplete(Object object) {
        }

        public void addChild(Object object, Object object2, String string) {
            this.unrecognizedChild(object2);
        }
    }
}

