/*
 * Decompiled with CFR 0.152.
 */
package com.cloudpath.common.pojo;

import com.cloudpath.common.util.IpAddress;
import java.util.ArrayList;

public class IpSet {
    private static final IpSet LOCAL_LINK = new IpSet("169.254.1.1/16");
    private String cls_IpList = "";
    private IpAddress[] cls_Ips = new IpAddress[0];

    public IpSet() {
    }

    public IpSet(String string) {
        this.parseList(string);
    }

    public void parseList(String string) {
        if (string == null) {
            string = "";
        }
        this.cls_IpList = string;
        String[] stringArray = string.split(";");
        ArrayList<IpAddress> arrayList = new ArrayList<IpAddress>();
        for (int i = 0; i < stringArray.length; ++i) {
            try {
                arrayList.add(new IpAddress(stringArray[i]));
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.cls_Ips = new IpAddress[arrayList.size()];
        arrayList.toArray(this.cls_Ips);
    }

    public String getList() {
        return this.cls_IpList;
    }

    public boolean includesIpAddress(String string) {
        IpAddress ipAddress = null;
        try {
            ipAddress = new IpAddress(string);
        }
        catch (Exception exception) {
            return false;
        }
        for (int i = 0; i < this.cls_Ips.length; ++i) {
            if (!this.cls_Ips[i].includes(ipAddress)) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return this.cls_IpList;
    }

    public static boolean isValidIpAddress(String string) {
        if (string == null || string.length() < 7) {
            return false;
        }
        if ("0.0.0.0".equals(string)) {
            return false;
        }
        if ("127.0.0.1".equals(string)) {
            return false;
        }
        return !LOCAL_LINK.includesIpAddress(string);
    }
}

