/*
 * Decompiled with CFR 0.152.
 */
package com.cloudpath.common.persistence;

import com.cloudpath.common.persistence.InvalidPersistenceException;
import com.cloudpath.common.persistence.ObjectPersistence;
import com.cloudpath.common.util.FileUtil;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import javax.jnlp.BasicService;
import javax.jnlp.FileContents;
import javax.jnlp.PersistenceService;
import javax.jnlp.ServiceManager;
import javax.jnlp.UnavailableServiceException;
import org.apache.log4j.Logger;

public class WebStartPersistence
implements ObjectPersistence {
    private static final Logger log = Logger.getLogger(WebStartPersistence.class);
    private static final PersistenceService PERSISTENCE_SERVICE;
    private static final BasicService BASIC_SERVICE;
    private static final URL CODE_BASE;

    public WebStartPersistence() throws InvalidPersistenceException {
        if (PERSISTENCE_SERVICE == null && BASIC_SERVICE == null && CODE_BASE == null) {
            throw new InvalidPersistenceException("Object was not properly initialized. Persistence: " + (PERSISTENCE_SERVICE != null) + " Basic: " + (BASIC_SERVICE != null) + " Codebase: " + (CODE_BASE != null), null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public String read(String string, String string2) throws InvalidPersistenceException {
        String string3;
        URL uRL;
        InputStream inputStream;
        block12: {
            log.debug((Object)("Will read object '" + string2 + "'."));
            inputStream = null;
            uRL = this.getObjectUrl(string, string2);
            log.debug((Object)("Will read from " + uRL));
            FileContents fileContents = PERSISTENCE_SERVICE.get(uRL);
            byte[] byArray = new byte[(int)fileContents.getLength()];
            inputStream = fileContents.getInputStream();
            long l = 0L;
            while ((l = (long)inputStream.read(byArray, (int)l, (int)((long)byArray.length - l))) > 0L) {
            }
            string3 = new String(byArray);
            Object var11_13 = null;
            if (inputStream == null) break block12;
            try {
                inputStream.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return string3;
        catch (FileNotFoundException fileNotFoundException) {
            String string4;
            block13: {
                log.info((Object)("Object '" + string2 + "' was not found."));
                string4 = null;
                Object var11_14 = null;
                if (inputStream == null) break block13;
                try {
                    inputStream.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return string4;
        }
        catch (IOException iOException) {
            String string5;
            block14: {
                WebStartPersistence.handleIOException(string2, "read from", uRL, iOException);
                string5 = null;
                Object var11_15 = null;
                if (inputStream == null) break block14;
                {
                    catch (Throwable throwable) {
                        block15: {
                            Object var11_16 = null;
                            if (inputStream == null) break block15;
                            try {
                                inputStream.close();
                            }
                            catch (Exception exception) {}
                        }
                        throw throwable;
                    }
                }
                try {
                    inputStream.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return string5;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void save(String string, String string2, String string3) throws InvalidPersistenceException {
        log.debug((Object)("Will save object '" + string2 + "'."));
        OutputStream outputStream = null;
        URL uRL = this.getObjectUrl(string, string2);
        log.debug((Object)("Will read from " + uRL));
        try {
            PERSISTENCE_SERVICE.delete(uRL);
        }
        catch (Exception exception) {
            // empty catch block
        }
        PERSISTENCE_SERVICE.create(uRL, (long)string3.length());
        FileContents fileContents = PERSISTENCE_SERVICE.get(uRL);
        outputStream = fileContents.getOutputStream(false);
        outputStream.write(string3.getBytes());
        Object var8_9 = null;
        if (outputStream == null) return;
        try {
            outputStream.close();
            return;
        }
        catch (Exception exception) {}
        return;
        {
            catch (IOException iOException) {
                WebStartPersistence.handleIOException(string2, "saved to", uRL, iOException);
                Object var8_10 = null;
                if (outputStream == null) return;
                try {
                    outputStream.close();
                    return;
                }
                catch (Exception exception) {}
                return;
            }
        }
        catch (Throwable throwable) {
            Object var8_11 = null;
            if (outputStream == null) throw throwable;
            try {
                outputStream.close();
                throw throwable;
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void delete(String string, String string2) throws InvalidPersistenceException {
        log.debug((Object)("Will delete object '" + string2 + "'."));
        OutputStream outputStream = null;
        URL uRL = this.getObjectUrl(string, string2);
        log.debug((Object)("Will delete from " + uRL));
        PERSISTENCE_SERVICE.delete(uRL);
        Object var7_5 = null;
        if (outputStream == null) return;
        try {
            outputStream.close();
            return;
        }
        catch (Exception exception) {}
        return;
        {
            catch (IOException iOException) {
                WebStartPersistence.handleIOException(string2, "deleted from", uRL, iOException);
                Object var7_6 = null;
                if (outputStream == null) return;
                try {
                    outputStream.close();
                    return;
                }
                catch (Exception exception) {}
                return;
            }
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            if (outputStream == null) throw throwable;
            try {
                outputStream.close();
                throw throwable;
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw throwable;
        }
    }

    public String[] getAll(String string) throws InvalidPersistenceException {
        String[] stringArray;
        log.debug((Object)("Will get all objects of type '" + string + "'."));
        URL uRL = CODE_BASE;
        try {
            stringArray = PERSISTENCE_SERVICE.getNames(uRL);
        }
        catch (IOException iOException) {
            WebStartPersistence.handleIOException("all", "queried from", uRL, iOException);
            return null;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        String string2 = string + "_";
        for (int i = 0; i < stringArray.length; ++i) {
            String string3 = FileUtil.unsterilizeFileName(stringArray[i]);
            if (!string3.startsWith(string2)) continue;
            arrayList.add(string3.substring(string2.length()));
        }
        String[] stringArray2 = new String[arrayList.size()];
        arrayList.toArray(stringArray2);
        log.debug((Object)("Returning " + stringArray2.length + " objects."));
        return stringArray2;
    }

    private URL getObjectUrl(String string, String string2) throws InvalidPersistenceException {
        String string3 = CODE_BASE.toString() + FileUtil.sterilizeFileName(string) + "_" + (string2 != null ? FileUtil.sterilizeFileName(string2) : "");
        try {
            return new URL(string3);
        }
        catch (MalformedURLException malformedURLException) {
            throw new InvalidPersistenceException("Object '" + string2 + " could not be read from '" + string3 + "' because URL is malformed.", malformedURLException);
        }
    }

    private static void handleIOException(String string, String string2, URL uRL, IOException iOException) throws InvalidPersistenceException {
        throw new InvalidPersistenceException("Object '" + string + " could not be " + string2 + " '" + uRL + "' because an IO error occurred.", iOException);
    }

    static {
        PersistenceService persistenceService = null;
        BasicService basicService = null;
        try {
            persistenceService = (PersistenceService)ServiceManager.lookup((String)"javax.jnlp.PersistenceService");
            basicService = (BasicService)ServiceManager.lookup((String)"javax.jnlp.BasicService");
            log.debug((Object)"Services loaded.");
        }
        catch (UnavailableServiceException unavailableServiceException) {
            log.info((Object)"Unable to lookup persistence and basic services.");
        }
        PERSISTENCE_SERVICE = persistenceService;
        BASIC_SERVICE = basicService;
        CODE_BASE = BASIC_SERVICE != null ? BASIC_SERVICE.getCodeBase() : null;
    }
}

