/*
 * Decompiled with CFR 0.152.
 */
package com.cloudpath.common.persistence;

import com.cloudpath.common.persistence.InvalidPersistenceException;
import com.cloudpath.common.persistence.ObjectPersistence;
import com.cloudpath.common.util.FileUtil;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.log4j.Logger;

public class TemporaryFilePersistence
implements ObjectPersistence {
    private static final Logger log = Logger.getLogger(TemporaryFilePersistence.class);
    private static final String EXTENSION = ".cpn";
    private final File cls_TempDirectory;

    public TemporaryFilePersistence(String string) throws InvalidPersistenceException {
        File file;
        if (System.getProperty("java.io.tempdir") != null) {
            file = new File(System.getProperty("java.io.tempdir"));
        } else {
            try {
                File file2 = File.createTempFile("exe", ".tmp");
                file = file2.getParentFile();
                if (!file2.delete()) {
                    file2.deleteOnExit();
                }
            }
            catch (IOException iOException) {
                file = null;
            }
        }
        this.cls_TempDirectory = new File(file, string);
        if (!this.cls_TempDirectory.exists()) {
            this.cls_TempDirectory.mkdirs();
        }
        if (this.cls_TempDirectory == null || !this.cls_TempDirectory.exists()) {
            throw new InvalidPersistenceException("Object was not properly initialized. No such directory: " + this.cls_TempDirectory, null);
        }
    }

    public String read(String string, String string2) throws InvalidPersistenceException {
        log.debug((Object)("Will read object '" + string2 + "' of type " + string + "."));
        File file = this.getObjectFile(string, string2);
        try {
            log.debug((Object)("Will read from " + file));
            return FileUtil.read(file);
        }
        catch (FileNotFoundException fileNotFoundException) {
            log.info((Object)("Object '" + string2 + "' was not found at " + file.getAbsolutePath() + "."));
            return null;
        }
        catch (IOException iOException) {
            TemporaryFilePersistence.handleIOException(string, string2, "read from", file.getAbsolutePath(), iOException);
            return null;
        }
    }

    public void save(String string, String string2, String string3) throws InvalidPersistenceException {
        log.debug((Object)("Will save object '" + string2 + "' of type '" + string + "'."));
        File file = this.getObjectFile(string, string2);
        try {
            log.debug((Object)("Will save to " + file));
            if (file.getParent() != null && !file.getParentFile().exists()) {
                file.getParentFile().mkdirs();
            }
            FileUtil.write(file.getAbsolutePath(), string3);
        }
        catch (IOException iOException) {
            TemporaryFilePersistence.handleIOException(string, string2, "saved to", file.getAbsolutePath(), iOException);
        }
    }

    public void delete(String string, String string2) throws InvalidPersistenceException {
        log.debug((Object)("Will delete object '" + string2 + "' of type '" + string + "'."));
        File file = this.getObjectFile(string, string2);
        log.debug((Object)("Will delete from " + file.getAbsolutePath()));
        if (file.exists() && !file.delete()) {
            TemporaryFilePersistence.handleIOException(string, string2, "deleted from", file.getAbsolutePath(), null);
        }
    }

    public String[] getAll(String string) throws InvalidPersistenceException {
        log.debug((Object)("Will get all objects of type '" + string + "'."));
        File file = this.getObjectFile(string, null);
        if (!file.exists()) {
            return new String[0];
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        File[] fileArray = file.listFiles();
        for (int i = 0; i < fileArray.length; ++i) {
            if (!fileArray[i].isFile()) continue;
            String string2 = FileUtil.unsterilizeFileName(fileArray[i].getName());
            if (string2.endsWith(EXTENSION)) {
                string2 = string2.substring(0, string2.length() - EXTENSION.length());
            }
            arrayList.add(string2);
        }
        String[] stringArray = new String[arrayList.size()];
        arrayList.toArray(stringArray);
        log.debug((Object)("Returning " + stringArray.length + " objects."));
        return stringArray;
    }

    public void removeTempDirectory() {
        this.cls_TempDirectory.delete();
    }

    private File getObjectFile(String string, String string2) {
        File file = new File(this.cls_TempDirectory, FileUtil.sterilizeFileName(string));
        if (string2 == null) {
            return file;
        }
        return new File(file, FileUtil.sterilizeFileName(string2) + EXTENSION);
    }

    private static void handleIOException(String string, String string2, String string3, String string4, IOException iOException) throws InvalidPersistenceException {
        throw new InvalidPersistenceException("Object '" + string2 + " of type '" + string + "' could not be " + string3 + " '" + string4 + "' because an IO error occurred.", iOException);
    }
}

