/*
 * Decompiled with CFR 0.152.
 */
package com.cloudpath.common.os.windows.util.antivirus;

import com.cloudpath.common.os.windows.util.RegistryKey;
import com.cloudpath.common.os.windows.util.Wzccmd;
import com.cloudpath.common.os.windows.util.antivirus.AntivirusHelper;
import com.cloudpath.common.util.BinaryUtil;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import org.apache.log4j.Logger;

public class McAfeeAvHelper
implements AntivirusHelper {
    private static final Logger log = Logger.getLogger(McAfeeAvHelper.class);
    public static final RegistryKey DAT_DATE = new RegistryKey("HKEY_LOCAL_MACHINE", "SOFTWARE\\McAfee\\AvEngine", "AVDatDate", "REG_SZ");
    public static final RegistryKey SCAN_DATE = new RegistryKey("HKEY_LOCAL_MACHINE", "SOFTWARE\\McAfee\\VsCore\\VirusScanner\\ScheduledScan", "PreviousScanTime", "REG_BINARY");
    private static final SimpleDateFormat DAT_DATE_FORMAT = new SimpleDateFormat("yyyy/MM/dd", Locale.US);
    private static final long JAN_1_2000_IN_MFU = new Long("4675252908797722624");
    private static final long MFUS_PER_DAY = new Long("137438953472");
    private static final long JAN_1_2000_IN_MILLIS = new Long("946710000000");
    private static final long MILLIS_PER_DAY = 86400000L;
    private final Wzccmd cls_Wzccmd;

    public McAfeeAvHelper(Wzccmd wzccmd) {
        this.cls_Wzccmd = wzccmd;
    }

    public long getLastDatUpdateTimestamp() {
        String string = this.cls_Wzccmd.getRegistryKey(DAT_DATE);
        if (string != null && string.length() > 0) {
            try {
                Date date = DAT_DATE_FORMAT.parse(string);
                if (date != null) {
                    return date.getTime();
                }
            }
            catch (ParseException parseException) {
                log.warn((Object)("Failed to parse McAfee timestamp of '" + string + "'."));
            }
        }
        return 0L;
    }

    public long getLastScanExecutionTimestamp() {
        String string = this.cls_Wzccmd.getRegistryKey(SCAN_DATE);
        if (string != null && string.length() > 0) {
            log.debug((Object)("Last scan time read as " + BinaryUtil.convertToHex(string)));
            return McAfeeAvHelper.convertMfuToMillis(string);
        }
        return 0L;
    }

    public static final long convertMfuToMillis(String string) {
        long l = 0L;
        for (int i = string.length() - 1; i >= 0; --i) {
            char c = string.charAt(i);
            l = (long)((double)l + (double)c * Math.pow(2.0, 8 * i));
        }
        long l2 = l - JAN_1_2000_IN_MFU;
        long l3 = l2 / MFUS_PER_DAY;
        long l4 = JAN_1_2000_IN_MILLIS + 86400000L * l3;
        return l4;
    }
}

