/*
 * Decompiled with CFR 0.152.
 */
package com.cloudpath.common.os.windows.util;

import com.cloudpath.common.util.XmlUtil;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Properties;
import org.apache.log4j.Logger;

public class WmiRecord {
    private static final Logger log = Logger.getLogger(WmiRecord.class);
    private final Properties cls_Properties;
    private final HashMap<String, String> cls_Keys = new HashMap();

    public WmiRecord(String string) {
        this.cls_Properties = new Properties();
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string.getBytes());
        try {
            this.cls_Properties.load(byteArrayInputStream);
        }
        catch (IOException iOException) {
            log.warn((Object)("Failed to load properties from:\n" + string), (Throwable)iOException);
        }
        String[] stringArray = new String[this.cls_Properties.size()];
        this.cls_Properties.keySet().toArray(stringArray);
        for (int i = 0; i < stringArray.length; ++i) {
            this.cls_Keys.put(stringArray[i].toLowerCase(), stringArray[i]);
        }
    }

    private String getCaseName(String string) {
        String string2 = this.cls_Keys.get(string.toLowerCase());
        if (string2 == null) {
            string2 = string;
        }
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getProperties() {
        String[] stringArray;
        Properties properties = this.cls_Properties;
        synchronized (properties) {
            stringArray = new String[this.cls_Properties.size()];
            this.cls_Properties.keySet().toArray(stringArray);
        }
        return stringArray;
    }

    public boolean hasProperty(String string) {
        return this.cls_Properties.containsKey(this.getCaseName(string));
    }

    public String getString(String string, String string2) {
        return this.cls_Properties.getProperty(this.getCaseName(string), string2);
    }

    public int getInt(String string, int n) {
        return XmlUtil.getStringAsInt(this.cls_Properties.getProperty(this.getCaseName(string)), n);
    }

    public long getLong(String string, long l) {
        return XmlUtil.getStringAsLong(this.cls_Properties.getProperty(this.getCaseName(string)), l);
    }

    public boolean getBoolean(String string, boolean bl) {
        return XmlUtil.getStringAsBoolean(this.cls_Properties.getProperty(this.getCaseName(string)), bl);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        Object[] objectArray = this.cls_Properties.keySet().toArray();
        for (int i = 0; i < objectArray.length; ++i) {
            stringBuffer.append(objectArray[i] + "=" + this.cls_Properties.getProperty((String)objectArray[i]) + '\n');
        }
        return stringBuffer.toString();
    }

    public String toXml(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        Object[] objectArray = this.cls_Properties.keySet().toArray();
        stringBuffer.append(XmlUtil.createElementOpen(string));
        for (int i = 0; i < objectArray.length; ++i) {
            stringBuffer.append(XmlUtil.createElement((String)objectArray[i], this.cls_Properties.getProperty((String)objectArray[i])));
        }
        stringBuffer.append(XmlUtil.createElementClose(string));
        return stringBuffer.toString();
    }
}

