/*
 * Decompiled with CFR 0.152.
 */
package com.cloudpath.common.os.windows.p2p;

import com.cloudpath.common.command.CommandHandler;
import com.cloudpath.common.command.CommandResponse;
import com.cloudpath.common.os.windows.p2p.P2p;
import com.cloudpath.common.os.windows.util.ProcessDetail;
import com.cloudpath.common.os.windows.util.ProcessDetails;
import com.cloudpath.common.os.windows.util.RegistryKey;
import com.cloudpath.common.os.windows.util.Wzccmd;
import com.cloudpath.common.util.Util;
import java.io.File;
import java.io.IOException;
import org.apache.log4j.Logger;

public class Emule
implements P2p {
    private static final Logger log = Logger.getLogger(Emule.class);
    public static final String EMULE = "EMULE";
    public static final RegistryKey INSTALL_PATH = new RegistryKey("HKEY_CURRENT_USER", "SOFTWARE\\eMule", "Install Path", "REG_SZ");
    public static final RegistryKey UNINSTALL_PATH = new RegistryKey("HKEY_LOCAL_MACHINE", "SOFTWARE\\Microsoft\\Windows\\CurrentVersion\\Uninstall\\eMule", "UninstallString", "REG_SZ");
    public static final String EXE_NAME = "eMule.exe";
    private final Wzccmd cls_Wzccmd;
    private final CommandHandler cls_CommandHandler;

    public Emule(Wzccmd wzccmd, CommandHandler commandHandler) {
        this.cls_Wzccmd = wzccmd;
        this.cls_CommandHandler = commandHandler;
    }

    public String[] getInstalledNames(ProcessDetails processDetails) {
        if (this.isInstalled(processDetails)) {
            return new String[]{EMULE};
        }
        return new String[0];
    }

    public boolean isInstalled(ProcessDetails processDetails) {
        Object object;
        Object object2;
        log.debug((Object)("Will check if " + Util.getClassName(this) + " is installed..."));
        log.debug((Object)"Will check install path...");
        String string = this.cls_Wzccmd.getRegistryKey(INSTALL_PATH);
        if (string != null && ((File)(object2 = new File(string))).exists()) {
            log.info((Object)(Util.getClassName(this) + " is installed (1)."));
            return true;
        }
        log.debug((Object)"Will check uninstall path...");
        object2 = this.cls_Wzccmd.getRegistryKey(UNINSTALL_PATH);
        if (object2 != null && ((File)(object = new File((String)(object2 = Util.trimQuotes((String)object2))))).exists()) {
            log.info((Object)(Util.getClassName(this) + " is installed (2)."));
            return true;
        }
        log.debug((Object)"Will check executable...");
        object = processDetails.getProcessesByOriginalName(EXE_NAME);
        if (((ProcessDetail[])object).length > 0) {
            log.info((Object)(Util.getClassName(this) + " is installed (3)."));
            return true;
        }
        log.debug((Object)(Util.getClassName(this) + " not found to be installed."));
        return false;
    }

    public String[] getRunningNames(ProcessDetails processDetails) {
        if (this.isRunning(processDetails)) {
            return new String[]{EMULE};
        }
        return new String[0];
    }

    public boolean isRunning(ProcessDetails processDetails) {
        ProcessDetail[] processDetailArray = processDetails.getProcessesByOriginalName(EXE_NAME);
        return processDetailArray.length > 0;
    }

    public void shutoff(ProcessDetails processDetails) {
        ProcessDetail[] processDetailArray = processDetails.getProcessesByOriginalName(EXE_NAME);
        for (int i = 0; i < processDetailArray.length; ++i) {
            this.cls_Wzccmd.setProcessState(processDetailArray[i].getExeName(), false);
        }
    }

    public void uninstall(ProcessDetails processDetails) {
        this.shutoff(processDetails);
        String string = this.cls_Wzccmd.getRegistryKey(UNINSTALL_PATH);
        if (string != null) {
            Object object;
            String[] stringArray = new String[]{string, "/S"};
            try {
                object = this.cls_CommandHandler.executeCommand(stringArray);
                ((CommandResponse)object).waitFor();
                try {
                    Thread.sleep(1000L);
                }
                catch (Exception exception) {}
            }
            catch (IOException iOException) {
                log.warn((Object)("Error while waiting for " + Util.getClassName(this) + "uninstall."), (Throwable)iOException);
            }
            log.warn((Object)("Value is '" + string + "'."));
            string = Util.trimQuotes(string);
            object = new File(string);
            File file = ((File)object).getParentFile();
            log.warn((Object)("Will delete folder " + file.getAbsolutePath()));
            if (!file.delete()) {
                log.warn((Object)"Will attempt to delete on exit.");
                file.deleteOnExit();
                File[] fileArray = file.listFiles();
                for (int i = 0; i < fileArray.length; ++i) {
                    if (fileArray[i].delete()) continue;
                    fileArray[i].deleteOnExit();
                }
            }
        }
    }
}

