/*
 * Decompiled with CFR 0.152.
 */
package com.cloudpath.common.os.mac.tiger.network.airport;

import com.cloudpath.common.command.CommandHandler;
import com.cloudpath.common.os.common.WirelessAssociation;
import com.cloudpath.common.os.mac.common.MacUtil;
import com.cloudpath.common.os.mac.common.network.airport.AbstractAirportReader;
import com.cloudpath.common.os.mac.tiger.network.airport.TigerAirportAssociation;
import com.cloudpath.common.os.mac.tiger.network.internetconnect.InternetConnect;
import com.cloudpath.common.os.mac.tiger.network.internetconnect.InternetConnectPlist;
import com.cloudpath.common.util.FileHandler;
import com.cloudpath.common.util.Util;
import java.io.IOException;
import org.apache.log4j.Logger;

public class TigerAirportReader
extends AbstractAirportReader {
    private static final Logger log = Logger.getLogger(TigerAirportReader.class);
    private final InternetConnect cls_InternetConnect;

    public TigerAirportReader(FileHandler fileHandler, CommandHandler commandHandler) {
        super(fileHandler, commandHandler);
        this.cls_InternetConnect = new InternetConnect(fileHandler, commandHandler);
    }

    public final WirelessAssociation getCurrentAssociation(String string) throws Exception {
        String[] stringArray = this.execute(new String[]{"/System/Library/PrivateFrameworks/Apple80211.framework/Versions/Current/Resources/airport", "-I"}, false);
        TigerAirportAssociation tigerAirportAssociation = new TigerAirportAssociation(Util.join(stringArray));
        log.debug((Object)("Association is: " + tigerAirportAssociation));
        return tigerAirportAssociation;
    }

    public boolean setPowerState(String string, boolean bl) {
        return false;
    }

    public void connectToDot1xSsid(String string, String string2) {
        try {
            log.debug((Object)"Will update internet connect.");
            InternetConnectPlist internetConnectPlist = this.cls_InternetConnect.read();
            internetConnectPlist.set8021X(true);
            internetConnectPlist.setServiceIdTo8021x();
            internetConnectPlist.setCollapseWindow(false);
            internetConnectPlist.setSelected8021xProfile(string2);
            internetConnectPlist.setLocation(725, 368);
            if (internetConnectPlist.isDirty()) {
                this.cls_InternetConnect.write(internetConnectPlist);
            }
        }
        catch (Exception exception) {
            log.error((Object)"An error occured while attempting to update internetConnect file.", (Throwable)exception);
        }
        try {
            log.debug((Object)"Will open internet connect.");
            InternetConnect.openApplication(this.getCommandHandler(), this.getFileHandler(), true);
        }
        catch (IOException iOException) {
            log.error((Object)"Error occurred while attempting to open internet connect.", (Throwable)iOException);
        }
    }

    public void disconnect(String string) throws Exception {
        String string2 = "tell application \"Internet Connect\"\ndisconnect\ndisconnect\nquit\nend tell";
        MacUtil.runApplescript(this.getCommandHandler(), this.getFileHandler(), string2);
    }

    public void abandon() throws IOException {
        InternetConnect.killApplication(this.getCommandHandler());
    }

    public void associationComplete() throws Exception {
        log.debug((Object)"Association was completed.");
        String string = "tell application \"Internet Connect\"\nsave\nquit\nend tell";
        MacUtil.runApplescript(this.getCommandHandler(), this.getFileHandler(), string);
    }

    public boolean ssidIsInScanList(String string, String string2) {
        return true;
    }
}

