/*
 * Decompiled with CFR 0.152.
 */
package com.cloudpath.common.os.mac.tiger.network.airport;

import com.cloudpath.common.os.common.WirelessAssociation;
import com.cloudpath.common.os.mac.common.MacUtil;
import com.cloudpath.common.util.XmlUtil;
import org.apache.log4j.Logger;

public class TigerAirportAssociation
implements WirelessAssociation {
    private static final Logger log = Logger.getLogger(TigerAirportAssociation.class);
    private static final String SSID = "SSID: ";
    private static final String LINK_STATUS = "linkStatus: ";
    private static final String LAST_ASSOCIATION_STATUS = "lastAssocStatus: ";
    private static final String LAST_TX_RATE = "lastTxRate: ";
    private static final String AIRPORT_OFF = "AirPort: Off";
    private static final String LINK_STATUS_DISABLED = "Disabled";
    private static final String LINK_STATUS_SEARCHING = "Searching";
    private boolean cls_IsEnabled = true;
    private String cls_Ssid = "";
    private int cls_LastAssociationStatus = 0;
    private String cls_LinkStatus = "";
    private int cls_LastTxRate = 0;
    private Status cls_Status;

    public TigerAirportAssociation(String string) {
        String[] stringArray = string.split("\n");
        for (int i = 0; i < stringArray.length; ++i) {
            this.parseLine(stringArray[i]);
        }
        this.cls_Status = !this.isEnabled() || LINK_STATUS_DISABLED.equals(this.getLinkStatus()) ? Status.DISCONNECTED : (LINK_STATUS_SEARCHING.equals(this.getLinkStatus()) ? Status.STARTING_AUTH : (this.getLastTxRate() == 1 && this.getLastAssociationStatus() == 1 ? Status.WAITING_FOR_CERT : (this.getLastAssociationStatus() == 2 && this.getLastTxRate() > 1 ? Status.WAITING_FOR_CERT : Status.ASSOCIATED)));
        log.debug((Object)("Determined status to be " + (Object)((Object)this.cls_Status)));
    }

    public boolean isEnabled() {
        return this.cls_IsEnabled;
    }

    public boolean isAssociated() {
        return Status.ASSOCIATED.equals((Object)this.cls_Status);
    }

    public String getSsid() {
        return this.cls_Ssid;
    }

    public String getLinkStatus() {
        return this.cls_LinkStatus;
    }

    public int getLastAssociationStatus() {
        return this.cls_LastAssociationStatus;
    }

    public int getLastTxRate() {
        return this.cls_LastTxRate;
    }

    public boolean isWpa2() {
        log.error((Object)"isWpa2 not currently supported on Tiger.");
        return false;
    }

    private void parseLine(String string) {
        if ((string = string.trim()).startsWith(SSID)) {
            this.cls_Ssid = MacUtil.parseSetting(string, SSID, null);
        } else if (string.startsWith(LINK_STATUS)) {
            this.cls_LinkStatus = MacUtil.parseSetting(string, LINK_STATUS, null);
        } else if (string.startsWith(LAST_ASSOCIATION_STATUS)) {
            this.cls_LastAssociationStatus = XmlUtil.getStringAsInt(MacUtil.parseSetting(string, LAST_ASSOCIATION_STATUS, null), this.cls_LastAssociationStatus);
        } else if (string.startsWith(LAST_TX_RATE)) {
            this.cls_LastTxRate = XmlUtil.getStringAsInt(MacUtil.parseSetting(string, LAST_TX_RATE, null), this.cls_LastTxRate);
        } else if (string.startsWith(AIRPORT_OFF)) {
            this.cls_IsEnabled = false;
        }
    }

    public String toString() {
        return "[Association enabled: " + this.isEnabled() + " associated: " + this.isAssociated() + " ssid: " + this.getSsid() + "]";
    }

    public boolean isAssociatedTo(String string) {
        return this.isEnabled() && this.isAssociated() && this.getSsid().equals(string);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Status {
        DISCONNECTED,
        STARTING_AUTH,
        WAITING_FOR_CERT,
        ASSOCIATED;

    }
}

