/*
 * Decompiled with CFR 0.152.
 */
package com.cloudpath.common.os.mac.snowleopard.network.networksetup;

import com.cloudpath.common.command.CommandHandler;
import com.cloudpath.common.command.CommandResponse;
import com.cloudpath.common.os.mac.common.network.networksetup.NetworkSetupReader;
import com.cloudpath.common.os.mac.leopard.cmd.Maccmd;
import com.cloudpath.common.os.mac.leopard.network.airport.LeopardAirportNetwork;
import com.cloudpath.common.os.mac.snowleopard.network.SnowLeopardSsidManager;
import com.cloudpath.common.os.mac.snowleopard.network.networksetup.SnowLeopardExportProfile;
import com.cloudpath.common.util.FileUtil;
import com.cloudpath.common.util.Util;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Locale;
import org.apache.log4j.Logger;

public class SnowLeopardNetworkSetupReader
extends NetworkSetupReader {
    private static final Logger log = Logger.getLogger(SnowLeopardSsidManager.class);
    private static final String SNOW_LEOPARD_PATH = "/usr/sbin/networksetup";
    private static final String SNOW_LEOPARD_SCUTIL_PATH = "/usr/sbin/scutil";
    private final Maccmd cls_Maccmd;
    private static final SimpleDateFormat FILENAME_DATE_FORMAT = new SimpleDateFormat("yyyyMMddyyyy_kkmmss", Locale.US);
    private static boolean BACKUP_CREATED = false;

    public SnowLeopardNetworkSetupReader(CommandHandler commandHandler, Maccmd maccmd) {
        super(SNOW_LEOPARD_PATH, SNOW_LEOPARD_SCUTIL_PATH, commandHandler);
        this.cls_Maccmd = maccmd;
    }

    public String[] getPreferredWirelessNetworks(String string) {
        log.info((Object)("Will get preferred wireless networks for interface '" + string + "'."));
        this.checkInterfaceName(string);
        Util.assertNotBlank(this, "InterfaceName", string);
        if (string != null && string.length() > 0) {
            try {
                String[] stringArray = new String[]{this.getPath(), "-listpreferredwirelessnetworks", string};
                CommandResponse commandResponse = this.cls_CommandHandler.executeCommand(stringArray);
                commandResponse.waitFor();
                String[] stringArray2 = commandResponse.getOutput();
                ArrayList<String> arrayList = new ArrayList<String>();
                for (int i = 1; i < stringArray2.length; ++i) {
                    arrayList.add(stringArray2[i].trim());
                }
                if (arrayList.size() == 1 && ((String)arrayList.get(0)).length() == 0) {
                    return new String[0];
                }
                String[] stringArray3 = new String[arrayList.size()];
                arrayList.toArray(stringArray3);
                return stringArray3;
            }
            catch (Exception exception) {
                log.warn((Object)"An error occurred while getting preferred wireless networks.", (Throwable)exception);
                return new String[0];
            }
        }
        return new String[0];
    }

    public void addPreferredWirelessNetwork(String string, String string2, int n, LeopardAirportNetwork.SecurityType securityType, String string3) {
        log.info((Object)("Will add wireless preferred network '" + string2 + "' on interface '" + string + "' with security '" + (Object)((Object)securityType) + "'."));
        this.checkInterfaceName(string);
        Util.assertNotBlank(this, "InterfaceName", string);
        Util.assertNotBlank(this, "Ssid", string2);
        this.backupDataIfNecessary();
        if (string != null && string.length() > 0 && string2 != null && string2.length() > 0) {
            this.cls_Maccmd.addPreferredWirelessNetwork(string, string2, n, securityType.SnowLeopardOsName, string3);
        }
    }

    public void deletePreferredWirelessNetwork(String string, String string2) {
        log.info((Object)("Will delete wireless preferred network '" + string2 + "' on interface '" + string + "'."));
        this.checkInterfaceName(string);
        Util.assertNotBlank(this, "InterfaceName", string);
        Util.assertNotBlank(this, "Ssid", string2);
        this.backupDataIfNecessary();
        if (string != null && string.length() > 0 && string2 != null && string2.length() > 0) {
            this.cls_Maccmd.removePreferredWirelessNetwork(string, string2);
        }
    }

    public String getCurrentSsid(String string) {
        log.debug((Object)("Will get current ssid on interface '" + string + "'."));
        this.checkInterfaceName(string);
        Util.assertNotBlank(this, "InterfaceName", string);
        if (string != null && string.length() > 0) {
            try {
                String[] stringArray = new String[]{this.getPath(), "-getairportnetwork", string};
                CommandResponse commandResponse = this.cls_CommandHandler.executeCommand(stringArray);
                commandResponse.waitFor();
                String string2 = Util.join(commandResponse.getOutput());
                if (string2 != null && string2.indexOf(": ") > 0) {
                    return string2.substring(string2.indexOf(": ") + 2);
                }
                return "";
            }
            catch (Exception exception) {
                log.warn((Object)("An error occurred while getting current wireless network for '" + string + "'."), (Throwable)exception);
                return "";
            }
        }
        return "";
    }

    public void disassociate() {
        log.info((Object)"Will disassociate...");
        this.cls_Maccmd.disassociate();
    }

    public void associateToSsid(String string, String string2, String string3) {
        log.info((Object)("Will associate to ssid '" + string2 + "' on interface '" + string + "'."));
        this.checkInterfaceName(string);
        Util.assertNotBlank(this, "InterfaceName", string);
        if (string != null && string.length() > 0 && string2 != null) {
            try {
                String[] stringArray = string3 != null && string3.length() > 0 ? new String[]{this.getPath(), "-setairportnetwork", string, string2, string3} : new String[]{this.getPath(), "-setairportnetwork", string, string2};
                CommandResponse commandResponse = this.cls_CommandHandler.executeCommand(stringArray);
                commandResponse.waitFor();
            }
            catch (Exception exception) {
                log.warn((Object)("An error occurred while associating to wireless network '" + string2 + "' on '" + string + "'."), (Throwable)exception);
            }
        }
    }

    public boolean isSsidPreferred(String string, String string2) {
        log.debug((Object)("Will check if ssid '" + string2 + "' is preferred on interface '" + string + "'."));
        Util.assertNotBlank(this, "InterfaceName", string);
        Util.assertNotBlank(this, "Ssid", string2);
        if (string2 != null && string2.length() > 0) {
            String[] stringArray = this.getPreferredWirelessNetworks(string);
            for (int i = 0; i < stringArray.length; ++i) {
                if (!string2.equals(stringArray[i])) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isAssociatedTo(String string, String string2) {
        log.debug((Object)("Will check if associated to '" + string2 + "' on interface '" + string + "'."));
        Util.assertNotBlank(this, "InterfaceName", string);
        Util.assertNotBlank(this, "Ssid", string2);
        if (string2 != null && string2.length() > 0) {
            return string2.equals(this.getCurrentSsid(string));
        }
        return false;
    }

    public SnowLeopardExportProfile get8021XProfiles(String string, boolean bl) {
        log.debug((Object)("Will get 802.1X profiles for service name '" + string + "'."));
        Util.assertNotBlank(this, "ServiceName", string);
        if (string != null && string.length() > 0) {
            try {
                File file = File.createTempFile("cpn_", "");
                String[] stringArray = new String[]{this.getPath(), "-export8021xProfiles", string, file.getAbsolutePath(), bl ? "yes" : "no"};
                CommandResponse commandResponse = this.cls_CommandHandler.executeCommand(stringArray);
                commandResponse.waitFor();
                if (file.exists()) {
                    String string2 = FileUtil.read(file);
                    if (!file.delete()) {
                        file.deleteOnExit();
                    }
                    log.info((Object)("Got Profiles:\n" + string2));
                    SnowLeopardExportProfile snowLeopardExportProfile = new SnowLeopardExportProfile(string2);
                    return snowLeopardExportProfile;
                }
                log.warn((Object)"Failed to export eap profiles.  Will use blank.");
                return new SnowLeopardExportProfile();
            }
            catch (Exception exception) {
                log.warn((Object)"An error occurred while getting all 802.1X profiles.  Will use blank.", (Throwable)exception);
                return new SnowLeopardExportProfile();
            }
        }
        log.error((Object)("ServiceName was invalid (" + string + ")"));
        return new SnowLeopardExportProfile();
    }

    public void set8021XProfiles(String string, SnowLeopardExportProfile snowLeopardExportProfile) {
        log.debug((Object)("Will set 802.1X profiles for service name '" + string + "'."));
        Util.assertNotBlank(this, "ServiceName", string);
        this.backupDataIfNecessary();
        if (string != null && string.length() > 0) {
            try {
                File file = File.createTempFile("cpn_", "");
                String string2 = snowLeopardExportProfile.generate().getXml();
                FileUtil.write(file.getAbsolutePath(), string2);
                log.info((Object)("Generated Xml: \n" + string2));
                String[] stringArray = new String[]{this.getPath(), "-import8021xProfiles", string, file.getAbsolutePath()};
                CommandResponse commandResponse = this.cls_CommandHandler.executeCommand(stringArray);
                commandResponse.waitFor();
                if (file.exists() && !file.delete()) {
                    file.deleteOnExit();
                }
            }
            catch (Exception exception) {
                log.warn((Object)"An error occurred while importing 802.1X profiles.", (Throwable)exception);
            }
        }
    }

    public String getCurrentLocation() {
        log.debug((Object)"Will get current location..");
        try {
            String[] stringArray = new String[]{this.getPath(), "-getcurrentlocation"};
            CommandResponse commandResponse = this.cls_CommandHandler.executeCommand(stringArray);
            commandResponse.waitFor();
            String string = Util.join(commandResponse.getOutput());
            log.debug((Object)("Current location is '" + string + "'."));
            return string;
        }
        catch (Exception exception) {
            log.warn((Object)"An error occurred while getting current location.", (Throwable)exception);
            return "";
        }
    }

    public String[] getAllLocations() {
        log.debug((Object)"Will get all locations...");
        try {
            String[] stringArray = new String[]{this.getPath(), "-listlocations"};
            CommandResponse commandResponse = this.cls_CommandHandler.executeCommand(stringArray);
            commandResponse.waitFor();
            String[] stringArray2 = commandResponse.getOutput();
            ArrayList<String> arrayList = new ArrayList<String>();
            for (int i = 0; i < stringArray2.length; ++i) {
                arrayList.add(stringArray2[i].trim());
            }
            if (arrayList.size() == 1 && ((String)arrayList.get(0)).length() == 0) {
                return new String[0];
            }
            String[] stringArray3 = new String[arrayList.size()];
            arrayList.toArray(stringArray3);
            return stringArray3;
        }
        catch (Exception exception) {
            log.warn((Object)"An error occurred while getting list of locations.", (Throwable)exception);
            return new String[0];
        }
    }

    public void addLocation(String string) {
        log.info((Object)("Will add location '" + string + "'."));
        Util.assertNotBlank(this, "LocationName", string);
        this.backupDataIfNecessary();
        if (string != null && string.length() > 0) {
            try {
                String[] stringArray = new String[]{this.getPath(), "-createlocation", string, "populate"};
                CommandResponse commandResponse = this.cls_CommandHandler.executeCommand(stringArray);
                commandResponse.waitFor();
            }
            catch (Exception exception) {
                log.warn((Object)("An error occurred while adding location '" + string + "'."), (Throwable)exception);
            }
        }
    }

    public void deleteLocation(String string) {
        log.info((Object)("Will delete location '" + string + "'."));
        Util.assertNotBlank(this, "LocationName", string);
        this.backupDataIfNecessary();
        if (string != null && string.length() > 0) {
            String[] stringArray = this.getAllLocations();
            if (stringArray.length < 2) {
                log.warn((Object)"Not deleting location because it is the last one.");
                return;
            }
            if (string.equals(this.getCurrentLocation())) {
                boolean bl = false;
                for (int i = 0; !bl && i < stringArray.length; ++i) {
                    if (stringArray[i] == null || string.equals(stringArray[i])) continue;
                    this.switchLocation(stringArray[i]);
                    if (!stringArray[i].equals(this.getCurrentLocation())) continue;
                    bl = true;
                    log.debug((Object)("Switch active location to '" + stringArray[i] + "'."));
                }
                bl = true;
                if (!true) {
                    log.warn((Object)("Unable to delete location '" + string + "' because it is the current location and we failed to switch away from it."));
                }
            }
            try {
                String[] stringArray2 = new String[]{this.getPath(), "-deletelocation", string};
                CommandResponse commandResponse = this.cls_CommandHandler.executeCommand(stringArray2);
                commandResponse.waitFor();
            }
            catch (Exception exception) {
                log.warn((Object)("An error occurred while deleting location '" + string + "'."), (Throwable)exception);
            }
        }
    }

    public void switchLocation(String string) {
        log.warn((Object)("Will switch location to '" + string + "'."));
        Util.assertNotBlank(this, "LocationName", string);
        this.backupDataIfNecessary();
        if (string != null && string.length() > 0) {
            try {
                String[] stringArray = new String[]{this.getPath(), "-switchtolocation", string};
                CommandResponse commandResponse = this.cls_CommandHandler.executeCommand(stringArray);
                commandResponse.waitFor();
            }
            catch (Exception exception) {
                log.warn((Object)("An error occurred while switching location '" + string + "'."), (Throwable)exception);
            }
        }
    }

    public boolean hasLocation(String string) {
        log.info((Object)("Will check if location '" + string + "' exists."));
        Util.assertNotBlank(this, "LocationName", string);
        if (string != null && string.length() > 0) {
            String[] stringArray = this.getAllLocations();
            for (int i = 0; stringArray != null && i < stringArray.length; ++i) {
                if (!string.equals(stringArray[i])) continue;
                log.info((Object)("Yes, location '" + string + "' exists."));
                return true;
            }
        }
        log.info((Object)("No, location '" + string + "' does not exist."));
        return false;
    }

    private void backupDataIfNecessary() {
        block7: {
            try {
                if (BACKUP_CREATED) break block7;
                BACKUP_CREATED = true;
                File file = new File(System.getProperty("user.home") + File.separator + ".network_backups");
                if (!file.exists()) {
                    file.mkdirs();
                }
                String string = "preferences.plist";
                String string2 = string + ".bak_" + FILENAME_DATE_FORMAT.format(System.currentTimeMillis());
                File file2 = new File(file, string2);
                String[] stringArray = new String[]{"cp", "/Library/Preferences/SystemConfiguration/" + string, file2.getAbsolutePath()};
                try {
                    this.cls_CommandHandler.executeCommand(stringArray);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                log.debug((Object)("Backed up original " + string + " file to '" + file2.getAbsolutePath() + "'."));
                string = "com.apple.airport.preferences.plist";
                string2 = string + ".bak_" + FILENAME_DATE_FORMAT.format(System.currentTimeMillis());
                file2 = new File(file, string2);
                stringArray = new String[]{"cp", "/Library/Preferences/SystemConfiguration/" + string, file2.getAbsolutePath()};
                try {
                    this.cls_CommandHandler.executeCommand(stringArray);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                log.debug((Object)("Backed up original " + string + " file to '" + file2.getAbsolutePath() + "'."));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

