/*
 * Decompiled with CFR 0.152.
 */
package com.cloudpath.common.os.mac.snowleopard.network.networksetup;

import com.cloudpath.common.os.mac.common.plist.PlistConstants;
import com.cloudpath.common.os.mac.common.plist.pojo.Dict;
import com.cloudpath.common.os.mac.common.plist.pojo.PairValue;
import com.cloudpath.common.os.mac.common.plist.pojo.Plist;
import com.cloudpath.common.os.mac.common.plist.pojo.ValueArray;
import com.cloudpath.common.os.mac.leopard.network.eap.LeopardEap;
import com.cloudpath.common.os.mac.leopard.network.eap.LeopardEapProfile;
import java.util.ArrayList;
import java.util.Vector;
import org.apache.log4j.Logger;

public class SnowLeopardExportProfile {
    private static final Logger log = Logger.getLogger(SnowLeopardExportProfile.class);
    public static final String SYSTEM_PROFILE = "[SYSTEM]";
    public static final String LOGIN_PROFILES = "LoginProfiles";
    public static final String SYSTEM_PROFILES = "SystemProfiles";
    public static final String USER_PROFILES = "UserProfiles";
    public static final String KEY_8021X = "8021X";
    private final Vector<LeopardEapProfile> cls_LoginProfiles = new Vector();
    private boolean cls_LoginProfilesModified = false;
    private final Vector<LeopardEap> cls_SystemProfiles = new Vector();
    private boolean cls_SystemProfilesModified = false;
    private final Vector<LeopardEapProfile> cls_UserProfiles = new Vector();
    private boolean cls_UserProfilesModified = false;

    public SnowLeopardExportProfile(String string) throws Exception {
        this(PlistConstants.readPlist(string));
    }

    public SnowLeopardExportProfile(Plist plist) {
        this.parse(plist);
    }

    public SnowLeopardExportProfile() {
    }

    public int getLoginProfileCount() {
        return this.cls_LoginProfiles.size();
    }

    public LeopardEapProfile getLoginProfile(int n) {
        return this.cls_LoginProfiles.get(n);
    }

    public void addLoginProfile(LeopardEapProfile leopardEapProfile) {
        this.cls_LoginProfilesModified = true;
        this.cls_LoginProfiles.add(leopardEapProfile);
    }

    public void deleteLoginProfile(String string) {
        int n = this.getLoginProfileIndexByName(string);
        if (n >= 0) {
            this.cls_LoginProfilesModified = true;
            this.cls_LoginProfiles.remove(n);
        }
    }

    public int getLoginProfileIndexByName(String string) {
        if (string != null) {
            for (int i = 0; i < this.getLoginProfileCount(); ++i) {
                if (!string.equals(this.getLoginProfile(i).getUserDefinedName())) continue;
                return i;
            }
        }
        return -1;
    }

    public LeopardEapProfile getLoginProfileByName(String string) {
        int n = this.getLoginProfileIndexByName(string);
        return n >= 0 ? this.getLoginProfile(n) : null;
    }

    public LeopardEapProfile getLoginProfileByUniqueIdentifier(String string) {
        if (string != null) {
            for (int i = 0; i < this.getLoginProfileCount(); ++i) {
                if (!string.equals(this.getLoginProfile(i).getUniqueIdentifier())) continue;
                return this.getLoginProfile(i);
            }
        }
        return null;
    }

    public LeopardEapProfile[] getLoginProfilesBySsid(String string) {
        ArrayList<LeopardEapProfile> arrayList = new ArrayList<LeopardEapProfile>();
        if (string != null) {
            for (int i = 0; i < this.getLoginProfileCount(); ++i) {
                if (!string.equals(this.getLoginProfile(i).getWirelessNetwork())) continue;
                arrayList.add(this.getLoginProfile(i));
            }
        }
        LeopardEapProfile[] leopardEapProfileArray = new LeopardEapProfile[arrayList.size()];
        arrayList.toArray(leopardEapProfileArray);
        return leopardEapProfileArray;
    }

    public int getUserProfileCount() {
        return this.cls_UserProfiles.size();
    }

    public void addUserProfile(LeopardEapProfile leopardEapProfile) {
        this.cls_UserProfilesModified = true;
        int n = this.getUserProfileIndexByName(leopardEapProfile.getUserDefinedName());
        if (n >= 0) {
            this.cls_UserProfiles.remove(n);
        }
        this.cls_UserProfiles.add(leopardEapProfile);
    }

    public LeopardEapProfile getUserProfile(int n) {
        return this.cls_UserProfiles.get(n);
    }

    public void deleteUserProfile(String string) {
        int n = this.getUserProfileIndexByName(string);
        while (n >= 0) {
            log.debug((Object)("  - Will delete user profile '" + string + "' at index '" + n + "'."));
            this.cls_UserProfilesModified = true;
            this.cls_UserProfiles.remove(n);
            n = this.getUserProfileIndexByName(string);
        }
        log.debug((Object)("  - Done deleting user profiles by name '" + string + "'."));
    }

    public int getUserProfileIndexByName(String string) {
        if (string != null) {
            for (int i = 0; i < this.getUserProfileCount(); ++i) {
                if (!string.equals(this.getUserProfile(i).getUserDefinedName())) continue;
                return i;
            }
        }
        return -1;
    }

    public LeopardEapProfile getUserProfileByName(String string) {
        int n = this.getUserProfileIndexByName(string);
        return n >= 0 ? this.getUserProfile(n) : null;
    }

    public LeopardEapProfile getUserProfileByUniqueIdentifier(String string) {
        if (string != null) {
            for (int i = 0; i < this.getUserProfileCount(); ++i) {
                if (!string.equals(this.getUserProfile(i).getUniqueIdentifier())) continue;
                return this.getUserProfile(i);
            }
        }
        return null;
    }

    public LeopardEapProfile[] getUserProfilesBySsid(String string) {
        ArrayList<LeopardEapProfile> arrayList = new ArrayList<LeopardEapProfile>();
        if (string != null) {
            for (int i = 0; i < this.getUserProfileCount(); ++i) {
                if (!string.equals(this.getUserProfile(i).getWirelessNetwork())) continue;
                arrayList.add(this.getUserProfile(i));
            }
        }
        LeopardEapProfile[] leopardEapProfileArray = new LeopardEapProfile[arrayList.size()];
        arrayList.toArray(leopardEapProfileArray);
        return leopardEapProfileArray;
    }

    public int getSystemProfileCount() {
        return this.cls_SystemProfiles.size();
    }

    public LeopardEap getSystemProfile(int n) {
        return this.cls_SystemProfiles.get(n);
    }

    public void setSystemProfile(LeopardEap leopardEap) {
        log.info((Object)("Setting system profile.  Previous system profiles: " + this.cls_SystemProfiles.size()));
        this.cls_SystemProfilesModified = true;
        this.cls_SystemProfiles.clear();
        this.cls_SystemProfiles.add(leopardEap);
    }

    public void deleteSystemProfile(String string) {
        this.cls_SystemProfilesModified = true;
        this.cls_SystemProfiles.clear();
    }

    public int getAnyProfileCount() {
        int n = this.getUserProfileCount();
        int n2 = this.getSystemProfileCount();
        int n3 = this.getLoginProfileCount();
        log.info((Object)("Getting profile count - User: " + n + " System: " + n2 + " Login: " + n3));
        return n + n2 + n3;
    }

    public void deleteAnyProfile(String string) {
        if (string != null) {
            if (string.equals(SYSTEM_PROFILE)) {
                this.deleteSystemProfile(string);
            }
            if (this.getUserProfileByName(string) != null) {
                this.deleteUserProfile(string);
            }
            if (this.getLoginProfileByName(string) != null) {
                this.deleteLoginProfile(string);
            }
        }
    }

    public LeopardEapProfile getAnyProfile(int n) {
        if (n < this.getUserProfileCount()) {
            return this.getUserProfile(n);
        }
        if ((n -= this.getUserProfileCount()) < this.getSystemProfileCount()) {
            LeopardEap leopardEap = this.getSystemProfile(n);
            return SnowLeopardExportProfile.createSystemProfile(leopardEap);
        }
        if ((n -= this.getSystemProfileCount()) < this.getLoginProfileCount()) {
            return this.getLoginProfile(n);
        }
        return null;
    }

    public LeopardEapProfile getAnyProfileByName(String string) {
        if (string != null) {
            if (string.equals(SYSTEM_PROFILE)) {
                LeopardEap leopardEap;
                if (this.getSystemProfileCount() > 0 && (leopardEap = this.getSystemProfile(0)) != null) {
                    return SnowLeopardExportProfile.createSystemProfile(leopardEap);
                }
                return null;
            }
            LeopardEapProfile leopardEapProfile = this.getUserProfileByName(string);
            if (leopardEapProfile != null) {
                log.debug((Object)("     - Profile '" + string + "' found as user profile."));
            } else {
                leopardEapProfile = this.getLoginProfileByName(string);
                if (leopardEapProfile != null) {
                    log.debug((Object)("     - Profile '" + string + "' found as login profile."));
                }
            }
            return leopardEapProfile;
        }
        return null;
    }

    public LeopardEapProfile getAnyProfileByUniqueIdentifier(String string) {
        if (string != null) {
            LeopardEapProfile leopardEapProfile = this.getUserProfileByUniqueIdentifier(string);
            if (leopardEapProfile == null) {
                leopardEapProfile = this.getLoginProfileByUniqueIdentifier(string);
            }
            return leopardEapProfile;
        }
        return null;
    }

    public static LeopardEapProfile createSystemProfile(LeopardEap leopardEap) {
        LeopardEapProfile leopardEapProfile = new LeopardEapProfile();
        leopardEapProfile.setEapConfig(leopardEap);
        leopardEapProfile.setConnectByDefault(true);
        leopardEapProfile.setUserDefinedName(SYSTEM_PROFILE);
        leopardEapProfile.getEapConfig().setInactive(false);
        leopardEapProfile.setUniqueIdentifier(leopardEap.getUserPasswordKeychainItemId());
        leopardEapProfile.setDesiredPassword(leopardEap.getDesiredPassword_SPECIAL());
        leopardEapProfile.setWirelessNetwork(leopardEap.getWirelessNetwork_SPECIAL());
        leopardEapProfile.setWirelessSecurity(leopardEap.getWirelessSecurity_SPECIAL());
        return leopardEapProfile;
    }

    public String getProfileNames() {
        int n;
        String string = "";
        for (n = 0; n < this.cls_LoginProfiles.size(); ++n) {
            if (string.length() > 0) {
                string = string + ",";
            }
            string = string + "Login=" + this.cls_LoginProfiles.get(n).getUserDefinedName();
        }
        for (n = 0; n < this.cls_SystemProfiles.size(); ++n) {
            if (string.length() > 0) {
                string = string + ",";
            }
            string = string + "System=[SYSTEM]";
        }
        for (n = 0; n < this.cls_UserProfiles.size(); ++n) {
            if (string.length() > 0) {
                string = string + ",";
            }
            string = string + "User=" + this.cls_UserProfiles.get(n).getUserDefinedName();
        }
        return "[" + string + "]";
    }

    public Plist generate() {
        Plist plist;
        Dict dict;
        Dict dict2;
        log.debug((Object)"Will generate EAP profiles...");
        ValueArray valueArray = new ValueArray();
        log.debug((Object)("  - User Profiles: " + this.cls_UserProfiles.size()));
        if (this.cls_UserProfiles.size() > 0) {
            for (int i = 0; i < this.cls_UserProfiles.size(); ++i) {
                Dict dict3 = this.cls_UserProfiles.get(i).generate(false, false);
                valueArray.addValue(dict3);
            }
        }
        log.debug((Object)("  - Login Profiles: " + this.cls_LoginProfiles.size()));
        ValueArray valueArray2 = new ValueArray();
        if (this.cls_LoginProfiles.size() > 0) {
            for (int i = 0; i < this.cls_LoginProfiles.size(); ++i) {
                Dict dict4 = this.cls_LoginProfiles.get(i).generate(true, false);
                valueArray2.addValue(dict4);
            }
        }
        log.debug((Object)("  - System Profiles: " + this.cls_SystemProfiles.size()));
        ValueArray valueArray3 = new ValueArray();
        if (this.cls_SystemProfiles.size() > 0) {
            for (int i = 0; i < this.cls_SystemProfiles.size(); ++i) {
                dict2 = this.cls_SystemProfiles.get(i).generateForPreferences(false, true);
                dict = new Dict();
                dict.addPair("EAPClientConfiguration", dict2);
                valueArray3.addValue(dict);
            }
        }
        if ((dict2 = (plist = new Plist()).getDict()) == null) {
            dict2 = new Dict();
            plist.setDict(dict2);
        }
        dict = new Dict();
        dict2.addPair(KEY_8021X, dict);
        if (this.cls_LoginProfilesModified || valueArray2.getValueCount() > 0) {
            dict.addPair(LOGIN_PROFILES, valueArray2);
        }
        if (this.cls_SystemProfilesModified || valueArray3.getValueCount() > 0) {
            if (valueArray3.getValueCount() == 0) {
                ValueArray valueArray4 = new ValueArray();
                valueArray4.addValue(new Dict());
                dict.addPair(SYSTEM_PROFILES, valueArray4);
            } else {
                dict.addPair(SYSTEM_PROFILES, valueArray3);
            }
        }
        if (this.cls_UserProfilesModified || valueArray.getValueCount() > 0) {
            dict.addPair(USER_PROFILES, valueArray);
        }
        return plist;
    }

    public void parse(Plist plist) {
        Object object;
        Object object2;
        log.debug((Object)"Will parse profiles.");
        this.cls_SystemProfiles.clear();
        this.cls_LoginProfiles.clear();
        this.cls_UserProfiles.clear();
        this.cls_LoginProfilesModified = false;
        this.cls_SystemProfilesModified = false;
        this.cls_UserProfilesModified = false;
        Dict dict = plist.getDict();
        if (dict == null) {
            dict = new Dict();
        }
        Dict dict2 = dict.getDict(KEY_8021X, new Dict());
        ValueArray valueArray = dict2.getArray(SYSTEM_PROFILES, new ValueArray());
        for (int i = 0; i < valueArray.getValueCount(); ++i) {
            PairValue pairValue = valueArray.getValue(i);
            if (!(pairValue instanceof Dict)) continue;
            object2 = new LeopardEap();
            object = ((Dict)pairValue).getDict("EAPClientConfiguration", null);
            if (object != null) {
                ((LeopardEap)object2).parse((Dict)object);
            } else {
                ((LeopardEap)object2).parse((Dict)pairValue);
            }
            this.cls_SystemProfiles.add((LeopardEap)object2);
        }
        ValueArray valueArray2 = dict2.getArray(LOGIN_PROFILES, new ValueArray());
        for (int i = 0; i < valueArray2.getValueCount(); ++i) {
            object2 = valueArray2.getValue(i);
            if (!(object2 instanceof Dict)) continue;
            object = new LeopardEapProfile();
            ((LeopardEapProfile)object).parse((Dict)object2);
            this.cls_LoginProfiles.add((LeopardEapProfile)object);
        }
        ValueArray valueArray3 = dict2.getArray(USER_PROFILES, new ValueArray());
        for (int i = 0; i < valueArray3.getValueCount(); ++i) {
            object = valueArray3.getValue(i);
            if (!(object instanceof Dict)) continue;
            LeopardEapProfile leopardEapProfile = new LeopardEapProfile();
            leopardEapProfile.parse((Dict)object);
            this.cls_UserProfiles.add(leopardEapProfile);
        }
    }
}

