/*
 * Decompiled with CFR 0.152.
 */
package com.cloudpath.common.os.mac.snowleopard.network.airport;

import com.cloudpath.common.command.CommandHandler;
import com.cloudpath.common.command.CommandResponse;
import com.cloudpath.common.os.common.WirelessAssociation;
import com.cloudpath.common.os.common.WirelessProvider;
import com.cloudpath.common.os.mac.common.network.airport.AirportReader;
import com.cloudpath.common.os.mac.leopard.network.airport.LeopardAirportAssociation;
import com.cloudpath.common.os.mac.leopard.network.eap.LeopardEapProfile;
import com.cloudpath.common.os.mac.snowleopard.network.networksetup.SnowLeopardNetworkSetupReader;
import com.cloudpath.common.util.Util;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class SnowLeopardAirportReader
implements WirelessProvider,
AirportReader {
    private static final Logger log = Logger.getLogger(SnowLeopardAirportReader.class);
    public static final String[] PATHS = new String[]{"/System/Library/PrivateFrameworks/Apple80211.framework/Versions/Current/Resources/airport", "/System/Library/PrivateFrameworks/Apple80211.framework/Resources/airport", "/System/Library/PrivateFrameworks/Apple80211.framework/Versions/A/Resources/airport"};
    private final CommandHandler cls_CommandHandler;
    private final String cls_Path;
    private final SnowLeopardNetworkSetupReader cls_NetworkSetup;
    private final Map<String, Boolean> cls_SsidsExist;

    public SnowLeopardAirportReader(CommandHandler commandHandler, SnowLeopardNetworkSetupReader snowLeopardNetworkSetupReader) {
        this.cls_CommandHandler = commandHandler;
        this.cls_NetworkSetup = snowLeopardNetworkSetupReader;
        this.cls_SsidsExist = new HashMap<String, Boolean>();
        String string = null;
        for (int i = 0; string == null && i < PATHS.length; ++i) {
            if (!new File(PATHS[i]).exists()) continue;
            string = PATHS[i];
            log.info((Object)("Airport utility exists at " + string));
        }
        if (string == null) {
            log.error((Object)"\n*** Could not locate the airport utility binary.***\n");
            string = PATHS[0];
        }
        this.cls_Path = string;
    }

    private final CommandHandler getCommandHandler() {
        return this.cls_CommandHandler;
    }

    public final WirelessAssociation getCurrentAssociation(String string) throws Exception {
        String[] stringArray = this.execute(new String[]{this.cls_Path, "-I"}, false);
        LeopardAirportAssociation leopardAirportAssociation = new LeopardAirportAssociation(Util.join(stringArray));
        log.debug((Object)("Association is: " + leopardAirportAssociation));
        return leopardAirportAssociation;
    }

    public final void connectToOpenSsid(String string, String string2) {
        this.cls_NetworkSetup.associateToSsid(string, string2, "");
    }

    public final void connectToPskSsid(String string, String string2, String string3) {
        if (string3 == null || string3.length() == 0) {
            this.connectToOpenSsid(string, string2);
            return;
        }
        this.cls_NetworkSetup.associateToSsid(string, string2, string3);
    }

    public boolean setPowerState(String string, boolean bl) {
        this.cls_NetworkSetup.setAirportPower(string, bl);
        return this.cls_NetworkSetup.getAirportPower(string) == bl;
    }

    public void disconnect(String string) {
        this.cls_NetworkSetup.disassociate();
    }

    public void abandon() throws IOException {
    }

    public void associationComplete() throws Exception {
        this.closeSystemPreferences();
    }

    public void closeSystemPreferences() throws Exception {
        this.getCommandHandler().executeCommand(new String[]{"killall", "System Preferences"});
    }

    public final void connectToDot1xSsid(String string, LeopardEapProfile leopardEapProfile, String string2) {
        this.connectToDot1xSsid(string, leopardEapProfile, string2, true);
    }

    public final void connectToDot1xSsid(String string, LeopardEapProfile leopardEapProfile, String string2, boolean bl) {
        this.cls_NetworkSetup.associateToSsid(string2, string, null);
    }

    private String[] execute(String[] stringArray, boolean bl) throws Exception {
        CommandResponse commandResponse = this.cls_CommandHandler.executeCommand(stringArray);
        commandResponse.waitFor();
        String[] stringArray2 = commandResponse.getOutput();
        if (bl) {
            return stringArray2;
        }
        for (int i = 0; i < 4 && (stringArray2.length == 0 || stringArray2.length == 1 && stringArray2[0].length() == 0); ++i) {
            log.debug((Object)"Airport returned a blank response.  Will retry.");
            Thread.sleep(100L);
            commandResponse = this.cls_CommandHandler.executeCommand(stringArray);
            commandResponse.waitFor();
            stringArray2 = commandResponse.getOutput();
        }
        if (stringArray2.length == 0 || stringArray2.length == 1 && stringArray2[0].length() == 0) {
            log.error((Object)"Unable to get a response from airport.");
        }
        return stringArray2;
    }

    public boolean ssidIsInScanList(String string, String string2) {
        String[] stringArray;
        Boolean bl = this.cls_SsidsExist.get(string2);
        if (bl != null) {
            return bl;
        }
        this.setPowerState(string, true);
        try {
            Thread.sleep(3000L);
        }
        catch (InterruptedException interruptedException) {
            log.error((Object)"Couldn't sleep when bringing up the interface.  The SSID may be missed in the scan.");
        }
        try {
            stringArray = this.execute(new String[]{this.cls_Path, "-s", "-x"}, false);
        }
        catch (Exception exception) {
            log.error((Object)"Unable to scan with the airport command!");
            return false;
        }
        if (string2 == null) {
            log.error((Object)"The target SSID is not known.");
        }
        for (int i = 0; i < stringArray.length - 1; ++i) {
            if (stringArray[i] == null || !stringArray[i].contains("SSID_STR") || stringArray[i + 1] == null || !stringArray[i + 1].contains(string2)) continue;
            this.cls_SsidsExist.put(string2, true);
            return true;
        }
        this.cls_SsidsExist.put(string2, false);
        return false;
    }
}

