/*
 * Decompiled with CFR 0.152.
 */
package com.cloudpath.common.os.mac.snowleopard;

import com.cloudpath.common.command.CommandHandler;
import com.cloudpath.common.command.CommandResponse;
import com.cloudpath.common.os.mac.common.MacOsProvider;
import com.cloudpath.common.os.mac.common.plist.PlistConstants;
import com.cloudpath.common.util.FileHandler;
import com.cloudpath.common.util.FileUtil;
import com.cloudpath.common.util.LogUtil;
import com.cloudpath.common.util.Resources;
import com.cloudpath.common.util.Util;
import java.io.File;
import java.io.IOException;
import org.apache.log4j.Logger;

public class SnowLeopardOsProvider
extends MacOsProvider {
    private static final Logger log = Logger.getLogger(SnowLeopardOsProvider.class);
    private static final String BREAK_LINE = "********************************************************************************\n";

    public SnowLeopardOsProvider(FileHandler fileHandler, CommandHandler commandHandler) {
        super(fileHandler, commandHandler);
    }

    public String generateSupportFile() {
        Object object;
        log.warn((Object)"\n\n********************************************************************************\nStarting to generate support file...\n********************************************************************************\n\n\n");
        log.debug((Object)"Generating support file.");
        File file = new File(FileUtil.getUserHome(), "/Desktop/" + Resources.ResourceString.PRODUCT_NAME.getValue() + " Support.txt");
        StringBuffer stringBuffer = new StringBuffer();
        this.handle(stringBuffer, new String[]{"/usr/bin/arch"});
        stringBuffer.append("NOTE:  The next test may fail.  That's okay.\n");
        this.handle(stringBuffer, new String[]{"/usr/BIN/arch"});
        this.handle(stringBuffer, new String[]{"/usr/sbin/networksetup", "-version"});
        this.handle(stringBuffer, new String[]{"/usr/sbin/networksetup", "-listnetworkserviceorder"});
        this.handle(stringBuffer, new String[]{"/usr/sbin/networksetup", "-listallnetworkservices"});
        this.handle(stringBuffer, new String[]{"/usr/sbin/networksetup", "-listallhardwareports"});
        this.handle(stringBuffer, new String[]{"/usr/sbin/networksetup", "-getcomputername"});
        this.handle(stringBuffer, new String[]{"/usr/sbin/networksetup", "-getinfo", "AirPort"});
        this.handle(stringBuffer, new String[]{"/usr/sbin/networksetup", "-getairportnetwork", "en1"});
        this.handle(stringBuffer, new String[]{"/usr/sbin/networksetup", "-getairportpower", "en1"});
        this.handle(stringBuffer, new String[]{"/usr/sbin/networksetup", "-listpreferredwirelessnetworks", "en1"});
        this.handle(stringBuffer, new String[]{"/usr/sbin/networksetup", "-listBonds"});
        this.handle(stringBuffer, new String[]{"/usr/sbin/networksetup", "-listVLANs"});
        this.handle(stringBuffer, new String[]{"/usr/sbin/networksetup", "-getcurrentlocation"});
        this.handle(stringBuffer, new String[]{"/usr/sbin/networksetup", "-listlocations"});
        this.handle(stringBuffer, new String[]{"/usr/sbin/networksetup", "-listalluserprofiles"});
        this.handle(stringBuffer, new String[]{"/usr/sbin/networksetup", "-listloginprofiles", "AirPort"});
        this.handle(stringBuffer, new String[]{"/usr/sbin/networksetup", "-getwebproxy", "Ethernet"});
        this.handle(stringBuffer, new String[]{"/usr/sbin/networksetup", "-getwebproxy", "Airport"});
        this.readProfiles(stringBuffer, "-export8021xUserProfiles", true);
        this.readProfiles(stringBuffer, "-export8021xSystemProfile", false);
        this.readProfiles(stringBuffer, "-export8021xLoginProfiles", false);
        this.handle(stringBuffer, new String[]{"/usr/sbin/system_profiler", "-detailLevel", "mini", "SPHardwareDataType"});
        this.handle(stringBuffer, new String[]{"/usr/sbin/system_profiler", "SPNetworkDataType"});
        this.handle(stringBuffer, new String[]{"/usr/sbin/system_profiler", "SPAirPortDataType"});
        this.handle(stringBuffer, new String[]{"/usr/sbin/system_profiler", "-detailLevel", "mini", "SPSoftwareDataType"});
        this.handle(stringBuffer, new String[]{"/usr/sbin/system_profiler", "-detailLevel", "mini", "SPFirewallDataType"});
        this.handle(stringBuffer, new String[]{"/usr/sbin/system_profiler", "-detailLevel", "mini", "SPNetworkLocationDataType"});
        this.handle(stringBuffer, new String[]{"/bin/ls", "-la", "/System/Library/CoreServices/RemoteManagement/ARDAgent.app/Contents/Support/"});
        this.handle(stringBuffer, new String[]{"/bin/ls", "-la", "/System/Library/PrivateFrameworks/Apple80211.framework/Versions/Current/Resources/"});
        this.handle(stringBuffer, new String[]{"/bin/ls", "-laR", "/System/Library/PrivateFrameworks/Apple80211.framework/"});
        this.handle(stringBuffer, new String[]{"/bin/ls", "-la", "/System/Library/PrivateFrameworks/"});
        this.handle(stringBuffer, new String[]{"/bin/ls", "-la", "/System/Library/Frameworks/"});
        this.handle(stringBuffer, new String[]{"/bin/ls", "-la", FileUtil.getUserHome() + "/Library/Preferences/"});
        this.handle(stringBuffer, new String[]{"/bin/ls", "-la", FileUtil.getUserHome() + "/Library/Preferences/ByHost/"});
        this.handle(stringBuffer, new String[]{"/bin/ls", "-la", "/Library/LaunchAgents/"});
        this.handle(stringBuffer, new String[]{"/sbin/md5", "/Library/LaunchAgents/*"});
        this.handle(stringBuffer, new String[]{"/bin/ls", "-la", "/Library/LaunchDaemons/"});
        this.handle(stringBuffer, new String[]{"/sbin/md5", "/Library/LaunchDaemons/*"});
        this.handle(stringBuffer, new String[]{"/bin/ls", "-la", "/Library/PrivilegedHelperTools/"});
        this.handle(stringBuffer, new String[]{"/sbin/md5", "/Library/PrivilegedHelperTools/*"});
        this.handle(stringBuffer, new String[]{"/bin/pwd"});
        this.handle(stringBuffer, new String[]{"ifconfig", "-a"});
        this.handle(stringBuffer, new String[]{"ifconfig"});
        this.handle(stringBuffer, new String[]{"ifconfig", "-l"});
        this.handle(stringBuffer, new String[]{"whoami"});
        this.handle(stringBuffer, new String[]{"date"});
        this.handle(stringBuffer, new String[]{"uname"});
        this.handle(stringBuffer, new String[]{"sw_vers"});
        this.handle(stringBuffer, new String[]{"ps", "-A"});
        this.handle(stringBuffer, new String[]{"/System/Library/PrivateFrameworks/Apple80211.framework/Versions/Current/Resources/airport", "-I"});
        this.handle(stringBuffer, new String[]{"/System/Library/PrivateFrameworks/Apple80211.framework/Versions/Current/Resources/airport", "-S"});
        this.handle(stringBuffer, new String[]{"/System/Library/PrivateFrameworks/Apple80211.framework/Versions/Current/Resources/airport", "-s"});
        stringBuffer.append("\n\nInternetConnect file\n");
        File file2 = new File(FileUtil.getUserHome(), "/Library/Preferences/com.apple.internetconnect.plist");
        stringBuffer.append("Path: " + file2.getAbsolutePath() + "\n");
        try {
            object = PlistConstants.readRawPlist(this.getCommandHandler(), this.getFileHandler(), file2);
            stringBuffer.append("\n\n" + (String)object + "\n\n");
        }
        catch (Exception exception) {
            stringBuffer.append(Util.getStackTrace(exception));
        }
        stringBuffer.append("\n\nNetworkConnect file\n");
        object = new File(FileUtil.getUserHome(), "/Library/Preferences/ByHost");
        stringBuffer.append("Path: " + ((File)object).getAbsolutePath() + "\n");
        File[] fileArray = ((File)object).listFiles();
        for (int i = 0; i < fileArray.length; ++i) {
            stringBuffer.append("FILE: " + fileArray[i].getName() + "\n");
            if (!fileArray[i].getName().startsWith("com.apple.networkConnect")) continue;
            stringBuffer.append("-- FOUND FILE: " + fileArray[i].getAbsolutePath() + "\n");
            try {
                String string = PlistConstants.readRawPlist(this.getCommandHandler(), this.getFileHandler(), file2);
                stringBuffer.append("\n\n" + string + "\n\n");
            }
            catch (Exception exception) {
                stringBuffer.append(Util.getStackTrace(exception));
            }
            stringBuffer.append("\nEND OF FILE: " + fileArray[i].getAbsolutePath() + "\n\n");
        }
        stringBuffer.append("\n\nLOG FILE:\n");
        if (LogUtil.LOG_FILE != null) {
            try {
                stringBuffer.append(FileUtil.read(LogUtil.LOG_FILE));
                stringBuffer.append("\n\nEND OF LOG FILE.\n\n");
            }
            catch (Exception exception) {
                stringBuffer.append("Error while reading log file.  Error: " + exception.getMessage());
            }
        } else {
            stringBuffer.append("No log file.\n");
        }
        try {
            this.getFileHandler().writeFile(file, stringBuffer.toString());
        }
        catch (Exception exception) {
            // empty catch block
        }
        log.warn((Object)"\n\n********************************************************************************\nDone generating support file.\n********************************************************************************\n\n\n");
        return file.getAbsolutePath();
    }

    public void runScript(String string, boolean bl) throws Exception {
        log.debug((Object)("Will run script... (elevate=" + bl + ")"));
        File file = File.createTempFile("xpc_post_", ".sh");
        this.getFileHandler().writeFile(file, string);
        this.getCommandHandler().executeCommand(new String[]{"chmod", "+x", file.getAbsolutePath()}).waitFor();
        if (bl) {
            this.getMaccmd().runAdhocScriptAsAdmin(file);
        } else {
            CommandResponse commandResponse = this.getCommandHandler().executeCommand(new String[]{file.getAbsolutePath()});
            commandResponse.waitFor();
        }
        if (!file.delete()) {
            file.deleteOnExit();
        }
    }

    private void readProfiles(StringBuffer stringBuffer, String string, boolean bl) {
        try {
            File file = new File("/tmp/exported_profiles.xml");
            if (bl) {
                this.handle(stringBuffer, new String[]{"/usr/sbin/networksetup", string, file.getAbsolutePath(), "no"});
            } else {
                this.handle(stringBuffer, new String[]{"/usr/sbin/networksetup", string, "AirPort", file.getAbsolutePath(), "no"});
            }
            try {
                String string2 = FileUtil.read(file);
                stringBuffer.append("EXPORTED PROFILES (" + string + "):\n" + string2 + "\n");
            }
            catch (IOException iOException) {
                stringBuffer.append("ERROR WHILE EXPORTING PROFILES.");
            }
            file.delete();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

