/*
 * Decompiled with CFR 0.152.
 */
package com.cloudpath.common.os.mac.lion;

import com.cloudpath.common.command.CommandHandler;
import com.cloudpath.common.command.CommandResponse;
import com.cloudpath.common.os.mac.common.plist.PlistUtil;
import com.cloudpath.common.os.mac.common.plist.pojo.Dict;
import com.cloudpath.common.os.mac.common.plist.pojo.Pair;
import com.cloudpath.common.os.mac.common.plist.pojo.Plist;
import com.cloudpath.common.os.mac.leopard.cmd.Maccmd;
import com.cloudpath.common.util.FileHandler;
import com.cloudpath.common.util.FileUtil;
import com.cloudpath.common.util.Util;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.log4j.Logger;

public class LionMobileConfigReader {
    private static final Logger log = Logger.getLogger(LionMobileConfigReader.class);
    private static final File PLIST_FILE = new File("/Library/Preferences/SystemConfiguration/com.apple.network.eapolclient.configuration.plist");
    private FileHandler cls_FileHandler;
    private CommandHandler cls_Command;
    private Maccmd cls_Maccmd;

    public LionMobileConfigReader(CommandHandler commandHandler, FileHandler fileHandler, Maccmd maccmd) {
        this.cls_Command = commandHandler;
        this.cls_FileHandler = fileHandler;
        this.cls_Maccmd = maccmd;
    }

    public boolean hasUuidsInstalled(String[] stringArray, boolean bl, boolean bl2) {
        return LionMobileConfigReader.hasUuidsInstalled(stringArray, this.getPreferencesPlist(), this.loadProfilesList(bl, bl2));
    }

    protected static boolean hasUuidsInstalled(String[] stringArray, Plist plist, String[] stringArray2) {
        if (stringArray == null || stringArray.length == 0) {
            // empty if block
        }
        log.debug((Object)("Will check if the following UUIDs are installed: " + Util.join(stringArray)));
        String[] stringArray3 = LionMobileConfigReader.getInstalledUuids(plist, stringArray2);
        log.debug((Object)("The following UUIDs are installed: \n" + Util.join(stringArray3)));
        for (int i = 0; stringArray != null && i < stringArray.length; ++i) {
            boolean bl = false;
            for (int j = 0; !bl && j < stringArray3.length; ++j) {
                if (stringArray[i] == null || !stringArray[i].equals(stringArray3[j])) continue;
                bl = true;
            }
            if (!bl) {
                log.debug((Object)("Did not locate uuid '" + stringArray[i] + "' in installed UUID list."));
                return false;
            }
            log.debug((Object)("Found that uuid '" + stringArray[i] + "' is in installed UUID list."));
        }
        log.debug((Object)"Found that all uuids are installed.");
        return true;
    }

    public boolean isUuidInstalled(String string, boolean bl, boolean bl2) {
        return LionMobileConfigReader.isUuidInstalled(string, this.getPreferencesPlist(), this.loadProfilesList(bl, bl2));
    }

    protected static boolean isUuidInstalled(String string, Plist plist, String[] stringArray) {
        log.debug((Object)("Will check if uuid '" + string + "' is installed..."));
        if (string != null) {
            String[] stringArray2 = LionMobileConfigReader.getInstalledUuids(plist, stringArray);
            for (int i = 0; i < stringArray2.length; ++i) {
                log.info((Object)("Comparing to: " + stringArray2[i]));
                if (!string.equals(stringArray2[i])) continue;
                log.debug((Object)(" - Uuid '" + string + "' found to be installed."));
                return true;
            }
        }
        log.debug((Object)(" - Uuid '" + string + "' not found installed."));
        return false;
    }

    public String[] getInstalledUuids(boolean bl, boolean bl2) {
        return LionMobileConfigReader.getInstalledUuids(this.getPreferencesPlist(), this.loadProfilesList(bl, bl2));
    }

    protected static String[] getInstalledUuids(Plist plist, String[] stringArray) {
        log.info((Object)"Will load installed profiles...");
        ArrayList<String> arrayList = new ArrayList<String>();
        String[] stringArray2 = LionMobileConfigReader.getInstalledUuidsFromEapPlist(plist);
        for (int i = 0; stringArray2 != null && i < stringArray2.length; ++i) {
            if (stringArray2[i] == null || arrayList.contains(stringArray2[i])) continue;
            arrayList.add(stringArray2[i]);
        }
        String[] stringArray3 = LionMobileConfigReader.getInstalledUuidsfromProfilesList(stringArray);
        for (int i = 0; stringArray3 != null && i < stringArray3.length; ++i) {
            if (stringArray3[i] == null || arrayList.contains(stringArray3[i])) continue;
            arrayList.add(stringArray3[i]);
        }
        String[] stringArray4 = new String[arrayList.size()];
        arrayList.toArray(stringArray4);
        log.info((Object)("Found " + stringArray4.length + " installed profiles."));
        return stringArray4;
    }

    protected static String[] getInstalledUuidsfromProfilesList(String[] stringArray) {
        log.info((Object)"  - Will load installed profiles via method 1...");
        ArrayList<String> arrayList = new ArrayList<String>();
        if (stringArray != null && stringArray.length > 0) {
            for (int i = 0; i < stringArray.length; ++i) {
                int n;
                String string = ".*payload\\[.*\\] uuid.*= .*";
                if (!stringArray[i].matches(string) || (n = stringArray[i].indexOf("=")) < 0 || stringArray[i].length() <= n + 2) continue;
                String string2 = stringArray[i].substring(n + 2);
                log.info((Object)("    - Found installed profile: " + string2));
                arrayList.add(string2);
            }
        }
        String[] stringArray2 = new String[arrayList.size()];
        arrayList.toArray(stringArray2);
        log.info((Object)("  - Found " + stringArray2.length + " installed profiles via method 1."));
        return stringArray2;
    }

    protected static String[] getInstalledPayloadIdentifiersfromProfilesList(String[] stringArray) {
        log.info((Object)"  - Will load installed profiles via method 1...");
        ArrayList<String> arrayList = new ArrayList<String>();
        if (stringArray != null && stringArray.length > 0) {
            for (int i = 0; i < stringArray.length; ++i) {
                int n;
                String string = ".*profileIdentifier: .*";
                if (!stringArray[i].matches(string) || (n = stringArray[i].indexOf("profileIdentifier: ")) < 0 || stringArray[i].length() <= n + 19) continue;
                String string2 = stringArray[i].substring(n + 19);
                log.info((Object)("    - Found installed profile: " + string2));
                arrayList.add(string2);
            }
        }
        String[] stringArray2 = new String[arrayList.size()];
        arrayList.toArray(stringArray2);
        log.info((Object)("  - Found " + stringArray2.length + " installed profiles via method 1."));
        return stringArray2;
    }

    protected static String[] getInstalledUuidsFromEapPlist(Plist plist) {
        Object object;
        log.info((Object)"  - Will load installed profiles via method 2.");
        ArrayList<String> arrayList = new ArrayList<String>();
        if (plist != null && plist.getDict() != null && (object = plist.getDict().getDict("Profiles", null)) != null) {
            for (int i = 0; i < ((Dict)object).getPairCount(); ++i) {
                String string;
                Dict dict;
                Dict dict2;
                Pair pair = ((Dict)object).getPair(i);
                if (!(pair.getValue() instanceof Dict) || (dict2 = ((Dict)pair.getValue()).getDict("Information", null)) == null || (dict = dict2.getDict("com.apple.mcx.configurationprofiles.8021X", null)) == null || (string = dict.getString("PayloadUUID", null)) == null) continue;
                log.info((Object)("   - '" + string + "' is installed."));
                arrayList.add(string);
            }
        }
        object = new String[arrayList.size()];
        arrayList.toArray((T[])object);
        log.info((Object)("  - Found " + ((Object)object).length + " installed profiles via method 2."));
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void addProfile(byte[] byArray) {
        File file;
        block7: {
            log.info((Object)"Will add profile...");
            file = null;
            try {
                try {
                    file = File.createTempFile("XPC_", ".bin");
                    FileUtil.writeFileBytes(file, byArray);
                    CommandResponse commandResponse = this.cls_Command.executeCommand(new String[]{LionMobileConfigReader.getProfilesBinaryPath(), "-I", "-F", file.getAbsolutePath()});
                    commandResponse.waitFor();
                    log.info((Object)("OUTPUT: " + Util.join(commandResponse.getOutput(), "\n")));
                    log.info((Object)("ERROR: " + Util.join(commandResponse.getError(), "\n")));
                }
                catch (IOException iOException) {
                    log.error((Object)"Unable to create profile file", (Throwable)iOException);
                    Object var5_6 = null;
                    if (file == null) return;
                    if (new File("/tmp/.xpcdebug").exists()) {
                        log.info((Object)("MOBILECONFIG TEMP FILE: " + file.getAbsolutePath()));
                        return;
                    }
                    if (file.delete()) return;
                    file.deleteOnExit();
                    return;
                }
                Object var5_5 = null;
                if (file == null) return;
                if (!new File("/tmp/.xpcdebug").exists()) break block7;
            }
            catch (Throwable throwable) {
                Object var5_7 = null;
                if (file == null) throw throwable;
                if (new File("/tmp/.xpcdebug").exists()) {
                    log.info((Object)("MOBILECONFIG TEMP FILE: " + file.getAbsolutePath()));
                    throw throwable;
                }
                if (file.delete()) throw throwable;
                file.deleteOnExit();
                throw throwable;
            }
            log.info((Object)("MOBILECONFIG TEMP FILE: " + file.getAbsolutePath()));
            return;
        }
        if (file.delete()) return;
        file.deleteOnExit();
    }

    public Plist getPreferencesPlist() {
        Plist plist = PlistUtil.getCurrentPlist(this.cls_FileHandler, this.cls_Command, PLIST_FILE, null);
        if (plist == null) {
            log.warn((Object)"Preferences information is null.  Will retry...");
            plist = PlistUtil.getCurrentPlist(this.cls_FileHandler, this.cls_Command, PLIST_FILE, null);
        }
        if (plist == null || plist.getDict() == null) {
            log.error((Object)"Preferences information is null again.  Unable to apply work-around.");
        }
        return plist;
    }

    private String[] loadProfilesList(boolean bl, boolean bl2) {
        int n;
        String[] stringArray;
        ArrayList<String> arrayList = new ArrayList<String>();
        if (bl) {
            stringArray = this.loadUserProfilesList(true);
            for (n = 0; n < stringArray.length; ++n) {
                arrayList.add(stringArray[n]);
            }
        }
        if (bl2) {
            stringArray = this.loadSystemProfilesList();
            for (n = 0; n < stringArray.length; ++n) {
                arrayList.add(stringArray[n]);
            }
        }
        stringArray = new String[arrayList.size()];
        arrayList.toArray(stringArray);
        return stringArray;
    }

    private String[] loadUserProfilesList(boolean bl) {
        log.info((Object)" - Will load user profiles list...");
        String[] stringArray = new String[]{};
        try {
            CommandResponse commandResponse = this.cls_Command.executeCommand(new String[]{LionMobileConfigReader.getProfilesBinaryPath(), "-L" + (bl ? "v" : "")});
            commandResponse.waitFor();
            stringArray = commandResponse.getOutput();
        }
        catch (IOException iOException) {
            log.warn((Object)"Error occurred while getting installed user profiles via method 2.");
        }
        return stringArray != null ? stringArray : new String[]{};
    }

    private String[] loadSystemProfilesList() {
        log.info((Object)" - Will load profiles list...");
        String[] stringArray = this.cls_Maccmd.getInstalledSystemProfiles();
        return stringArray != null ? stringArray : new String[]{};
    }

    private static final String getProfilesBinaryPath() {
        File file = new File("/usr/bin/profiles");
        if (file.exists()) {
            return file.getAbsolutePath();
        }
        File file2 = new File("/usr/bin/configurationprofiles");
        if (file2.exists()) {
            return file2.getAbsolutePath();
        }
        log.error((Object)"\n\n\n* * * Required binary 'profiles' does not exist.  We will be unable to do anything. * * * \n\n\n");
        return file.getAbsolutePath();
    }

    public boolean isUserProfileInstalledByPayloadIdentifier(String string) {
        String[] stringArray = this.loadUserProfilesList(false);
        log.info((Object)("User profile count: " + (stringArray != null ? stringArray.length : -1)));
        stringArray = LionMobileConfigReader.getInstalledPayloadIdentifiersfromProfilesList(stringArray);
        log.info((Object)("User profile count after trimming: " + (stringArray != null ? stringArray.length : -1)));
        for (int i = 0; i < stringArray.length; ++i) {
            log.info((Object)("User profile '" + stringArray[i] + "' is installed."));
            if (stringArray[i] == null || !stringArray[i].startsWith(string != null ? string : "NULL")) continue;
            return true;
        }
        return false;
    }

    public void removeUserProfileByPayloadIdentifier(String string) {
        log.info((Object)(" - Will remove user profile '" + string + "'..."));
        try {
            CommandResponse commandResponse = this.cls_Command.executeCommand(new String[]{LionMobileConfigReader.getProfilesBinaryPath(), "-R", "-p", string});
            commandResponse.waitFor();
        }
        catch (IOException iOException) {
            log.warn((Object)"Error occurred while removing installed user profile.");
        }
    }
}

