/*
 * Decompiled with CFR 0.152.
 */
package com.cloudpath.common.os.mac.leopard.network.systemconfig;

import com.cloudpath.common.os.mac.common.plist.pojo.Dict;
import com.cloudpath.common.os.mac.common.plist.pojo.Pair;
import com.cloudpath.common.os.mac.leopard.network.eap.LeopardEap;
import com.cloudpath.common.os.mac.leopard.network.systemconfig.LeopardLocationAirport;
import com.cloudpath.common.os.mac.leopard.network.systemconfig.LeopardLocationEapolLoginProfile;
import com.cloudpath.common.os.mac.leopard.network.systemconfig.LeopardLocationEapolLoginProfiles;
import com.cloudpath.common.util.OsConstants;
import java.util.Vector;
import org.apache.log4j.Logger;

public class LeopardLocationInterface {
    private static final Logger log = Logger.getLogger(LeopardLocationInterface.class);
    public static final String AIRPORT = "AirPort";
    public static final String EAPOL = "EAPOL";
    public static final String EAPOL_LOGIN_WINDOW = "EAPOL.LoginWindow";
    private String cls_InterfaceName;
    private LeopardLocationAirport cls_Airport;
    private final Vector<String> cls_OtherDictNames = new Vector();
    private final Vector<Dict> cls_OtherDicts = new Vector();
    private LeopardEap cls_EapolSystemProfile = null;
    private final LeopardLocationEapolLoginProfiles cls_EapolLoginProfiles = new LeopardLocationEapolLoginProfiles();

    public void setInterfaceName(String string) {
        this.cls_InterfaceName = string;
    }

    public String getInterfaceName() {
        return this.cls_InterfaceName;
    }

    public void setAirport(LeopardLocationAirport leopardLocationAirport) {
        this.cls_Airport = leopardLocationAirport;
    }

    public LeopardLocationAirport getAirport() {
        if (this.cls_Airport == null) {
            this.cls_Airport = new LeopardLocationAirport();
        }
        return this.cls_Airport;
    }

    public void setEapolSystemProfile(LeopardEap leopardEap) {
        this.cls_EapolSystemProfile = leopardEap;
    }

    public LeopardEap getEapolSystemProfile() {
        return this.cls_EapolSystemProfile;
    }

    public LeopardLocationEapolLoginProfiles getEapolLoginProfiles() {
        return this.cls_EapolLoginProfiles;
    }

    public synchronized void parse(String string, Dict dict) {
        Object object;
        log.debug((Object)("   - Parsing interface " + string));
        this.cls_OtherDictNames.clear();
        this.cls_OtherDicts.clear();
        this.setInterfaceName(string);
        for (int i = 0; i < dict.getPairCount(); ++i) {
            Dict dict2;
            object = dict.getPair(i);
            String string2 = ((Pair)object).getKey();
            if (AIRPORT.equals(string2)) {
                dict2 = dict.getDict(AIRPORT, new Dict());
                this.cls_Airport = new LeopardLocationAirport();
                this.cls_Airport.parse(dict2);
                continue;
            }
            if (EAPOL.equals(string2) || EAPOL_LOGIN_WINDOW.equals(string2) || (dict2 = dict.getDict(string2, null)) == null) continue;
            this.cls_OtherDictNames.add(string2);
            this.cls_OtherDicts.add(dict2);
        }
        Dict dict3 = dict.getDict(EAPOL, null);
        if (dict3 == null) {
            log.debug((Object)"     - No system configuration.");
            this.cls_EapolSystemProfile = null;
        } else {
            log.debug((Object)"     - System configuration exists.");
            this.cls_EapolSystemProfile = new LeopardEap();
            this.cls_EapolSystemProfile.parse(dict3);
        }
        object = dict.getDict(EAPOL_LOGIN_WINDOW, null);
        if (object == null) {
            log.debug((Object)"     - No login (sso) configuration.");
            this.cls_EapolLoginProfiles.clear();
        } else {
            log.debug((Object)"     - Login (sso) configuration exists.");
            this.cls_EapolLoginProfiles.clear();
            this.cls_EapolLoginProfiles.parse((Dict)object);
        }
    }

    public Dict generate(boolean bl) {
        Dict dict = new Dict();
        if (this.cls_Airport != null) {
            dict.addPair(AIRPORT, this.cls_Airport.generate());
        }
        if (this.cls_OtherDicts.size() > 0) {
            for (int i = 0; i < this.cls_OtherDicts.size(); ++i) {
                String string = this.cls_OtherDictNames.get(i);
                Dict dict2 = this.cls_OtherDicts.get(i);
                dict.addPair(string, dict2);
            }
        }
        if (this.cls_EapolSystemProfile != null) {
            dict.addPair(EAPOL, this.cls_EapolSystemProfile.generateForPreferences(false, true));
        }
        if (this.cls_EapolLoginProfiles.getCount() > 0) {
            if (bl || OsConstants.isMacLeopardBeforeUpdate4()) {
                LeopardLocationEapolLoginProfile leopardLocationEapolLoginProfile = this.cls_EapolLoginProfiles.getProfileForKey("AD231044-DF43-4AA1-91F8-9ED61141BAD2");
                if (leopardLocationEapolLoginProfile != null) {
                    dict.addPair(EAPOL_LOGIN_WINDOW, leopardLocationEapolLoginProfile.generate());
                }
            } else {
                dict.addPair(EAPOL_LOGIN_WINDOW, this.cls_EapolLoginProfiles.generate());
            }
        }
        return dict;
    }
}

