/*
 * Decompiled with CFR 0.152.
 */
package com.cloudpath.common.os.mac.leopard.network.systemconfig;

import com.cloudpath.common.os.mac.common.plist.pojo.Dict;
import com.cloudpath.common.os.mac.leopard.network.eap.LeopardEap;

public class LeopardLocationEapolLoginProfile {
    public static final String USER_DEFINED_NAME = "UserDefinedName";
    public static final String UNIQUE_IDENTIFIER = "UniqueIdentifier";
    public static final String WIRELESS_NETWORK = "Wireless Network";
    public static final String EAP_CLIENT_CONFIGURATION = "EAPClientConfiguration";
    public static final String INACTIVE = "__INACTIVE__";
    private String cls_UserDefinedName = "";
    private String cls_UniqueIdentifier = "";
    private String cls_WirelessNetwork = "";
    private LeopardEap cls_EapConfig = new LeopardEap();
    private boolean cls_Inactive = false;

    public void setUserDefinedName(String string) {
        this.cls_UserDefinedName = string;
    }

    public String getUserDefinedName() {
        return this.cls_UserDefinedName;
    }

    public void setInactive(boolean bl) {
        this.cls_Inactive = bl;
    }

    public boolean getInactive() {
        return this.cls_Inactive;
    }

    public void setUniqueIdentifier(String string) {
        this.cls_UniqueIdentifier = string;
    }

    public String getUniqueIdentifier() {
        return this.cls_UniqueIdentifier;
    }

    public void setWirelessNetwork(String string) {
        this.cls_WirelessNetwork = string;
    }

    public String getWirelessNetwork() {
        return this.cls_WirelessNetwork;
    }

    public LeopardEap getEapConfig() {
        return this.cls_EapConfig;
    }

    public synchronized void parse(Dict dict) {
        this.setUniqueIdentifier(dict.getString(UNIQUE_IDENTIFIER, this.getUniqueIdentifier()));
        this.setUserDefinedName(dict.getString(USER_DEFINED_NAME, this.getUserDefinedName()));
        this.setWirelessNetwork(dict.getString(WIRELESS_NETWORK, this.getWirelessNetwork()));
        this.setInactive(dict.getBoolean(INACTIVE, this.getInactive()));
        Dict dict2 = dict.getDict(EAP_CLIENT_CONFIGURATION, new Dict());
        this.cls_EapConfig = new LeopardEap();
        this.cls_EapConfig.parse(dict2);
    }

    public Dict generate() {
        Dict dict = new Dict();
        dict.addPair(EAP_CLIENT_CONFIGURATION, this.cls_EapConfig.generateForPreferences(true, false));
        dict.addPair(UNIQUE_IDENTIFIER, this.getUniqueIdentifier());
        if (this.getUserDefinedName().length() > 0) {
            dict.addPair(USER_DEFINED_NAME, this.getUserDefinedName());
        }
        if (this.getWirelessNetwork().length() > 0) {
            dict.addPair(WIRELESS_NETWORK, this.getWirelessNetwork());
        }
        if (this.getInactive()) {
            dict.addPair(INACTIVE, this.getInactive());
        }
        return dict;
    }
}

