/*
 * Decompiled with CFR 0.152.
 */
package com.cloudpath.common.os.mac.leopard.network.systemconfig;

import com.cloudpath.common.os.mac.common.plist.PlistUtil;
import com.cloudpath.common.os.mac.common.plist.pojo.Dict;
import com.cloudpath.common.os.mac.common.plist.pojo.PairValue;
import com.cloudpath.common.os.mac.common.plist.pojo.ValueArray;
import com.cloudpath.common.os.mac.common.plist.pojo.ValueString;
import com.cloudpath.common.os.mac.leopard.network.airport.LeopardAirportNetwork;
import com.cloudpath.common.util.EnumUtil;
import java.util.Vector;
import org.apache.log4j.Logger;

public class LeopardLocationAirport {
    private static final Logger log = Logger.getLogger(LeopardLocationAirport.class);
    public static final String ALLOW_NET_CREATION = "AllowNetCreation";
    public static final String DISCONNECT_ON_LOGOUT = "DisconnectOnLogout";
    public static final String JOIN_MODE = "JoinMode";
    public static final String JOIN_MODE_FALLBACK = "JoinModeFallback";
    public static final String MAC_ADDRESS = "MACAddress";
    public static final String POWER_ENABLED = "PowerEnabled";
    public static final String PREFERRED_NETWORKS = "PreferredNetworks";
    public static final String REMEMBER_RECENT_NETWORKS = "RememberRecentNetworks";
    public static final String REQUIRE_ADMIN = "RequireAdmin";
    private long cls_AllowNetCreation = 0L;
    private boolean cls_DisconnectOnLogout = false;
    private JoinMode cls_JoinMode = JoinMode.Automatic;
    private JoinMode[] cls_JoinModeFallback = new JoinMode[]{JoinMode.Prompt};
    private String cls_MacAddress = "";
    private boolean cls_PowerEnabled = true;
    private boolean cls_RememberRecentNetworks = true;
    private boolean cls_RequireAdmin = false;
    private Vector<LeopardAirportNetwork> cls_PreferredNetworks = new Vector();

    public void setAllowNetCreation(long l) {
        this.cls_AllowNetCreation = l;
    }

    public long getAllowNetCreation() {
        return this.cls_AllowNetCreation;
    }

    public void setDisconnectOnLogout(boolean bl) {
        this.cls_DisconnectOnLogout = bl;
    }

    public boolean getDisconnectOnLogout() {
        return this.cls_DisconnectOnLogout;
    }

    public void setPowerEnabled(boolean bl) {
        this.cls_PowerEnabled = bl;
    }

    public boolean getPowerEnabled() {
        return this.cls_PowerEnabled;
    }

    public void setRememberRecentNetworks(boolean bl) {
        this.cls_RememberRecentNetworks = bl;
    }

    public boolean getRememberRecentNetworks() {
        return this.cls_RememberRecentNetworks;
    }

    public void setRequireAdmin(boolean bl) {
        this.cls_RequireAdmin = bl;
    }

    public boolean getRequireAdmin() {
        return this.cls_RequireAdmin;
    }

    public void setJoinMode(JoinMode joinMode) {
        this.cls_JoinMode = joinMode;
    }

    public JoinMode getJoinMode() {
        return this.cls_JoinMode;
    }

    public void setJoinModeFallback(JoinMode[] joinModeArray) {
        this.cls_JoinModeFallback = joinModeArray;
    }

    public JoinMode[] getJoinModeFallback() {
        return this.cls_JoinModeFallback;
    }

    public void setMacAddress(String string) {
        this.cls_MacAddress = string;
    }

    public String getMacAddress() {
        return this.cls_MacAddress;
    }

    public int getPreferredNetworkCount() {
        return this.cls_PreferredNetworks.size();
    }

    public int getPreferredNetworkIndexBySsid(String string) {
        for (int i = 0; i < this.cls_PreferredNetworks.size(); ++i) {
            if (!string.equals(this.cls_PreferredNetworks.get(i).getSsid())) continue;
            log.debug((Object)(" - Index of '" + string + "' is " + i + "."));
            return i;
        }
        log.debug((Object)("Unable to find index of '" + string + "'."));
        return -1;
    }

    public LeopardAirportNetwork getPreferredNetworkByNetworkId(String string) {
        log.debug((Object)("Looking network by network id of '" + string + "'."));
        for (int i = 0; i < this.cls_PreferredNetworks.size(); ++i) {
            log.debug((Object)(" - Looking at '" + this.cls_PreferredNetworks.get(i).getUniqueNetworkId() + "'."));
            if (!string.equals(this.cls_PreferredNetworks.get(i).getUniqueNetworkId())) continue;
            return this.cls_PreferredNetworks.get(i);
        }
        return null;
    }

    public void removePreferredNetworkByNetworkId(String string) {
        for (int i = 0; i < this.cls_PreferredNetworks.size(); ++i) {
            if (!string.equals(this.cls_PreferredNetworks.get(i).getUniqueNetworkId())) continue;
            this.cls_PreferredNetworks.remove(i);
            --i;
        }
    }

    public void removePreferredNetworkBySsid(String string) {
        log.debug((Object)("Remove network by ssid " + string));
        for (int i = 0; i < this.cls_PreferredNetworks.size(); ++i) {
            if (!string.equals(this.cls_PreferredNetworks.get(i).getSsid())) continue;
            this.cls_PreferredNetworks.remove(i);
            --i;
        }
    }

    public void setPreferredNetwork(int n, LeopardAirportNetwork leopardAirportNetwork) {
        log.debug((Object)("Setting preferred network " + leopardAirportNetwork.getSsid() + " at index " + n + " (" + leopardAirportNetwork.getUniqueNetworkId() + ")"));
        this.removePreferredNetworkByNetworkId(leopardAirportNetwork.getUniqueNetworkId());
        if (n < this.cls_PreferredNetworks.size()) {
            this.cls_PreferredNetworks.insertElementAt(leopardAirportNetwork, n);
        } else {
            this.cls_PreferredNetworks.add(leopardAirportNetwork);
        }
    }

    public synchronized void parse(Dict dict) {
        log.debug((Object)"     - Parsing airport.");
        this.setAllowNetCreation(dict.getInteger(ALLOW_NET_CREATION, this.getAllowNetCreation()));
        this.setDisconnectOnLogout(dict.getBoolean(DISCONNECT_ON_LOGOUT, this.getDisconnectOnLogout()));
        String string = dict.getString(JOIN_MODE, this.getJoinMode().toString());
        this.setJoinMode((JoinMode)EnumUtil.parse(JoinMode.class, string, JoinMode.Prompt));
        String[] stringArray = PlistUtil.getStringArrayValue(dict, JOIN_MODE_FALLBACK);
        JoinMode[] joinModeArray = new JoinMode[stringArray.length];
        for (int i = 0; i < joinModeArray.length; ++i) {
            joinModeArray[i] = (JoinMode)EnumUtil.parse(JoinMode.class, stringArray[i], JoinMode.Prompt);
        }
        this.setJoinModeFallback(joinModeArray);
        this.setMacAddress(dict.getString(MAC_ADDRESS, this.getMacAddress()));
        this.setPowerEnabled(dict.getBoolean(POWER_ENABLED, this.getPowerEnabled()));
        this.setRememberRecentNetworks(dict.getBoolean(REMEMBER_RECENT_NETWORKS, this.getRememberRecentNetworks()));
        this.setRequireAdmin(dict.getBoolean(REQUIRE_ADMIN, this.getRequireAdmin()));
        this.cls_PreferredNetworks.clear();
        ValueArray valueArray = dict.getArray(PREFERRED_NETWORKS, new ValueArray());
        for (int i = 0; i < valueArray.getValueCount(); ++i) {
            PairValue pairValue = valueArray.getValue(i);
            if (pairValue == null || !(pairValue instanceof Dict)) continue;
            LeopardAirportNetwork leopardAirportNetwork = new LeopardAirportNetwork();
            leopardAirportNetwork.parse("", (Dict)pairValue);
            log.debug((Object)("       - Adding network " + i + " -> " + leopardAirportNetwork.getSsid()));
            this.cls_PreferredNetworks.add(leopardAirportNetwork);
        }
    }

    public Dict generate() {
        Dict dict = new Dict();
        if (this.getAllowNetCreation() > 0L) {
            dict.addPair(ALLOW_NET_CREATION, this.getAllowNetCreation());
        }
        dict.addPair(DISCONNECT_ON_LOGOUT, this.getDisconnectOnLogout());
        dict.addPair(JOIN_MODE, this.getJoinMode().name());
        ValueArray valueArray = new ValueArray();
        JoinMode[] joinModeArray = this.getJoinModeFallback();
        for (int i = 0; i < joinModeArray.length; ++i) {
            valueArray.addValue(new ValueString(joinModeArray[i].name()));
        }
        dict.addPair(JOIN_MODE_FALLBACK, valueArray);
        if (this.getMacAddress() != null && this.getMacAddress().length() > 0) {
            dict.addPair(MAC_ADDRESS, this.getMacAddress());
        }
        dict.addPair(POWER_ENABLED, this.getPowerEnabled());
        ValueArray valueArray2 = new ValueArray();
        for (int i = 0; i < this.cls_PreferredNetworks.size(); ++i) {
            Dict dict2 = this.cls_PreferredNetworks.get(i).generateRecentNetwork();
            valueArray2.addValue(dict2);
        }
        dict.addPair(PREFERRED_NETWORKS, valueArray2);
        dict.addPair(REMEMBER_RECENT_NETWORKS, this.getRememberRecentNetworks());
        dict.addPair(REQUIRE_ADMIN, this.getRequireAdmin());
        return dict;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum JoinMode {
        Automatic,
        Prompt,
        DoNothing,
        Ranked,
        Preferred,
        Recent,
        Strongest,
        JoinOpen,
        KeepLooking;

    }
}

