/*
 * Decompiled with CFR 0.152.
 */
package com.cloudpath.common.os.mac.leopard.network.eap;

import com.cloudpath.common.command.CommandHandler;
import com.cloudpath.common.os.mac.common.network.eap.EapProfileManager;
import com.cloudpath.common.os.mac.common.plist.PlistUtil;
import com.cloudpath.common.os.mac.common.util.KeychainException;
import com.cloudpath.common.os.mac.leopard.cmd.Maccmd;
import com.cloudpath.common.os.mac.leopard.network.eap.LeopardEap;
import com.cloudpath.common.os.mac.leopard.network.eap.LeopardEapBinding;
import com.cloudpath.common.os.mac.leopard.network.eap.LeopardEapBindingPlist;
import com.cloudpath.common.os.mac.leopard.network.eap.LeopardEapProfile;
import com.cloudpath.common.os.mac.leopard.network.eap.LeopardEapProfilePlist;
import com.cloudpath.common.os.mac.leopard.network.systemconfig.LeopardLocationEapolLoginProfile;
import com.cloudpath.common.os.mac.leopard.network.systemconfig.LeopardLocationEapolLoginProfiles;
import com.cloudpath.common.os.mac.leopard.network.systemconfig.LeopardPreferencePlist;
import com.cloudpath.common.util.FileHandler;
import com.cloudpath.common.util.SpecializedException;
import com.cloudpath.common.util.Util;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Vector;
import org.apache.log4j.Logger;

public class LeopardEapProfileManager
implements EapProfileManager {
    private static final Logger log = Logger.getLogger(LeopardEapProfileManager.class);
    private static int INSTANCE_COUNT = 0;
    public static final String SYSTEM_PROFILE = "[SYSTEM]";
    public static final String LOGIN_PROFILE = "LOGIN:";
    private final LeopardPreferencePlist cls_Preferences;
    private final LeopardEapProfilePlist cls_EapProfilePlist;
    private final Vector<LeopardEapProfile> cls_DeletedProfiles = new Vector();
    private final Maccmd cls_Maccmd;
    private final LeopardEapBindingPlist cls_EapBindingPlist;

    public LeopardEapProfileManager(FileHandler fileHandler, CommandHandler commandHandler, Maccmd maccmd, LeopardPreferencePlist leopardPreferencePlist, LeopardEapBindingPlist leopardEapBindingPlist) {
        this.cls_Preferences = leopardPreferencePlist;
        this.cls_EapProfilePlist = new LeopardEapProfilePlist(fileHandler, commandHandler);
        this.cls_EapBindingPlist = leopardEapBindingPlist;
        this.cls_Maccmd = maccmd;
        if (INSTANCE_COUNT++ > 0) {
            log.error((Object)"Invalid duplicant instantiation.", (Throwable)new Exception("Duplicate instantiation of " + this.getClass().getName()));
        }
    }

    public int getProfileCount() {
        return this.cls_EapProfilePlist.getProfileCount();
    }

    public LeopardEapProfile getProfile(int n) {
        return this.cls_EapProfilePlist.getProfile(n);
    }

    public LeopardEapProfile getProfileByName(String string) {
        return this.cls_EapProfilePlist.getProfileByName(string);
    }

    public LeopardEapProfile getProfileByUniqueIdentifier(String string) {
        return this.cls_EapProfilePlist.getProfileByUniqueIdentifier(string);
    }

    public void addProfile(LeopardEapProfile leopardEapProfile, String string) {
        this.resolveConflicts(leopardEapProfile, string, false, null);
        this.cls_EapProfilePlist.setProfile(leopardEapProfile);
    }

    public void deleteProfile(String string) {
        log.debug((Object)("Will delete profile '" + string + "'."));
        LeopardEapProfile leopardEapProfile = this.cls_EapProfilePlist.getProfileByName(string);
        if (leopardEapProfile != null) {
            this.cls_EapProfilePlist.removeProfile(string);
            this.cls_DeletedProfiles.add(leopardEapProfile);
        }
    }

    public void refresh(String string) {
        Object object;
        LeopardEap leopardEap;
        log.debug((Object)"Will refresh eap profile information.");
        this.cls_DeletedProfiles.clear();
        this.cls_EapProfilePlist.refresh();
        if (this.cls_Preferences != null) {
            this.cls_Preferences.refresh();
        }
        if ((leopardEap = this.cls_Preferences.getCurrentLocation().getInterface(string).getEapolSystemProfile()) != null) {
            log.debug((Object)"- System eap profile exists.");
            object = new LeopardEapProfile();
            ((LeopardEapProfile)object).setEapConfig(leopardEap);
            ((LeopardEapProfile)object).setConnectByDefault(true);
            ((LeopardEapProfile)object).setUserDefinedName(SYSTEM_PROFILE);
            ((LeopardEapProfile)object).getEapConfig().setInactive(false);
            this.cls_EapProfilePlist.setProfile((LeopardEapProfile)object);
        } else {
            log.debug((Object)"- System eap profile does not exist.");
        }
        object = this.cls_Preferences.getCurrentLocation().getInterface(string).getEapolLoginProfiles();
        if (object != null && ((LeopardLocationEapolLoginProfiles)object).getCount() > 0) {
            for (int i = 0; i < ((LeopardLocationEapolLoginProfiles)object).getCount(); ++i) {
                LeopardLocationEapolLoginProfile leopardLocationEapolLoginProfile = ((LeopardLocationEapolLoginProfiles)object).getProfile(i);
                log.debug((Object)("- Read login profile '" + leopardLocationEapolLoginProfile.getUserDefinedName() + "'."));
                LeopardEapProfile leopardEapProfile = new LeopardEapProfile();
                leopardEapProfile.setEapConfig(leopardLocationEapolLoginProfile.getEapConfig());
                leopardEapProfile.setConnectByDefault(true);
                leopardEapProfile.setUserDefinedName(LOGIN_PROFILE + leopardLocationEapolLoginProfile.getUserDefinedName());
                leopardEapProfile.getEapConfig().setInactive(false);
                this.cls_EapProfilePlist.setProfile(leopardEapProfile);
            }
        } else {
            log.debug((Object)"- Login eap profile does not exist.");
        }
    }

    public void commit(String string, boolean bl) throws IOException, SpecializedException {
        int n;
        Object object;
        Cloneable cloneable;
        log.debug((Object)"Will commit profiles.");
        this.cls_Preferences.refresh();
        log.debug((Object)"Will clean up keychain for deleted profiles...");
        for (int i = 0; i < this.cls_DeletedProfiles.size(); ++i) {
            cloneable = this.cls_DeletedProfiles.get(i);
            if (cloneable == null) continue;
            String string2 = ((LeopardEapProfile)cloneable).getEapConfig().getUserName();
            object = ((LeopardEapProfile)cloneable).getEapConfig().getUserPasswordKeychainItemId();
            if (object == null || ((String)object).length() <= 0) continue;
            log.info((Object)("Will remove password from keychain for account '" + string2 + "' and service '" + (String)object + "'."));
            this.cls_Maccmd.deleteGenericPassword(Maccmd.Keychain.login, string2, (String)object);
        }
        this.cls_DeletedProfiles.clear();
        log.debug((Object)"Done cleaning up keychain for deleted profiles.");
        LeopardEapProfile leopardEapProfile = this.getProfileByName(SYSTEM_PROFILE);
        if (leopardEapProfile != null) {
            leopardEapProfile = (LeopardEapProfile)leopardEapProfile.clone();
            this.cls_EapProfilePlist.removeProfile(SYSTEM_PROFILE);
        }
        cloneable = new ArrayList();
        for (n = 0; n < this.cls_EapProfilePlist.getProfileCount(); ++n) {
            object = this.cls_EapProfilePlist.getProfile(n);
            if (!((LeopardEapProfile)object).getUserDefinedName().startsWith(LOGIN_PROFILE)) continue;
            log.debug((Object)("Will commit login profile " + ((LeopardEapProfile)object).getUserDefinedName()));
            ((ArrayList)cloneable).add(object);
            this.cls_EapProfilePlist.removeProfile(((LeopardEapProfile)object).getUserDefinedName());
        }
        for (n = 0; n < this.cls_EapProfilePlist.getProfileCount(); ++n) {
            object = this.cls_EapProfilePlist.getProfile(n);
            LeopardEapProfileManager.processProfilePassword(this.cls_Maccmd, (LeopardEapProfile)object, false, bl);
        }
        log.debug((Object)"Will write profiles...");
        this.cls_EapProfilePlist.write();
        log.debug((Object)"Profiles written.");
        this.cls_EapProfilePlist.refresh();
        if (leopardEapProfile == null) {
            log.debug((Object)"No system profile found for interface.  Will delete from preferences.");
            LeopardEap leopardEap = this.cls_Preferences.getCurrentLocation().getInterface(string).getEapolSystemProfile();
            if (leopardEap != null) {
                log.debug((Object)"Will delete old password for system profile.");
                this.cls_Maccmd.deleteGenericPassword(Maccmd.Keychain.system, "", leopardEap.getUserPasswordKeychainItemId());
                this.cls_Preferences.getCurrentLocation().getInterface(string).setEapolSystemProfile(null);
            }
        } else {
            log.debug((Object)"System profile found.  Will add to preferences.");
            leopardEapProfile.getEapConfig().setUserPasswordKeychainItemId("");
            LeopardEapProfileManager.processProfilePassword(this.cls_Maccmd, leopardEapProfile, true, bl);
            this.cls_Preferences.getCurrentLocation().getInterface(string).setEapolSystemProfile(leopardEapProfile.getEapConfig());
        }
        if (((ArrayList)cloneable).size() == 0) {
            log.debug((Object)"No login profiles found for interface.  Will delete from preferences.");
            this.cls_Preferences.getCurrentLocation().getInterface(string).getEapolLoginProfiles().clear();
        } else {
            log.debug((Object)"Login profiles found to commit.  Will add to preferences.");
            for (int i = 0; i < ((ArrayList)cloneable).size(); ++i) {
                object = ((LeopardEapProfile)((ArrayList)cloneable).get(i)).getUserDefinedName().substring(LOGIN_PROFILE.length());
                String string3 = ((LeopardEapProfile)((ArrayList)cloneable).get(i)).getUniqueIdentifier();
                if (string3 == null || string3.length() == 0) {
                    string3 = Util.generateGuid();
                }
                log.info((Object)("Will commit login profile name is '" + (String)object + "'.  UUID is '" + string3 + "'."));
                ((LeopardEapProfile)((ArrayList)cloneable).get(i)).getEapConfig().setUserPasswordKeychainItemId("");
                LeopardEapProfile leopardEapProfile2 = (LeopardEapProfile)((ArrayList)cloneable).get(i);
                LeopardLocationEapolLoginProfile leopardLocationEapolLoginProfile = new LeopardLocationEapolLoginProfile();
                leopardLocationEapolLoginProfile.setInactive(leopardEapProfile2.getEapConfig().getInactive());
                leopardLocationEapolLoginProfile.setUniqueIdentifier(string3);
                leopardLocationEapolLoginProfile.setUserDefinedName((String)object);
                leopardLocationEapolLoginProfile.setWirelessNetwork((String)object);
                leopardLocationEapolLoginProfile.getEapConfig().populateFrom(leopardEapProfile2.getEapConfig());
                log.debug((Object)("Eap config to be committed: " + leopardLocationEapolLoginProfile.getEapConfig().getSummary()));
                this.cls_Preferences.getCurrentLocation().getInterface(string).getEapolLoginProfiles().addKey(string3, leopardLocationEapolLoginProfile);
            }
        }
        log.debug((Object)"Will write preferences...");
        this.cls_Preferences.write();
        this.cls_Preferences.refresh();
    }

    private static void processProfilePassword(Maccmd maccmd, LeopardEapProfile leopardEapProfile, boolean bl, boolean bl2) throws SpecializedException {
        if (leopardEapProfile != null) {
            String string;
            log.debug((Object)("Will prepare profile '" + leopardEapProfile.getUserDefinedName() + "'..."));
            if (leopardEapProfile.getDesiredPassword().length() > 0) {
                log.debug((Object)"  - Profile has new password.");
                string = leopardEapProfile.getDesiredPassword();
            } else if (leopardEapProfile.getEapConfig().getUserPasswordKeychainItemId().length() == 0) {
                log.debug((Object)"  - Profile is new but does not have password.");
                string = leopardEapProfile.getEapConfig().isTlsOnly() ? null : "";
            } else {
                log.debug((Object)"  - Profile is existing and does not have a password change.");
                string = null;
            }
            if (string != null) {
                String string2;
                String string3;
                if (leopardEapProfile.getEapConfig().getUserPasswordKeychainItemId() == null || leopardEapProfile.getEapConfig().getUserPasswordKeychainItemId().length() == 0) {
                    string3 = PlistUtil.generateGuid();
                    log.debug((Object)("  - Profile is being assigned guid " + string3));
                    leopardEapProfile.getEapConfig().setUserPasswordKeychainItemId(string3);
                    leopardEapProfile.setUniqueIdentifier(string3);
                } else {
                    log.debug((Object)("  - Profile has existing guid " + leopardEapProfile.getEapConfig().getUserPasswordKeychainItemId()));
                    string3 = PlistUtil.generateGuid();
                    leopardEapProfile.getEapConfig().setUserPasswordKeychainItemId(string3);
                    leopardEapProfile.setUniqueIdentifier(string3);
                }
                if (bl) {
                    string3 = "802.1X Password";
                    string2 = "";
                } else {
                    string3 = "Network password for " + leopardEapProfile.getUserDefinedName();
                    string2 = leopardEapProfile.getEapConfig().getUserName();
                }
                String string4 = leopardEapProfile.getEapConfig().getUserPasswordKeychainItemId();
                String string5 = "Internet Connect";
                String string6 = "This password is for network access.  At the time of creation, it was used by the 802.1X profile named '" + leopardEapProfile.getUserDefinedName() + "'.  If you delete this password, you will be prompted to enter your password when accessing the network.";
                log.debug((Object)("Will create keychain entry for account '" + string2 + "' and service '" + string4 + "' with display label '" + string3 + "'."));
                int n = maccmd.setGenericPassword(bl ? Maccmd.Keychain.system : Maccmd.Keychain.login, string3, string2, string4, string5, string6, string);
                if (n != 0) {
                    log.warn((Object)("The attempt to set the password into the keychain failed.  Error code was " + n + "."));
                    if (bl2) {
                        throw new KeychainException(n);
                    }
                }
            }
            leopardEapProfile.setUniqueIdentifier(leopardEapProfile.getEapConfig().getUserPasswordKeychainItemId());
            if (leopardEapProfile.getUserDefinedName().length() == 0) {
                leopardEapProfile.setUserDefinedName(PlistUtil.generateGuid());
            }
            log.debug((Object)("Done with profile " + leopardEapProfile.getUserDefinedName()));
        }
    }

    public boolean isKeychainPasswordCorrect(Maccmd.Keychain keychain, String string, String string2, String string3) {
        return this.cls_Maccmd.doesGenericPasswordMatch(keychain, string, string2, string3);
    }

    public void resolveConflicts(LeopardEapProfile leopardEapProfile, String string, boolean bl, String string2) {
        boolean bl2 = false;
        try {
            String string3;
            log.info((Object)"Will resolve conflicts...");
            String string4 = leopardEapProfile != null ? leopardEapProfile.getWirelessNetwork() : "";
            log.info((Object)("  - Will look for other EAP profiles using this SSID '" + string4 + "' on mac address '" + string + "'."));
            String string5 = string3 = leopardEapProfile != null ? leopardEapProfile.getUniqueIdentifier() : null;
            if (this.cls_EapBindingPlist != null && string != null && string4 != null) {
                LeopardEapProfile leopardEapProfile2;
                int n;
                log.info((Object)"  - Will process bindings.");
                LeopardEapBinding[] leopardEapBindingArray = this.cls_EapBindingPlist.getBindingsBySsid(string, string4);
                if (leopardEapBindingArray != null) {
                    log.info((Object)(leopardEapBindingArray.length + " EAP Bindings exist."));
                }
                for (n = 0; leopardEapBindingArray != null && n < leopardEapBindingArray.length; ++n) {
                    if (leopardEapBindingArray[n] == null || leopardEapBindingArray[n].getUniqueIdentifier() == null) continue;
                    log.info((Object)("  - Unique ID is " + leopardEapBindingArray[n].getUniqueIdentifier()));
                    if (string3 != null && string3.equals(leopardEapBindingArray[n].getUniqueIdentifier())) continue;
                    log.info((Object)("   - New profile unique identifier is: " + string3));
                    log.info((Object)("   - The EAP profile with uniqueId '" + leopardEapBindingArray[n].getUniqueIdentifier() + "' is pointing at '" + string4 + "'."));
                    leopardEapProfile2 = this.getProfileByUniqueIdentifier(leopardEapBindingArray[n].getUniqueIdentifier());
                    if (leopardEapProfile2 != null) {
                        log.warn((Object)("   - Will delete EAP profile '" + leopardEapProfile2.getUserDefinedName() + "' because it points at the ssid '" + string4 + "'."));
                        this.deleteProfile(leopardEapProfile2.getUserDefinedName());
                        bl2 = true;
                        continue;
                    }
                    log.info((Object)"   - Other profile not found.");
                }
                log.info((Object)"Will process profiles...");
                for (n = 0; n < this.getProfileCount(); ++n) {
                    leopardEapProfile2 = this.getProfile(n);
                    String string6 = leopardEapProfile2.getWirelessNetwork();
                    log.info((Object)("Looking for ssid '" + string4 + "'."));
                    if (leopardEapProfile == null || string6 == null || !string6.equals(string4)) continue;
                    log.info((Object)("  - Found ssid profile with unique ID " + (leopardEapProfile2 != null ? leopardEapProfile2.getUniqueIdentifier() : "Null")));
                    if (leopardEapProfile.getUniqueIdentifier() != null && leopardEapProfile.getUniqueIdentifier().equals(leopardEapProfile2.getUniqueIdentifier())) continue;
                    log.info((Object)("   - Found unique id '" + leopardEapProfile.getUniqueIdentifier() + "'... (" + leopardEapProfile2.getUserDefinedName() + ").  Will delete '" + leopardEapProfile2.getUserDefinedName() + "'."));
                    this.deleteProfile(leopardEapProfile2.getUserDefinedName());
                    --n;
                    bl2 = true;
                }
                log.info((Object)("Will look by default profile name 'WPA: " + string4 + "'..."));
                LeopardEapProfile leopardEapProfile3 = this.getProfileByName("WPA: " + string4);
                if (leopardEapProfile3 != null) {
                    log.info((Object)("  - Found profile by default name at " + leopardEapProfile3.getUniqueIdentifier()));
                    if (string3 == null || !string3.equals(leopardEapProfile3.getUniqueIdentifier())) {
                        log.info((Object)"An EAP profile still exists with the default WPA name for the ssid.  Will delete it.");
                        this.deleteProfile("WPA: " + string4);
                        bl2 = true;
                    } else {
                        log.info((Object)("Profile found by name 'WPA: " + string4 + "' but either (a) our profile is new or (b) the unique IDs are different."));
                    }
                }
                log.info((Object)("Will look by default profile name 'WPA2: " + string4 + "'..."));
                leopardEapProfile3 = this.getProfileByName("WPA2: " + string4);
                if (leopardEapProfile3 != null) {
                    log.info((Object)("  - Found profile by default name at " + leopardEapProfile3.getUniqueIdentifier()));
                    if (string3 == null || !string3.equals(leopardEapProfile3.getUniqueIdentifier())) {
                        log.info((Object)"An EAP profile still exists with the default WPA2 name for the ssid.  Will delete it.");
                        this.deleteProfile("WPA2: " + string4);
                        bl2 = true;
                    } else {
                        log.info((Object)("Profile found by name 'WPA2: " + string4 + "' but either (a) our profile is new or (b) the unique IDs are different."));
                    }
                }
            }
        }
        catch (Exception exception) {
            log.error((Object)"An exception occurred while resolving conflicts.", (Throwable)exception);
        }
        log.info((Object)("Done resolving conflicts.  CommitOnChanges: " + bl + ", ChangesOccurred: " + bl2));
        if (bl && bl2) {
            try {
                log.info((Object)"Will commit changes...");
                this.commit(string2, false);
            }
            catch (Exception exception) {
                log.error((Object)"Failed to commit changes after cleaning up conflicts.", (Throwable)exception);
            }
        }
        log.info((Object)"Done resolving conflicts.");
    }
}

