/*
 * Decompiled with CFR 0.152.
 */
package com.cloudpath.common.os.mac.leopard.network.eap;

import com.cloudpath.common.command.CommandHandler;
import com.cloudpath.common.os.mac.common.MacUtil;
import com.cloudpath.common.os.mac.common.plist.PlistUtil;
import com.cloudpath.common.os.mac.common.plist.pojo.Dict;
import com.cloudpath.common.os.mac.common.plist.pojo.Pair;
import com.cloudpath.common.os.mac.common.plist.pojo.PairValue;
import com.cloudpath.common.os.mac.common.plist.pojo.Plist;
import com.cloudpath.common.os.mac.common.plist.pojo.ValueArray;
import com.cloudpath.common.os.mac.leopard.network.eap.LeopardEapBinding;
import com.cloudpath.common.util.FileHandler;
import com.cloudpath.common.util.FileUtil;
import com.cloudpath.common.util.Util;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.log4j.Logger;

public class LeopardEapBindingPlist {
    private static final Logger log = Logger.getLogger(LeopardEapBindingPlist.class);
    public static final String DIRECTORY = "/Library/Preferences/ByHost";
    public static final String FILE = "/Library/Preferences/ByHost/com.apple.eap.bindings.${SYSTEM_ID}.plist";
    private final FileHandler cls_FileHandler;
    private final CommandHandler cls_CommandHandler;
    private final File cls_File;
    private final HashMap<String, LeopardEapBinding[]> cls_MacToBindings = new HashMap();

    public LeopardEapBindingPlist(FileHandler fileHandler, CommandHandler commandHandler, String string) {
        this.cls_FileHandler = fileHandler;
        this.cls_CommandHandler = commandHandler;
        this.cls_File = new File(FileUtil.getUserHome(), Util.replaceVariable(FILE, "SYSTEM_ID", MacUtil.formatSystemIdForByHost(string)));
    }

    public File getFile() {
        return this.cls_File;
    }

    public void refresh() {
        log.info((Object)" -  Will refresh EAP binding information.");
        Plist plist = this.getCurrentPlist();
        if (plist != null) {
            this.parse(plist);
        } else {
            log.error((Object)" - EAP binding information is null.");
            this.cls_MacToBindings.clear();
        }
    }

    public void write() throws IOException {
        log.info((Object)"Will write eap bindings information.");
        Plist plist = this.generatePlist();
        log.debug((Object)("Will write file " + this.cls_File + " to handler."));
        this.cls_FileHandler.writeFile(this.cls_File, plist.getXml());
    }

    public LeopardEapBinding[] getBindingsByMac(String string) {
        LeopardEapBinding[] leopardEapBindingArray = this.cls_MacToBindings.get(string = LeopardEapBindingPlist.formatMacForDict(string));
        return leopardEapBindingArray != null ? leopardEapBindingArray : new LeopardEapBinding[]{};
    }

    public LeopardEapBinding getBindingBySsid(String string, String string2) {
        log.debug((Object)("Will find binding for ssid '" + string2 + "' on mac '" + string + "'."));
        if (string2 != null) {
            LeopardEapBinding[] leopardEapBindingArray = this.getBindingsByMac(string);
            for (int i = 0; leopardEapBindingArray != null && i < leopardEapBindingArray.length; ++i) {
                if (leopardEapBindingArray[i] == null) continue;
                log.debug((Object)("  - Looking at Binding for " + leopardEapBindingArray[i].getSsid()));
                if (!string2.equals(leopardEapBindingArray[i].getSsid())) continue;
                return leopardEapBindingArray[i];
            }
        }
        log.debug((Object)"  - Did not find binding.");
        return null;
    }

    public LeopardEapBinding[] getBindingsByUniqueId(String string, String string2) {
        log.debug((Object)("Will look for bindings by uniqueId '" + string2 + "' on mac '" + string + "'."));
        ArrayList<LeopardEapBinding> arrayList = new ArrayList<LeopardEapBinding>();
        LeopardEapBinding[] leopardEapBindingArray = this.getBindingsByMac(string);
        if (string2 != null && leopardEapBindingArray != null) {
            for (int i = 0; i < leopardEapBindingArray.length; ++i) {
                if (leopardEapBindingArray[i] == null) continue;
                log.debug((Object)(" - Looking at " + leopardEapBindingArray[i].getUniqueIdentifier()));
                if (!string2.equals(leopardEapBindingArray[i].getSsid())) continue;
                arrayList.add(leopardEapBindingArray[i]);
            }
        }
        LeopardEapBinding[] leopardEapBindingArray2 = new LeopardEapBinding[arrayList.size()];
        arrayList.toArray(leopardEapBindingArray2);
        return leopardEapBindingArray2;
    }

    public LeopardEapBinding[] getBindingsBySsid(String string, String string2) {
        log.debug((Object)("Will look for bindings by ssid '" + string2 + "' on mac '" + string + "'."));
        ArrayList<LeopardEapBinding> arrayList = new ArrayList<LeopardEapBinding>();
        LeopardEapBinding[] leopardEapBindingArray = this.getBindingsByMac(string);
        if (string2 != null && leopardEapBindingArray != null) {
            for (int i = 0; i < leopardEapBindingArray.length; ++i) {
                log.debug((Object)(" - Looking at " + leopardEapBindingArray[i].getSsid()));
                if (!string2.equals(leopardEapBindingArray[i].getSsid())) continue;
                arrayList.add(leopardEapBindingArray[i]);
            }
        }
        LeopardEapBinding[] leopardEapBindingArray2 = new LeopardEapBinding[arrayList.size()];
        arrayList.toArray(leopardEapBindingArray2);
        return leopardEapBindingArray2;
    }

    public void removeEapBinding(String string, String string2) {
        log.debug((Object)("Will remove eap binding for mac '" + string + "' and ssid '" + string2 + "'."));
        string = LeopardEapBindingPlist.formatMacForDict(string);
        ArrayList<LeopardEapBinding> arrayList = new ArrayList<LeopardEapBinding>();
        LeopardEapBinding[] leopardEapBindingArray = this.cls_MacToBindings.get(string);
        if (string2 != null && leopardEapBindingArray != null) {
            for (int i = 0; i < leopardEapBindingArray.length; ++i) {
                if (string2.equals(leopardEapBindingArray[i].getSsid())) continue;
                arrayList.add(leopardEapBindingArray[i]);
            }
            LeopardEapBinding[] leopardEapBindingArray2 = new LeopardEapBinding[arrayList.size()];
            arrayList.toArray(leopardEapBindingArray2);
            this.cls_MacToBindings.put(string, leopardEapBindingArray2);
        }
    }

    public void removeEapBindingByUniqueId(String string, String string2) {
        log.debug((Object)("Will remove eap bindings for id '" + string2 + "' and mac '" + string + "'."));
        if (string2 != null) {
            string = LeopardEapBindingPlist.formatMacForDict(string);
            ArrayList<LeopardEapBinding> arrayList = new ArrayList<LeopardEapBinding>();
            LeopardEapBinding[] leopardEapBindingArray = this.cls_MacToBindings.get(string);
            if (leopardEapBindingArray != null) {
                for (int i = 0; i < leopardEapBindingArray.length; ++i) {
                    if (leopardEapBindingArray[i] == null || string2.equals(leopardEapBindingArray[i].getUniqueIdentifier())) continue;
                    arrayList.add(leopardEapBindingArray[i]);
                }
                LeopardEapBinding[] leopardEapBindingArray2 = new LeopardEapBinding[arrayList.size()];
                arrayList.toArray(leopardEapBindingArray2);
                this.cls_MacToBindings.put(string, leopardEapBindingArray2);
            }
        }
    }

    public void setEapBinding(String string, String string2, String string3) {
        log.debug((Object)("  - Will set binding for '" + string + "' and '" + string2 + "' and '" + string3 + "'."));
        string = LeopardEapBindingPlist.formatMacForDict(string);
        string3 = string3 != null ? string3 : "";
        string2 = string2 != null ? string2 : "";
        LeopardEapBinding leopardEapBinding = this.getBindingBySsid(string, string2);
        if (leopardEapBinding != null) {
            log.debug((Object)"   - Binding exists.");
            leopardEapBinding.setUniqueIdentifier(string3);
        } else {
            log.debug((Object)"   - Binding does not exist.");
            LeopardEapBinding[] leopardEapBindingArray = null;
            if (this.cls_MacToBindings.containsKey(string)) {
                leopardEapBindingArray = this.cls_MacToBindings.get(string);
            }
            if (leopardEapBindingArray == null) {
                leopardEapBindingArray = new LeopardEapBinding[]{};
            }
            leopardEapBinding = new LeopardEapBinding();
            leopardEapBinding.setSsid(string2);
            leopardEapBinding.setUniqueIdentifier(string3);
            LeopardEapBinding[] leopardEapBindingArray2 = new LeopardEapBinding[leopardEapBindingArray.length + 1];
            leopardEapBindingArray2[0] = leopardEapBinding;
            System.arraycopy(leopardEapBindingArray, 0, leopardEapBindingArray2, 1, leopardEapBindingArray.length);
            this.cls_MacToBindings.put(string, leopardEapBindingArray2);
        }
    }

    public Plist getCurrentPlist() {
        return PlistUtil.getCurrentPlist(this.cls_FileHandler, this.cls_CommandHandler, this.cls_File, new Plist());
    }

    protected synchronized void parse(Plist plist) {
        this.cls_MacToBindings.clear();
        if (plist.getDict() == null) {
            plist.setDict(new Dict());
        }
        for (int i = 0; i < plist.getDict().getPairCount(); ++i) {
            LeopardEapBinding[] leopardEapBindingArray;
            Pair pair = plist.getDict().getPair(i);
            if (pair == null) continue;
            String string = pair.getKey();
            ArrayList<LeopardEapBinding> arrayList = new ArrayList<LeopardEapBinding>();
            if (pair.getValue() instanceof ValueArray) {
                leopardEapBindingArray = (LeopardEapBinding[])pair.getValue();
                for (int j = 0; j < leopardEapBindingArray.getValueCount(); ++j) {
                    PairValue pairValue = leopardEapBindingArray.getValue(j);
                    LeopardEapBinding leopardEapBinding = new LeopardEapBinding();
                    if (pairValue instanceof Dict) {
                        leopardEapBinding.parse((Dict)pairValue);
                    }
                    arrayList.add(leopardEapBinding);
                }
            }
            leopardEapBindingArray = new LeopardEapBinding[arrayList.size()];
            arrayList.toArray(leopardEapBindingArray);
            this.cls_MacToBindings.put(string, leopardEapBindingArray);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Plist generatePlist() {
        Object[] objectArray;
        Dict dict = new Dict();
        HashMap<String, LeopardEapBinding[]> hashMap = this.cls_MacToBindings;
        synchronized (hashMap) {
            objectArray = this.cls_MacToBindings.keySet().toArray();
        }
        for (int i = 0; objectArray != null && i < objectArray.length; ++i) {
            String string = objectArray[i] != null ? objectArray[i].toString() : "";
            LeopardEapBinding[] leopardEapBindingArray = this.cls_MacToBindings.get(objectArray[i]);
            ValueArray valueArray = new ValueArray();
            for (int j = 0; leopardEapBindingArray != null && j < leopardEapBindingArray.length; ++j) {
                valueArray.addValue(leopardEapBindingArray[j].generate());
            }
            dict.addPair(string, valueArray);
        }
        Plist plist = new Plist();
        plist.setDict(dict);
        return plist;
    }

    protected static final String formatMacForFileName(String string) {
        if (string == null) {
            string = "";
        }
        string = string.replace(":", "").toLowerCase();
        while (string.length() < 12) {
            string = string + "0";
        }
        return string.substring(0, 12);
    }

    protected static final String formatMacForDict(String string) {
        string = LeopardEapBindingPlist.formatMacForFileName(string);
        return string.substring(0, 2) + ":" + string.substring(2, 4) + ":" + string.substring(4, 6) + ":" + string.substring(6, 8) + ":" + string.substring(8, 10) + ":" + string.substring(10, 12);
    }
}

