/*
 * Decompiled with CFR 0.152.
 */
package com.cloudpath.common.os.mac.leopard.network.airport;

import com.cloudpath.common.os.common.WirelessAssociation;
import com.cloudpath.common.os.mac.common.network.airport.AirportReader;
import com.cloudpath.common.os.mac.common.network.airport.SsidListener;
import com.cloudpath.common.util.Util;
import org.apache.log4j.Logger;

public class LeopardSsidMonitor
implements Runnable {
    private static final Logger log = Logger.getLogger(LeopardSsidMonitor.class);
    private final AirportReader cls_WirelessProvider;
    private boolean cls_Continue = true;
    private final String cls_InterfaceName;
    private final String cls_DesiredSsid;
    private final SsidListener cls_SsidListener;
    private final Thread cls_Thread;
    private final int cls_BackoffRate;
    private int cls_PollingInterval;
    private final long cls_TimeoutTimestamp;
    private final long cls_TimeoutInterval;

    public LeopardSsidMonitor(AirportReader airportReader, String string, String string2, SsidListener ssidListener, int n, int n2, long l) {
        this.cls_WirelessProvider = airportReader;
        this.cls_InterfaceName = string;
        this.cls_DesiredSsid = string2;
        this.cls_SsidListener = ssidListener;
        this.cls_PollingInterval = n;
        this.cls_BackoffRate = n2;
        this.cls_TimeoutInterval = l;
        this.cls_TimeoutTimestamp = l > 0L ? System.currentTimeMillis() + l : Long.MAX_VALUE;
        this.cls_Thread = Util.runThread(this.getClass().getSimpleName(), this);
    }

    public void stop(boolean bl) {
        this.cls_Continue = false;
        this.cls_Thread.interrupt();
        if (bl) {
            try {
                this.cls_Thread.join();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public boolean isClosed() {
        return !this.cls_Thread.isAlive();
    }

    public void run() {
        boolean bl = false;
        while (this.cls_Continue && System.currentTimeMillis() < this.cls_TimeoutTimestamp) {
            block9: {
                try {
                    WirelessAssociation wirelessAssociation = this.cls_WirelessProvider.getCurrentAssociation(this.cls_InterfaceName);
                    if (wirelessAssociation != null && wirelessAssociation.isEnabled() && wirelessAssociation.isAssociated()) {
                        log.debug((Object)("Current ssid is " + wirelessAssociation.getSsid() + ", waiting for " + this.cls_DesiredSsid));
                        if (this.cls_DesiredSsid.equals(wirelessAssociation.getSsid()) && !bl && this.cls_Continue) {
                            this.cls_SsidListener.associated(wirelessAssociation.getSsid());
                            bl = true;
                            this.cls_Continue = false;
                        }
                    }
                }
                catch (Exception exception) {
                    log.error((Object)"ERROR", (Throwable)exception);
                }
                long l = this.cls_TimeoutInterval;
                if (l == 0L) {
                    l = 1L;
                }
                this.cls_SsidListener.associationPending(100 - (int)((this.cls_TimeoutTimestamp - System.currentTimeMillis()) * 100L / l));
                if (!this.cls_Continue) continue;
                try {
                    Thread.sleep(this.cls_PollingInterval);
                }
                catch (Exception exception) {
                    if (!this.cls_Continue) break block9;
                    log.debug((Object)"Thread failed to sleep.", (Throwable)exception);
                }
            }
            this.cls_PollingInterval += this.cls_BackoffRate;
        }
        if (this.cls_Continue) {
            log.info((Object)"Association timed out.");
            this.associationTimedout();
        }
        log.debug((Object)(this.getClass().getSimpleName() + " thread is exiting."));
    }

    public void associated(String string) {
        this.cls_SsidListener.associated(string);
    }

    public void associationTimedout() {
        this.cls_SsidListener.associationTimedout();
    }
}

