/*
 * Decompiled with CFR 0.152.
 */
package com.cloudpath.common.os.mac.leopard.network.airport;

import com.cloudpath.common.command.CommandHandler;
import com.cloudpath.common.os.mac.common.plist.PlistUtil;
import com.cloudpath.common.os.mac.common.plist.pojo.Dict;
import com.cloudpath.common.os.mac.common.plist.pojo.Pair;
import com.cloudpath.common.os.mac.common.plist.pojo.PairValue;
import com.cloudpath.common.os.mac.common.plist.pojo.Plist;
import com.cloudpath.common.os.mac.common.plist.pojo.ValueArray;
import com.cloudpath.common.os.mac.common.plist.pojo.ValueInteger;
import com.cloudpath.common.os.mac.leopard.cmd.Maccmd;
import com.cloudpath.common.os.mac.leopard.network.airport.LeopardAirportNetwork;
import com.cloudpath.common.util.FileHandler;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Vector;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LeopardAirportPreferencePlist {
    private static final Logger log = Logger.getLogger(LeopardAirportPreferencePlist.class);
    public static final String DIRECTORY = "/Library/Preferences/SystemConfiguration";
    public static final String FILE = "/Library/Preferences/SystemConfiguration/com.apple.airport.preferences.plist";
    public static final String KNOWN_NETWORKS = "KnownNetworks";
    public static final String VERSION = "Version";
    public static final String RECENT_NETWORKS = "RecentNetworks";
    private final FileHandler cls_FileHandler;
    private final CommandHandler cls_CommandHandler;
    private final Maccmd cls_Maccmd;
    private final File cls_File;
    private final Vector<LeopardAirportNetwork> cls_KnownNetworks = new Vector();
    private long cls_Version = 6L;
    private final HashMap<String, Vector<LeopardAirportNetwork>> cls_RecentNetworks = new HashMap();
    private Vector<Object> cls_OtherPairs = new Vector();
    private boolean cls_KnownNetworksExisted = true;

    public LeopardAirportPreferencePlist(FileHandler fileHandler, CommandHandler commandHandler, Maccmd maccmd) {
        this.cls_FileHandler = fileHandler;
        this.cls_CommandHandler = commandHandler;
        this.cls_Maccmd = maccmd;
        this.cls_File = new File("/", FILE);
    }

    public File getFile() {
        return this.cls_File;
    }

    public void refresh() {
        log.info((Object)"Will refresh current plist.");
        this.parse(this.getCurrentPlist());
    }

    public boolean write() throws IOException {
        boolean bl;
        log.info((Object)"Will write eap bindings plist.");
        Plist plist = this.generatePlist();
        String string = plist.getXml();
        log.debug((Object)("Will write file " + this.cls_File + " to handler."));
        if (this.cls_Maccmd == null) {
            this.cls_FileHandler.writeFile(this.cls_File, string);
            bl = true;
        } else {
            File file = File.createTempFile("xpc_", ".tmp");
            this.cls_FileHandler.writeFile(file, string);
            log.debug((Object)"Will copy airport preferences file to system.");
            bl = this.cls_Maccmd.copyFileAsAdmin(file, Maccmd.Destination.airport_preferences);
            file.delete();
        }
        if (!bl) {
            log.warn((Object)"Failed to write the airport preferences file.");
        }
        return bl;
    }

    public int getKnownNetworkCount() {
        return this.cls_KnownNetworks.size();
    }

    public LeopardAirportNetwork getKnownNetwork(int n) {
        return this.cls_KnownNetworks.get(n);
    }

    public LeopardAirportNetwork getKnownNetworkBySsid(String string) {
        for (int i = 0; i < this.cls_KnownNetworks.size(); ++i) {
            if (!string.equals(this.cls_KnownNetworks.get(i).getSsid())) continue;
            return this.cls_KnownNetworks.get(i);
        }
        return null;
    }

    public void removeKnownNetwork(String string) {
        for (int i = 0; i < this.cls_KnownNetworks.size(); ++i) {
            if (!string.equals(this.cls_KnownNetworks.get(i).getSsid())) continue;
            this.cls_KnownNetworks.remove(i);
        }
    }

    public void setKnownNetwork(LeopardAirportNetwork leopardAirportNetwork) {
        this.removeKnownNetwork(leopardAirportNetwork.getSsid());
        this.cls_KnownNetworks.insertElementAt(leopardAirportNetwork, 0);
    }

    public int getRecentNetworkCount(String string) {
        Vector<LeopardAirportNetwork> vector = this.getRecentNetworksByInterface(string);
        return vector != null ? vector.size() : 0;
    }

    public LeopardAirportNetwork getRecentNetworkBySsid(String string, String string2) {
        Vector<LeopardAirportNetwork> vector = this.getRecentNetworksByInterface(string);
        if (vector != null) {
            for (int i = 0; i < vector.size(); ++i) {
                if (!string2.equals(vector.get(i).getSsid())) continue;
                return vector.get(i);
            }
        }
        return null;
    }

    public void setRecentNetwork(String string, LeopardAirportNetwork leopardAirportNetwork) {
        this.removeRecentNetwork(string, leopardAirportNetwork.getSsid());
        Vector<LeopardAirportNetwork> vector = this.getRecentNetworksByInterface(string);
        if (vector == null) {
            vector = new Vector();
            this.cls_RecentNetworks.put(string, vector);
        }
        vector.insertElementAt(leopardAirportNetwork, 0);
    }

    public void removeRecentNetwork(String string, String string2) {
        Vector<LeopardAirportNetwork> vector = this.getRecentNetworksByInterface(string);
        for (int i = 0; i < vector.size(); ++i) {
            if (!string2.equals(vector.get(i).getSsid())) continue;
            vector.remove(i);
        }
    }

    public void setVersion(long l) {
        this.cls_Version = l;
    }

    public long getVersion() {
        return this.cls_Version;
    }

    private Vector<LeopardAirportNetwork> getRecentNetworksByInterface(String string) {
        Vector<LeopardAirportNetwork> vector = this.cls_RecentNetworks.get(string);
        if (vector == null) {
            vector = new Vector();
            this.cls_RecentNetworks.put(string, vector);
        }
        return vector;
    }

    public Plist getCurrentPlist() {
        return PlistUtil.getCurrentPlist(this.cls_FileHandler, this.cls_CommandHandler, this.cls_File, new Plist());
    }

    public synchronized void parse(Plist plist) {
        Object object;
        String string;
        Pair pair;
        int n;
        this.cls_KnownNetworks.clear();
        this.cls_RecentNetworks.clear();
        this.cls_OtherPairs.clear();
        if (plist.getDict() == null) {
            plist.setDict(new Dict());
        }
        boolean bl = false;
        this.cls_KnownNetworksExisted = false;
        for (int i = 0; !bl && i < plist.getDict().getPairCount(); ++i) {
            String string2 = plist.getDict().getPair(i).getKey();
            if (KNOWN_NETWORKS.equals(string2)) {
                this.cls_OtherPairs.add(this.cls_KnownNetworks);
                this.cls_KnownNetworksExisted = true;
                continue;
            }
            if (VERSION.equals(string2)) {
                bl = true;
                continue;
            }
            this.cls_OtherPairs.add(plist.getDict().getPair(i));
        }
        Dict dict = plist.getDict().getDict(KNOWN_NETWORKS, new Dict());
        for (n = 0; n < dict.getPairCount(); ++n) {
            pair = dict.getPair(n);
            if (pair == null || !(pair.getValue() instanceof Dict)) continue;
            string = pair.getKey();
            object = new LeopardAirportNetwork();
            ((LeopardAirportNetwork)object).parse(string, (Dict)pair.getValue());
            this.cls_KnownNetworks.add((LeopardAirportNetwork)object);
        }
        this.setVersion(PlistUtil.getIntegerValue(plist.getDict(), VERSION, this.getVersion()));
        for (n = 2; n < plist.getDict().getPairCount(); ++n) {
            pair = plist.getDict().getPair(n);
            string = pair.getKey();
            object = plist.getDict().getDict(string, new Dict());
            Vector<LeopardAirportNetwork> vector = new Vector<LeopardAirportNetwork>();
            this.cls_RecentNetworks.put(string, vector);
            ValueArray valueArray = ((Dict)object).getArray(RECENT_NETWORKS, new ValueArray());
            for (int i = 0; i < valueArray.getValueCount(); ++i) {
                PairValue pairValue = valueArray.getValue(i);
                if (pairValue == null || !(pairValue instanceof Dict)) continue;
                LeopardAirportNetwork leopardAirportNetwork = new LeopardAirportNetwork();
                leopardAirportNetwork.parse("", (Dict)pairValue);
                vector.add(leopardAirportNetwork);
            }
        }
    }

    public Plist generatePlist() {
        Dict dict;
        int n;
        Dict dict2 = new Dict();
        if (!this.cls_KnownNetworksExisted && this.cls_KnownNetworks.size() > 0) {
            Dict dict3 = new Dict();
            dict2.addPair(KNOWN_NETWORKS, dict3);
            for (n = 0; n < this.cls_KnownNetworks.size(); ++n) {
                Dict dict4 = this.cls_KnownNetworks.get(n).generateKnownNetwork();
                dict3.addPair(this.cls_KnownNetworks.get(n).getUniqueNetworkId(), dict4);
            }
        }
        for (int i = 0; i < this.cls_OtherPairs.size(); ++i) {
            if (this.cls_OtherPairs.get(i) instanceof Pair) {
                dict2.addPair((Pair)this.cls_OtherPairs.get(i));
                continue;
            }
            if (!this.cls_KnownNetworksExisted) continue;
            Dict dict5 = new Dict();
            dict2.addPair(KNOWN_NETWORKS, dict5);
            for (int j = 0; j < this.cls_KnownNetworks.size(); ++j) {
                dict = this.cls_KnownNetworks.get(j).generateKnownNetwork();
                dict5.addPair(this.cls_KnownNetworks.get(j).getUniqueNetworkId(), dict);
            }
        }
        dict2.addPair(VERSION, new ValueInteger(this.getVersion()));
        Object[] objectArray = this.cls_RecentNetworks.keySet().toArray();
        for (n = 0; n < objectArray.length; ++n) {
            Vector<LeopardAirportNetwork> vector;
            if (objectArray[n] == null || !(objectArray[n] instanceof String) || (vector = this.getRecentNetworksByInterface((String)objectArray[n])).size() <= 0) continue;
            dict = new Dict();
            dict2.addPair((String)objectArray[n], dict);
            ValueArray valueArray = new ValueArray();
            dict.addPair(RECENT_NETWORKS, valueArray);
            for (int i = 0; i < vector.size(); ++i) {
                Dict dict6 = vector.get(i).generateRecentNetwork();
                valueArray.addValue(dict6);
            }
        }
        Plist plist = new Plist();
        plist.setDict(dict2);
        return plist;
    }
}

