/*
 * Decompiled with CFR 0.152.
 */
package com.cloudpath.common.os.mac.leopard.network;

import com.cloudpath.common.command.CommandHandler;
import com.cloudpath.common.os.mac.common.network.airport.SsidManager;
import com.cloudpath.common.os.mac.common.plist.PlistUtil;
import com.cloudpath.common.os.mac.leopard.cmd.Maccmd;
import com.cloudpath.common.os.mac.leopard.network.airport.LeopardAirportNetwork;
import com.cloudpath.common.os.mac.leopard.network.airport.LeopardAirportPreferencePlist;
import com.cloudpath.common.os.mac.leopard.network.airport.LeopardSsid;
import com.cloudpath.common.os.mac.leopard.network.eap.LeopardEapBinding;
import com.cloudpath.common.os.mac.leopard.network.eap.LeopardEapBindingPlist;
import com.cloudpath.common.os.mac.leopard.network.eap.LeopardEapProfile;
import com.cloudpath.common.os.mac.leopard.network.eap.LeopardEapProfilePlist;
import com.cloudpath.common.os.mac.leopard.network.systemconfig.LeopardLocationAirport;
import com.cloudpath.common.os.mac.leopard.network.systemconfig.LeopardPreferencePlist;
import com.cloudpath.common.util.FileHandler;
import java.io.IOException;
import java.util.HashMap;
import java.util.Vector;
import org.apache.log4j.Logger;

public class LeopardSsidManager
implements SsidManager {
    private static final Logger log = Logger.getLogger(LeopardSsidManager.class);
    private static final String PSK_SERVICE_NAME = "AirPort Network";
    private static final String PSK_KIND = "AirPort network password";
    private final HashMap<String, LeopardSsid> cls_Ssids = new HashMap();
    private final Vector<LeopardSsid> cls_DeletedSsids = new Vector();
    private final Vector<LeopardSsid> cls_AddedSsids = new Vector();
    private final Maccmd cls_Maccmd;
    private final LeopardPreferencePlist cls_Preferences;
    private final LeopardAirportPreferencePlist cls_AirportPreferences;
    private final LeopardEapBindingPlist cls_EapBindings;
    private final LeopardEapProfilePlist cls_EapProfiles;

    public LeopardSsidManager(FileHandler fileHandler, CommandHandler commandHandler, Maccmd maccmd, LeopardPreferencePlist leopardPreferencePlist, LeopardEapBindingPlist leopardEapBindingPlist) {
        this.cls_Maccmd = maccmd;
        this.cls_Preferences = leopardPreferencePlist;
        this.cls_AirportPreferences = new LeopardAirportPreferencePlist(fileHandler, commandHandler, maccmd);
        this.cls_EapBindings = leopardEapBindingPlist;
        this.cls_EapProfiles = new LeopardEapProfilePlist(fileHandler, commandHandler);
    }

    public void refresh(String string, String string2) {
        this.cls_Preferences.refresh();
        this.cls_AirportPreferences.refresh();
        this.cls_EapProfiles.refresh();
        this.cls_EapBindings.refresh();
        this.cls_Ssids.clear();
        this.cls_DeletedSsids.clear();
        this.cls_AddedSsids.clear();
        for (int i = 0; i < this.cls_AirportPreferences.getKnownNetworkCount(); ++i) {
            LeopardAirportNetwork leopardAirportNetwork = this.cls_AirportPreferences.getKnownNetwork(i);
            if (leopardAirportNetwork == null) continue;
            LeopardSsid leopardSsid = new LeopardSsid();
            leopardSsid.setUniqueNetworkId(leopardAirportNetwork.getUniqueNetworkId());
            leopardSsid.setSsid(leopardAirportNetwork.getSsid());
            leopardSsid.setRememberedChannels(leopardAirportNetwork.getRememberedChannels());
            leopardSsid.setScanDirected(leopardAirportNetwork.getScanDirected());
            leopardSsid.setSecurityType(leopardAirportNetwork.getSecurityType());
            leopardSsid.setTimestamp(leopardAirportNetwork.getTimestamp());
            leopardSsid.setPskUniquePasswordId(leopardAirportNetwork.getUniquePasswordId());
            LeopardLocationAirport leopardLocationAirport = this.cls_Preferences.getCurrentLocation().getInterface(string).getAirport();
            int n = leopardLocationAirport.getPreferredNetworkIndexBySsid(leopardAirportNetwork.getSsid());
            if (n >= 0) {
                LeopardEapProfile leopardEapProfile;
                LeopardEapBinding leopardEapBinding;
                leopardSsid.setIndex(n);
                if (leopardSsid.getSecurityType().Is8021X && (leopardEapBinding = this.cls_EapBindings.getBindingBySsid(string2, leopardAirportNetwork.getSsid())) != null && (leopardEapProfile = this.cls_EapProfiles.getProfileByUniqueIdentifier(leopardEapBinding.getUniqueIdentifier())) != null) {
                    leopardSsid.setDot1xProfile(leopardEapProfile.getUserDefinedName());
                    leopardSsid.setDot1xUniqueProfileId(leopardEapProfile.getUniqueIdentifier());
                }
                this.cls_Ssids.put(leopardAirportNetwork.getSsid(), leopardSsid);
                continue;
            }
            log.debug((Object)"Network is known but not preferred.");
        }
    }

    public int getSsidCount() {
        return this.cls_Ssids.size();
    }

    public LeopardSsid getSsid(String string) {
        LeopardSsid leopardSsid = this.cls_Ssids.get(string);
        if (leopardSsid != null) {
            leopardSsid = (LeopardSsid)leopardSsid.clone();
        }
        return leopardSsid;
    }

    public void setSsid(LeopardSsid leopardSsid) {
        if (this.cls_Ssids.containsKey(leopardSsid.getSsid())) {
            this.removeSsid(leopardSsid.getSsid());
        }
        this.cls_Ssids.put(leopardSsid.getSsid(), leopardSsid);
        this.cls_AddedSsids.add(leopardSsid);
    }

    public void removeSsid(String string) {
        LeopardSsid leopardSsid = this.cls_Ssids.remove(string);
        if (leopardSsid != null) {
            this.cls_DeletedSsids.add((LeopardSsid)leopardSsid.clone());
        }
        for (int i = 0; i < this.cls_AddedSsids.size(); ++i) {
            if (!string.equals(this.cls_AddedSsids.get(i).getSsid())) continue;
            this.cls_AddedSsids.remove(i);
        }
    }

    public void commit(String string, String string2) throws IOException {
        int n;
        log.info((Object)"Will commit wireless configuration...");
        this.cls_EapProfiles.refresh();
        for (n = 0; n < this.cls_DeletedSsids.size(); ++n) {
            this.doDeleteSsid(this.cls_DeletedSsids.get(n), string, string2);
        }
        for (n = 0; n < this.cls_AddedSsids.size(); ++n) {
            this.doAddSsid(this.cls_AddedSsids.get(n), string, string2);
        }
        this.cls_AirportPreferences.write();
        this.cls_EapBindings.write();
        this.cls_Preferences.write();
    }

    private void doDeleteSsid(LeopardSsid leopardSsid, String string, String string2) {
        this.cls_Preferences.getCurrentLocation().getInterface(string).getAirport().removePreferredNetworkBySsid(leopardSsid.getSsid());
        this.cls_Preferences.getCurrentLocation().getInterface(string).getAirport().removePreferredNetworkByNetworkId(leopardSsid.getUniqueNetworkId());
        if (leopardSsid.getSecurityType().IsPsk) {
            this.cls_Maccmd.deleteGenericPassword(Maccmd.Keychain.login, leopardSsid.getSsid(), PSK_SERVICE_NAME);
        }
        this.cls_EapBindings.removeEapBinding(string2, leopardSsid.getSsid());
        this.cls_AirportPreferences.removeKnownNetwork(leopardSsid.getSsid());
        this.cls_AirportPreferences.removeRecentNetwork(string, leopardSsid.getSsid());
    }

    private void doAddSsid(LeopardSsid leopardSsid, String string, String string2) throws IOException {
        Object object;
        log.info((Object)("Adding ssid " + leopardSsid.getSsid() + " to interface " + string + " (" + string2 + ")"));
        if (leopardSsid.getUniqueNetworkId() == null || leopardSsid.getUniqueNetworkId().length() == 0) {
            log.debug((Object)" - Ssid does not contain a network id.  Will generate guid.");
            leopardSsid.setUniqueNetworkId(PlistUtil.generateGuid());
        }
        log.debug((Object)(" - Network id is " + leopardSsid.getUniqueNetworkId()));
        if (leopardSsid.getSecurityType().IsPsk) {
            int n;
            log.debug((Object)" - Ssid is PSK.  Will cache the psk.");
            object = leopardSsid.getSsid() + " Wireless Network";
            String string3 = "This password is for the " + leopardSsid.getSsid() + " wireless network.  This network utilizes this password as a pre-shared key for encryption.";
            if (leopardSsid.getPskUniquePasswordId().length() == 0) {
                leopardSsid.setPskUniquePasswordId(PlistUtil.generateGuid());
            }
            if ((n = this.cls_Maccmd.setGenericPassword(Maccmd.Keychain.login, (String)object, leopardSsid.getSsid(), PSK_SERVICE_NAME, PSK_KIND, string3, leopardSsid.getPsk())) != 0) {
                log.error((Object)(" - Failed to add the generic psk password for the Leopard SSID " + leopardSsid.getSsid() + ".  Will continue without cached password.  Error code was " + n + "."));
            }
        } else if (leopardSsid.getSecurityType().Is8021X) {
            // empty if block
        }
        log.debug((Object)" - Will check for consistency.");
        if (leopardSsid.getSecurityType().Is8021X) {
            log.debug((Object)" - Checking eap profile of 802.1X ssid...");
            object = null;
            if (leopardSsid.getDot1xProfile().length() > 0) {
                log.debug((Object)(" - We have the profile name " + leopardSsid.getDot1xProfile()));
                object = this.cls_EapProfiles.getProfileByName(leopardSsid.getDot1xProfile());
                if (object != null) {
                    leopardSsid.setDot1xUniqueProfileId(((LeopardEapProfile)object).getUniqueIdentifier());
                }
            } else if (leopardSsid.getDot1xUniqueProfileId().length() > 0) {
                log.debug((Object)(" - We have the link id " + leopardSsid.getDot1xUniqueProfileId()));
                object = this.cls_EapProfiles.getProfileByUniqueIdentifier(leopardSsid.getDot1xUniqueProfileId());
                if (object != null) {
                    leopardSsid.setDot1xProfile(((LeopardEapProfile)object).getUserDefinedName());
                }
            }
            if (object == null) {
                log.warn((Object)" - We were unable to find a profile for the ssid.");
            }
        }
        log.debug((Object)" - Will translate into network object.");
        object = new LeopardAirportNetwork();
        ((LeopardAirportNetwork)object).setRememberedChannels(leopardSsid.getRememberedChannels());
        ((LeopardAirportNetwork)object).setScanDirected(leopardSsid.getScanDirected());
        ((LeopardAirportNetwork)object).setSecurityType(leopardSsid.getSecurityType());
        ((LeopardAirportNetwork)object).setUniqueNetworkId(leopardSsid.getUniqueNetworkId());
        ((LeopardAirportNetwork)object).setSsid(leopardSsid.getSsid());
        ((LeopardAirportNetwork)object).setTimestamp(leopardSsid.getTimestamp());
        ((LeopardAirportNetwork)object).setUniquePasswordId(leopardSsid.getPskUniquePasswordId());
        log.debug((Object)(" - Will add the known network " + ((LeopardAirportNetwork)object).getSsid() + "."));
        this.cls_AirportPreferences.setKnownNetwork((LeopardAirportNetwork)object);
        log.debug((Object)" - Will add the recent network...");
        this.cls_AirportPreferences.setRecentNetwork(string, (LeopardAirportNetwork)object);
        if (leopardSsid.getSecurityType().Is8021X) {
            log.debug((Object)(" - Will add the eap binding for " + leopardSsid.getSsid() + " to " + leopardSsid.getDot1xProfile() + " (" + leopardSsid.getDot1xUniqueProfileId() + ")."));
            this.cls_EapBindings.setEapBinding(string2, leopardSsid.getSsid(), leopardSsid.getDot1xUniqueProfileId());
        }
        log.debug((Object)(" - Will add the preferred network " + ((LeopardAirportNetwork)object).getSsid() + "."));
        this.cls_Preferences.getCurrentLocation().getInterface(string).getAirport().setPreferredNetwork(leopardSsid.getIndex(), (LeopardAirportNetwork)object);
        log.debug((Object)("Done adding ssid " + leopardSsid.getSsid()));
    }

    public boolean isKeychainPskCorrect(String string, String string2) {
        return this.cls_Maccmd.doesGenericPasswordMatch(Maccmd.Keychain.login, string, PSK_SERVICE_NAME, string2);
    }
}

