/*
 * Decompiled with CFR 0.152.
 */
package com.cloudpath.common.os.mac.leopard.eapol;

import com.cloudpath.common.command.CommandHandler;
import com.cloudpath.common.command.CommandResponse;
import com.cloudpath.common.os.mac.common.util.MacExeWrapper;
import com.cloudpath.common.os.mac.leopard.cmd.Maccmd;
import com.cloudpath.common.os.mac.leopard.eapol.LeopardEapState;
import com.cloudpath.common.os.mac.leopard.network.eap.LeopardEap;
import com.cloudpath.common.util.FileHandler;
import com.cloudpath.common.util.Util;
import java.io.File;
import java.io.IOException;
import org.apache.log4j.Logger;

public class MacEapCmd {
    private static final Logger log = Logger.getLogger(MacEapCmd.class);
    private final FileHandler cls_FileHandler;
    private final CommandHandler cls_CommandHandler;
    private final Maccmd cls_Maccmd;
    private final File cls_ExeFile;

    public MacEapCmd(FileHandler fileHandler, CommandHandler commandHandler, Maccmd maccmd) {
        this.cls_FileHandler = fileHandler;
        this.cls_CommandHandler = commandHandler;
        this.cls_Maccmd = maccmd;
        this.cls_ExeFile = maccmd != null ? new File(this.cls_Maccmd.getResourcesDirectory(), "NetworkAssistant") : new File("NetworkAssistant");
    }

    public LeopardEapState getEapState(String string) {
        String[] stringArray = new String[]{"state", string};
        try {
            CommandResponse commandResponse = MacExeWrapper.runExeDirect(this.cls_CommandHandler, this.cls_ExeFile, stringArray, null, null);
            commandResponse.waitFor();
            if (this.hasError(commandResponse)) {
                return this.getDefaultState();
            }
            LeopardEapState leopardEapState = new LeopardEapState();
            leopardEapState.parseFile(commandResponse.getOutput());
            return leopardEapState;
        }
        catch (IOException iOException) {
            log.error((Object)"Error", (Throwable)iOException);
            return this.getDefaultState();
        }
    }

    private LeopardEapState getDefaultState() {
        LeopardEapState leopardEapState = new LeopardEapState();
        return leopardEapState;
    }

    public void start8021x(String string, String string2, LeopardEap leopardEap) {
        this.start8021x(true, string, string2, leopardEap);
    }

    public void start8021x(boolean bl, String string, String string2, LeopardEap leopardEap) {
        File file = null;
        String string3 = leopardEap.generate(bl, string2, false, false).getXml("");
        try {
            file = File.createTempFile("XPC_START_", ".tmp");
            this.cls_FileHandler.writeFile(file, string3);
        }
        catch (Exception exception) {
            log.error((Object)"Unable to create temp file.", (Throwable)exception);
        }
        if (file != null) {
            String[] stringArray = new String[]{"start", string, file.getAbsolutePath()};
            try {
                CommandResponse commandResponse = MacExeWrapper.runExeDirect(this.cls_CommandHandler, this.cls_ExeFile, stringArray, null, null);
                commandResponse.waitFor();
            }
            catch (IOException iOException) {
                log.error((Object)"Error updating 802.1X state machine.", (Throwable)iOException);
            }
            file.deleteOnExit();
        }
    }

    public void retry8021x(String string) {
        log.debug((Object)"Will retry 802.1X authentication...");
        String[] stringArray = new String[]{"retry", string};
        try {
            CommandResponse commandResponse = MacExeWrapper.runExeDirect(this.cls_CommandHandler, this.cls_ExeFile, stringArray, null, null);
            commandResponse.waitFor();
        }
        catch (IOException iOException) {
            log.error((Object)"Error retrying 802.1X state machine.", (Throwable)iOException);
        }
    }

    public void stop8021x(String string) {
        Object object;
        log.debug((Object)"Will stop 802.1X authentication...");
        String[] stringArray = new String[]{"stop", string};
        try {
            object = MacExeWrapper.runExeDirect(this.cls_CommandHandler, this.cls_ExeFile, stringArray, null, null);
            ((CommandResponse)object).waitFor();
        }
        catch (IOException iOException) {
            log.error((Object)"Error stopping 802.1X state machine.", (Throwable)iOException);
        }
        object = this.getEapState(string);
        if (object != null && LeopardEapState.EapolState.Running.equals((Object)((LeopardEapState)object).getEapolState())) {
            this.cls_Maccmd.stopSupplicant(string);
        }
    }

    private boolean hasError(CommandResponse commandResponse) {
        String[] stringArray = commandResponse.getError();
        if (stringArray.length > 1 || stringArray.length == 1 && stringArray[0] != null && stringArray[0].length() > 0) {
            return true;
        }
        String string = Util.join(commandResponse.getOutput());
        return string != null && string.startsWith("ERROR:");
    }
}

