/*
 * Decompiled with CFR 0.152.
 */
package com.cloudpath.common.os.mac.leopard.eapol;

import com.cloudpath.common.os.mac.common.plist.PlistConstants;
import com.cloudpath.common.os.mac.common.plist.pojo.Dict;
import com.cloudpath.common.os.mac.common.plist.pojo.PairValue;
import com.cloudpath.common.os.mac.common.plist.pojo.Plist;
import com.cloudpath.common.os.mac.common.plist.pojo.ValueArray;
import com.cloudpath.common.parse.InvalidXmlException;
import com.cloudpath.common.parse.ParseManager;
import com.cloudpath.common.util.Util;
import java.util.ArrayList;
import org.apache.log4j.Logger;

public class LeopardEapState {
    private static final Logger log = Logger.getLogger(LeopardEapState.class);
    private static final String EAPOL_CONTROL_COPY_STATE_AND_STATUS = "EAPOLControlCopyStateAndStatus";
    private static final String STATUS_DICT = "Status dict:";
    public static final String CLIENT_STATUS = "ClientStatus";
    public static final String EAP_TYPE_NAME = "EAPTypeName";
    public static final String SUPPLICANT_STATE = "SupplicantState";
    public static final String REQUIRED_PROPERTIES = "RequiredProperties";
    private static final String WAITING_USER_NAME = "UserName";
    private static final String WAITING_PASSWORD = "UserPassword";
    public static final int SUPP_STATE_DISCONNECTED = 0;
    public static final int SUPP_STATE_CONNECTING = 1;
    public static final int SUPP_STATE_ACQUIRED = 2;
    public static final int SUPP_STATE_AUTHENTICATING = 3;
    public static final int SUPP_STATE_AUTHENTICATED = 4;
    public static final int SUPP_STATE_HELD = 5;
    public static final int SUPP_STATE_LOGOFF = 6;
    public static final int SUPP_STATE_INACTIVE = 7;
    public static final int CLIENT_STATUS_OK = 0;
    public static final int CLIENT_STATUS_FAILED = 1;
    public static final int CLIENT_STATUS_ALLOCATION_FAILED = 2;
    public static final int CLIENT_STATUS_USER_INPUT_REQUIRED = 3;
    public static final int CLIENT_STATUS_CONFIGURATION_INVALID = 4;
    public static final int CLIENT_STATUS_PROTOCOL_NOT_SUPPORTED = 5;
    public static final int CLIENT_STATUS_SERVER_CERTIFICATUS_NOT_TRUSTED = 6;
    public static final int CLIENT_STATUS_INNER_PROTOCOL_NOT_SUPPORTED = 7;
    public static final int CLIENT_STATUS_INTERNAL_ERROR = 8;
    public static final int CLIENT_STATUS_USER_CANCELLED_AUTHENTICATION = 9;
    public static final int CLIENT_STATUS_UNKNOWN_ROOT_CERTIFICATE = 10;
    public static final int CLIENT_STATUS_NO_ROOT_CERTIFICATE = 11;
    public static final int CLIENT_STATUS_CERTIFICATE_EXPIRED = 12;
    public static final int CLIENT_STATUS_CERTIFICATE_NOT_YET_VALID = 13;
    public static final int CLIENT_STATUS_CERTIFICATE_REQUIRES_CONFIRMATION = 14;
    public static final int CLIENT_STATUS_USER_INPUT_NOT_POSSIBLE = 15;
    public static final int CLIENT_STATUS_CONFIGURATION_INCOMPLETE = 3;
    public static final int CLIENT_STATUS_ERROR_STARTING = 1000;
    private EapolState cls_EapolState = EapolState.Idle;
    private String cls_EapTypeName = "";
    private long cls_ClientStatus = 0L;
    private long cls_SupplicantStatus = 0L;
    private String cls_RequiredProperties = "";

    public EapolState getEapolState() {
        return this.cls_EapolState;
    }

    public long getClientStatus() {
        return this.cls_ClientStatus;
    }

    public long getSupplicantStatus() {
        return this.cls_SupplicantStatus;
    }

    public String getEapTypeName() {
        return this.cls_EapTypeName;
    }

    public String getRequiredProperties() {
        return this.cls_RequiredProperties;
    }

    public SummaryState getSummaryState() {
        if (this.getEapolState().equals((Object)EapolState.Idle) || this.getEapolState().equals((Object)EapolState.Stopping)) {
            return SummaryState.DISCONNECTED;
        }
        if (this.getEapolState().equals((Object)EapolState.Running) && this.getSupplicantStatus() == 4L) {
            return SummaryState.AUTHENTICATED;
        }
        if (this.getClientStatus() == 3L) {
            if (this.getRequiredProperties().contains(WAITING_USER_NAME) || this.getRequiredProperties().contains(WAITING_PASSWORD)) {
                return SummaryState.WAITING_INPUT;
            }
            return SummaryState.WAITING_CERT;
        }
        if (this.getSupplicantStatus() == 5L || this.getSupplicantStatus() == 6L || this.getSupplicantStatus() == 7L) {
            return SummaryState.DISCONNECTED;
        }
        return SummaryState.PROCESSING;
    }

    public void parseFile(String[] stringArray) {
        stringArray = this.expandArray(stringArray);
        int n = -1;
        for (int i = 0; n < 0 && i < stringArray.length; ++i) {
            log.debug((Object)("[CPN~] " + i + "--> " + stringArray[i]));
            if (stringArray[i].contains(EAPOL_CONTROL_COPY_STATE_AND_STATUS)) {
                log.debug((Object)("State summary is at line " + i));
                if (stringArray[i].contains(EapolState.Idle.name())) {
                    this.cls_EapolState = EapolState.Idle;
                    continue;
                }
                if (stringArray[i].contains(EapolState.Stopping.name())) {
                    this.cls_EapolState = EapolState.Stopping;
                    continue;
                }
                if (stringArray[i].contains(EapolState.Running.name())) {
                    this.cls_EapolState = EapolState.Running;
                    continue;
                }
                if (stringArray[i].contains(EapolState.Starting.name())) {
                    this.cls_EapolState = EapolState.Starting;
                    continue;
                }
                this.cls_EapolState = EapolState.Idle;
                continue;
            }
            if (!stringArray[i].contains(STATUS_DICT)) continue;
            log.debug((Object)("[CPN~] Dict note is at line " + i));
            n = i + 1;
        }
        if (n >= 0 && n < stringArray.length) {
            String[] stringArray2 = new String[stringArray.length - n];
            System.arraycopy(stringArray, n, stringArray2, 0, stringArray2.length);
            ParseManager parseManager = new ParseManager(PlistConstants.PLIST_ELEMENTS);
            try {
                Plist plist = (Plist)parseManager.parse(Util.join(stringArray2));
                this.parse(plist);
            }
            catch (InvalidXmlException invalidXmlException) {
                log.error((Object)"Error occurred parsing xml from eap state.", (Throwable)invalidXmlException);
            }
        }
    }

    private void parse(Plist plist) {
        Dict dict = plist.getDict();
        if (dict == null) {
            dict = new Dict();
        }
        this.cls_ClientStatus = dict.getInteger(CLIENT_STATUS, 0L);
        this.cls_SupplicantStatus = dict.getInteger(SUPPLICANT_STATE, 0L);
        this.cls_EapTypeName = dict.getString(EAP_TYPE_NAME, "");
        this.cls_RequiredProperties = "";
        ValueArray valueArray = dict.getArray(REQUIRED_PROPERTIES, new ValueArray());
        for (int i = 0; i < valueArray.getValueCount(); ++i) {
            PairValue pairValue = valueArray.getValue(i);
            if (this.cls_RequiredProperties.length() > 0) {
                this.cls_RequiredProperties = this.cls_RequiredProperties + ", ";
            }
            this.cls_RequiredProperties = this.cls_RequiredProperties + pairValue.getString();
        }
    }

    private String[] expandArray(String[] stringArray) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].indexOf(10) < 0) {
                arrayList.add(stringArray[i]);
                continue;
            }
            String[] stringArray2 = stringArray[i].split("\n");
            for (int j = 0; j < stringArray2.length; ++j) {
                arrayList.add(stringArray2[j]);
            }
        }
        String[] stringArray3 = new String[arrayList.size()];
        arrayList.toArray(stringArray3);
        return stringArray3;
    }

    public String toString() {
        return "[EapState client: " + this.getClientStatus() + " Supplicant: " + this.getSupplicantStatus() + " Summary: " + (Object)((Object)this.getSummaryState()) + "]";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum SummaryState {
        DISCONNECTED,
        PROCESSING,
        WAITING_INPUT,
        WAITING_CERT,
        AUTHENTICATED;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EapolState {
        Idle,
        Starting,
        Running,
        Stopping;

    }
}

