/*
 * Decompiled with CFR 0.152.
 */
package com.cloudpath.common.os.mac.common.util;

import com.cloudpath.common.command.CommandHandler;
import com.cloudpath.common.command.CommandResponse;
import com.cloudpath.common.command.Mocker;
import com.cloudpath.common.util.FileUtil;
import com.cloudpath.common.util.MissingDependencyException;
import com.cloudpath.common.util.OsConstants;
import com.cloudpath.common.util.Util;
import java.io.File;
import java.io.IOException;
import org.apache.log4j.Logger;

public abstract class MacExeWrapper {
    private static final Logger log = Logger.getLogger(MacExeWrapper.class);
    private static final File DEBUG_FILE = new File("/tmp/xpc-debug");
    protected final CommandHandler cls_CommandHandler;
    private final File cls_DotAppDirectory;
    private final File cls_Maccmd2Directory;
    private final File cls_ExeFilePreMavericks;
    private final File cls_ExeFileMavericks;

    protected MacExeWrapper(CommandHandler commandHandler, String string, String string2) {
        log.info((Object)(Util.getClassName(this) + " is intializing..."));
        this.cls_CommandHandler = commandHandler;
        File file = Util.getTempDirectory();
        File file2 = new File(file, string);
        for (int i = 0; i < 3 && file2.exists(); ++i) {
            Util.delete(file2);
            if (file2.exists()) {
                log.warn((Object)("Failed to delete existing '" + file2.getAbsolutePath() + "'.  Will try alternate location."));
                try {
                    Thread.sleep(10L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                file2 = new File(file, string + "_" + System.currentTimeMillis());
                continue;
            }
            log.warn((Object)("Will use temp directory " + file2.getAbsolutePath() + "."));
        }
        this.cls_DotAppDirectory = new File(file2, string + ".app");
        this.cls_Maccmd2Directory = new File(file2, "Network Wizard.app");
        try {
            FileUtil.unzipFileToFolder(string + ".app", file2, commandHandler);
            log.debug((Object)("Unzipped " + string + " to temp directory."));
        }
        catch (IOException iOException) {
            throw new MissingDependencyException("Unable to find and use " + string + ".", iOException);
        }
        File file3 = new File(this.cls_DotAppDirectory + File.separator + "Contents" + File.separator + "MacOS");
        File file4 = new File(file3, string);
        try {
            File file5 = new File(file3, string2);
            if (file5.exists()) {
                file5.delete();
            }
            if (file4.renameTo(file5)) {
                file4 = file5;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.cls_ExeFilePreMavericks = file4;
        file3 = new File(this.cls_Maccmd2Directory + File.separator + "Contents" + File.separator + "MacOS");
        this.cls_ExeFileMavericks = file4 = new File(file3, "Network Wizard");
    }

    protected CommandResponse runStandardExeFull(String[] stringArray, String string, String string2) throws IOException {
        if (MacExeWrapper.isDebugMode()) {
            log.info((Object)" - Will run non-eleveated.");
        }
        return MacExeWrapper.runExeDirect(this.cls_CommandHandler, this.cls_ExeFilePreMavericks, stringArray, string, string2);
    }

    protected CommandResponse runElevatedExeFull(String[] stringArray, String string, String string2) throws IOException {
        if (OsConstants.isMacMavericksOrGreater()) {
            if (MacExeWrapper.isDebugMode()) {
                log.info((Object)" - System is Mac 10.9 or greater.");
            }
            return MacExeWrapper.runExeDirect(this.cls_CommandHandler, this.cls_ExeFileMavericks, stringArray, string, string2);
        }
        if (MacExeWrapper.isDebugMode()) {
            log.info((Object)" - System is older than Mac 10.9.");
        }
        return this.runStandardExeFull(stringArray, string, string2);
    }

    public static CommandResponse runExeDirect(CommandHandler commandHandler, File file, String[] stringArray, String string, String string2) throws IOException {
        String[] stringArray2 = MacExeWrapper.getCommandLine(stringArray, file, commandHandler instanceof Mocker);
        if (MacExeWrapper.isDebugMode()) {
            log.info((Object)(" - Actual command line is: " + Util.join(stringArray2)));
        }
        if (string != null && string.length() > 0 && string2 != null && string2.length() > 0 && !string.equals(System.getProperty("user.name"))) {
            for (int i = 0; i < stringArray2.length; ++i) {
                stringArray2[i] = stringArray2[i].replace(" ", "\\ ");
            }
            String string3 = "sudo -S " + Util.join(stringArray2, ' ');
            stringArray2 = new String[]{"su", string, "-c", string3};
            CommandResponse commandResponse = commandHandler.executeCommand(stringArray2, string2);
            return commandResponse;
        }
        if (MacExeWrapper.isDebugMode()) {
            log.info((Object)" - Will execute through command handler.");
        }
        CommandResponse commandResponse = commandHandler.executeCommand(stringArray2);
        return commandResponse;
    }

    public static void clearSudo(CommandHandler commandHandler) throws IOException {
        commandHandler.executeCommand(new String[]{"sudo", "-k"}).waitFor();
    }

    public static String[] getCommandLine(String[] stringArray, File file, boolean bl) {
        int n = file != null ? 1 : 0;
        String[] stringArray2 = new String[stringArray.length + n];
        int n2 = 0;
        if (file != null) {
            stringArray2[n2] = file.getAbsolutePath();
            if (bl) {
                stringArray2[n2] = file.getName();
            }
        }
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray2[i + n] = stringArray[i];
        }
        return stringArray2;
    }

    public File getResourcesDirectory() {
        return new File(this.cls_DotAppDirectory + File.separator + "Contents" + File.separator + "Resources");
    }

    private static boolean isDebugMode() {
        return DEBUG_FILE.exists();
    }
}

