/*
 * Decompiled with CFR 0.152.
 */
package com.cloudpath.common.os.mac.common.util;

import com.cloudpath.common.command.CommandHandler;
import com.cloudpath.common.os.mac.common.plist.PlistUtil;
import com.cloudpath.common.os.mac.common.plist.pojo.Dict;
import com.cloudpath.common.os.mac.common.plist.pojo.Plist;
import com.cloudpath.common.os.mac.common.plist.pojo.ValueArray;
import com.cloudpath.common.util.FileHandler;
import java.io.File;
import java.util.ArrayList;
import org.apache.log4j.Logger;

public class DockController {
    private static final Logger log = Logger.getLogger(DockController.class);

    public static File[] getPersistentApps(FileHandler fileHandler, CommandHandler commandHandler) {
        Plist plist = PlistUtil.getCurrentPlist(fileHandler, commandHandler, new File(System.getProperty("user.home"), "/Library/Preferences/com.apple.dock.plist"), null);
        return DockController.getPersistentApps(plist);
    }

    protected static File[] getPersistentApps(Plist plist) {
        Object object;
        log.debug((Object)"Will get persistent app from dock plist.");
        ArrayList<File> arrayList = new ArrayList<File>();
        if (plist != null) {
            object = plist.getDict().getArray("persistent-apps", new ValueArray());
            int n = ((ValueArray)object).getValueCount();
            log.debug((Object)(" - Dock contains " + ((ValueArray)object).getValueCount() + " items."));
            for (int i = 0; i < n; ++i) {
                Dict dict = (Dict)((ValueArray)object).getValue(i);
                Dict dict2 = dict.getDict("tile-data", new Dict());
                Dict dict3 = dict2.getDict("file-data", new Dict());
                String string = dict3.getString("_CFURLString", null);
                if (string == null || string.length() <= 0) continue;
                File file = new File(string);
                log.debug((Object)("  - Loaded " + file.getAbsolutePath()));
                arrayList.add(file);
            }
            log.debug((Object)" - Done looking at dock application.");
        }
        object = new File[arrayList.size()];
        arrayList.toArray((T[])object);
        log.debug((Object)" - Returning Dock applications.");
        return object;
    }
}

