/*
 * Decompiled with CFR 0.152.
 */
package com.cloudpath.common.os.mac.common.provider;

import com.cloudpath.common.command.CommandHandler;
import com.cloudpath.common.command.CommandResponse;
import com.cloudpath.common.os.common.DefaultsProvider;
import com.cloudpath.common.os.common.SoftwareUpdateProvider;
import com.cloudpath.common.os.mac.common.MacUtil;
import com.cloudpath.common.os.mac.common.plist.PlistUtil;
import com.cloudpath.common.os.mac.common.plist.pojo.Dict;
import com.cloudpath.common.os.mac.common.plist.pojo.Plist;
import com.cloudpath.common.os.mac.leopard.cmd.Maccmd;
import com.cloudpath.common.util.FileHandler;
import com.cloudpath.common.util.OsConstants;
import com.cloudpath.common.util.OsInfo;
import com.cloudpath.common.util.Util;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Vector;
import java.util.regex.PatternSyntaxException;
import org.apache.log4j.Logger;

public class MacSoftwareUpdateProvider
implements SoftwareUpdateProvider {
    private static final Logger log = Logger.getLogger(MacSoftwareUpdateProvider.class);
    private static final String SOFTWARE_UPDATE_APP = "/System/Library/CoreServices/Software Update.app";
    private static final long DEFAULT_TIGER_SOFTWARE_UPDATE_INTERVAL = 604800L;
    private static final String KEY_REPEAT_INTERVAL = "repeatInterval";
    private static final String KEY_DATE = "date";
    private static final String DOMAIN = "com.apple.scheduler";
    public static final long INTERVAL_DAILY = 86400L;
    public static final long INTERVAL_WEEKLY = 604800L;
    public static final long INTERVAL_MONTHLY = 2592000L;
    private final DefaultsProvider cls_DefaultsProvider;
    private final CommandHandler cls_CommandHandler;
    private final FileHandler cls_FileHandler;
    private final Vector<String> cls_Cache_PendingUpdates = new Vector();
    private int cls_PendingUpdatesCacheState = -1;
    private final File cls_Plist;
    private final OsInfo cls_OsInfo;

    public MacSoftwareUpdateProvider(CommandHandler commandHandler, FileHandler fileHandler, DefaultsProvider defaultsProvider) {
        this(commandHandler, fileHandler, defaultsProvider, OsConstants.getOsInfo());
    }

    protected MacSoftwareUpdateProvider(CommandHandler commandHandler, FileHandler fileHandler, DefaultsProvider defaultsProvider, OsInfo osInfo) {
        this.cls_CommandHandler = commandHandler;
        this.cls_FileHandler = fileHandler;
        this.cls_DefaultsProvider = defaultsProvider;
        this.cls_OsInfo = osInfo;
        this.cls_Plist = OsConstants.isMacTigerOrBefore() ? MacUtil.getFileFromUserPreferences(DOMAIN) : (OsConstants.isMacLionOrLater() ? new File("/Library/Preferences/com.apple.SoftwareUpdate.plist") : MacUtil.getFileFromUserPreferencesByHost(commandHandler, DOMAIN));
        log.debug((Object)("Software Updates is using plist " + this.cls_Plist));
        if (this.cls_Plist == null || !this.cls_Plist.exists()) {
            log.error((Object)("Plist for Software Updates does not exist.  File: " + this.cls_Plist));
        }
    }

    public final void openSoftwareUpdateGui() {
        String[] stringArray = new String[]{"open", SOFTWARE_UPDATE_APP};
        try {
            CommandResponse commandResponse = this.cls_CommandHandler.executeCommand(stringArray);
            commandResponse.waitFor();
        }
        catch (IOException iOException) {
            log.warn((Object)"An error occurred while opening software updates.", (Throwable)iOException);
        }
    }

    private final void setSoftwareUpdatesLionOrLater(boolean bl, long l) {
        Maccmd maccmd = new Maccmd(this.cls_CommandHandler);
        int n = 0;
        n = (int)(l / 60L / 60L / 24L);
        if (OsConstants.isMacLion()) {
            maccmd.changeUpdateSettings(bl ? 1 : 0, n, -1, -1);
        } else {
            maccmd.changeUpdateSettings(bl ? 1 : 0, -1, -1, -1);
        }
    }

    public final void setSoftwareUpdates(boolean bl, long l) {
        if (OsConstants.isMacLionOrLater()) {
            this.setSoftwareUpdatesLionOrLater(bl, l);
            return;
        }
        Plist plist = PlistUtil.getCurrentPlist(this.cls_FileHandler, this.cls_CommandHandler, this.cls_Plist, null);
        if (plist != null) {
            Dict dict = plist.getDict().getDict("AbsoluteSchedule", new Dict());
            Dict dict2 = dict.getDict("com.apple.SoftwareUpdate", new Dict());
            Dict dict3 = dict2.getDict("SUCheckSchedulerTag", new Dict());
            Dict dict4 = dict3.getDict("Timer", new Dict());
            if (bl) {
                if (l <= 0L) {
                    l = 604800L;
                }
                dict4.removeKey(KEY_REPEAT_INTERVAL);
                dict4.addReal(KEY_REPEAT_INTERVAL, "" + l);
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
                String string = simpleDateFormat.format(new Date(System.currentTimeMillis() + 86400000L));
                dict4.removeKey(KEY_DATE);
                dict4.addDate(KEY_DATE, string);
            } else {
                dict4.removeKey(KEY_DATE);
                if (this.cls_OsInfo.isMacTigerOrBefore()) {
                    dict4.addDate(KEY_DATE, "4001-01-02T00:00:00Z");
                } else {
                    dict4.addDate(KEY_DATE, "4001-01-01T00:00:00Z");
                }
                dict4.removeKey(KEY_REPEAT_INTERVAL);
                dict4.addReal(KEY_REPEAT_INTERVAL, "" + l);
            }
            this.cls_DefaultsProvider.write(this.cls_Plist.getAbsolutePath(), "AbsoluteSchedule", dict.getXml(""));
        }
    }

    public final boolean isSoftwareUpdatesEnabled() {
        SoftwareUpdateState softwareUpdateState = this.getSoftwareUpdateState();
        return softwareUpdateState != null ? softwareUpdateState.isEnabled() : true;
    }

    public final long getSoftwareUpdateInterval() {
        SoftwareUpdateState softwareUpdateState = this.getSoftwareUpdateState();
        return softwareUpdateState != null ? softwareUpdateState.getInterval() : 0L;
    }

    public boolean isSoftwareUpToDate() {
        this.refreshCacheIfNecessary();
        return this.cls_Cache_PendingUpdates.size() == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getPending(String string) {
        log.debug((Object)("Will check if '" + string + "' is a pending update.  (Pending count=" + this.cls_Cache_PendingUpdates.size() + ")"));
        this.refreshCacheIfNecessary();
        if (string == null || string.length() == 0 || "*".equals(string)) {
            log.debug((Object)" - Treating name as wildcard.");
            Vector<String> vector = this.cls_Cache_PendingUpdates;
            synchronized (vector) {
                String[] stringArray = new String[this.cls_Cache_PendingUpdates.size()];
                this.cls_Cache_PendingUpdates.toArray(stringArray);
                return stringArray;
            }
        }
        if (this.cls_Cache_PendingUpdates.contains(string)) {
            log.debug((Object)" - Pending update found by exact match.");
            return new String[]{string};
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        if (!string.contains("-")) {
            String string2 = string + "-";
            for (int i = 0; i < this.cls_Cache_PendingUpdates.size(); ++i) {
                String string3 = this.cls_Cache_PendingUpdates.get(i);
                if (!string3.startsWith(string2)) continue;
                log.debug((Object)" - Pending update found by versionless match.");
                arrayList.add(string3);
            }
        }
        if (arrayList.size() == 0) {
            for (int i = 0; i < this.cls_Cache_PendingUpdates.size(); ++i) {
                String string4 = this.cls_Cache_PendingUpdates.get(i);
                try {
                    if (!string4.matches(string)) continue;
                    log.debug((Object)" - Pending update found by regex match.");
                    arrayList.add(string4);
                    continue;
                }
                catch (PatternSyntaxException patternSyntaxException) {
                    log.warn((Object)("Regex pattern syntax error occurred with '" + string + "'."), (Throwable)patternSyntaxException);
                    i = Integer.MAX_VALUE;
                }
            }
        }
        if (arrayList.size() > 0) {
            String[] stringArray = new String[arrayList.size()];
            arrayList.toArray(stringArray);
            return stringArray;
        }
        log.debug((Object)" - No pending update found.");
        return new String[0];
    }

    public final boolean isHotfixInstalled(String string) {
        log.error((Object)"IsHotfixInstalled not supported on Mac.");
        return false;
    }

    public long getAutoUpdateLastDetect() {
        return 0L;
    }

    public long getAutoUpdateLastDownload() {
        return 0L;
    }

    public long getAutoUpdateLastInstall() {
        return 0L;
    }

    public final boolean openSystemPrefs() {
        return MacUtil.openSystemPrefs(this.cls_CommandHandler, "SoftwareUpdate");
    }

    private final SoftwareUpdateState getSoftwareUpdateStateLionOrLater() {
        Plist plist = PlistUtil.getCurrentPlist(this.cls_FileHandler, this.cls_CommandHandler, this.cls_Plist, null);
        if (plist != null) {
            Dict dict = plist.getDict();
            long l = dict.getInteger("ScheduleFrequency", 7L);
            long l2 = l * 24L * 60L * 60L;
            boolean bl = true;
            if (l < 0L) {
                bl = false;
                l = -1L;
            } else {
                l = l2;
            }
            return new SoftwareUpdateState(bl, l);
        }
        return null;
    }

    private final SoftwareUpdateState getSoftwareUpdateState() {
        if (OsConstants.isMacLionOrLater()) {
            return this.getSoftwareUpdateStateLionOrLater();
        }
        Plist plist = PlistUtil.getCurrentPlist(this.cls_FileHandler, this.cls_CommandHandler, this.cls_Plist, null);
        if (plist != null) {
            Dict dict = plist.getDict().getDict("AbsoluteSchedule", new Dict());
            Dict dict2 = dict.getDict("com.apple.SoftwareUpdate", new Dict());
            Dict dict3 = dict2.getDict("SUCheckSchedulerTag", new Dict());
            Dict dict4 = dict3.getDict("Timer", new Dict());
            long l = dict4.getDate(KEY_DATE, -1L);
            boolean bl = true;
            if (l >= 0L) {
                Calendar calendar = GregorianCalendar.getInstance();
                calendar.setTimeInMillis(l);
                if (calendar.get(1) > 3000) {
                    bl = false;
                }
            }
            long l2 = 604800L;
            try {
                l2 = Long.parseLong(dict4.getString(KEY_REPEAT_INTERVAL, ""));
            }
            catch (Exception exception) {
                // empty catch block
            }
            return new SoftwareUpdateState(bl, l2);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int refreshPendingUpdates(String[] stringArray, String[] stringArray2) {
        if (stringArray != null && stringArray.length <= 3 && stringArray2 != null && Util.join(stringArray2).length() > 0) {
            if (Util.join(stringArray2).startsWith("No new software available.")) {
                log.info((Object)"There are no pending system updates.");
                this.cls_PendingUpdatesCacheState = 1;
            } else {
                log.error((Object)("The attempt to refresh the pending updates list faild.  This is commonly due to a lack of internet connectivity.  \nSTDOUT:\n" + Util.join(stringArray) + "\nSTDERR:\n" + Util.join(stringArray2)));
                this.cls_PendingUpdatesCacheState = 0;
            }
        } else {
            this.cls_PendingUpdatesCacheState = 1;
            Vector<String> vector = this.cls_Cache_PendingUpdates;
            synchronized (vector) {
                this.cls_Cache_PendingUpdates.clear();
                for (int i = 0; i < stringArray.length; ++i) {
                    String string = stringArray[i].trim();
                    if (!string.startsWith("*")) continue;
                    string = string.substring(2);
                    this.cls_Cache_PendingUpdates.add(string);
                }
            }
        }
        return this.cls_PendingUpdatesCacheState;
    }

    private void refreshCacheIfNecessary() {
        if (this.cls_PendingUpdatesCacheState <= 0) {
            try {
                if (this.cls_PendingUpdatesCacheState == 0) {
                    log.info((Object)"The cached pending update list was a failed load.  Will retry...");
                } else {
                    log.info((Object)"The pending update list has not yet been loaded.  Will load...");
                }
                this.refreshPendingUpdates();
            }
            catch (Exception exception) {
                log.error((Object)"An error occurred while loading the pending updates list.", (Throwable)exception);
            }
        }
    }

    protected int getCacheStateForPendingUpdates() {
        return this.cls_PendingUpdatesCacheState;
    }

    protected void refreshPendingUpdates() throws Exception {
        String[] stringArray = new String[]{"softwareupdate", "-l"};
        CommandResponse commandResponse = this.cls_CommandHandler.executeCommand(stringArray);
        commandResponse.waitFor();
        this.refreshPendingUpdates(commandResponse.getOutput(), commandResponse.getError());
    }

    private static class SoftwareUpdateState {
        private final boolean cls_IsEnabled;
        private final long cls_Interval;

        public SoftwareUpdateState(boolean bl, long l) {
            this.cls_IsEnabled = bl;
            this.cls_Interval = l;
        }

        public boolean isEnabled() {
            return this.cls_IsEnabled;
        }

        public long getInterval() {
            return this.cls_Interval;
        }
    }
}

