/*
 * Decompiled with CFR 0.152.
 */
package com.cloudpath.common.os.mac.common.plist;

import com.cloudpath.common.command.CommandHandler;
import com.cloudpath.common.command.CommandResponse;
import com.cloudpath.common.os.mac.common.plist.parse.DictHelper;
import com.cloudpath.common.os.mac.common.plist.parse.PlistHelper;
import com.cloudpath.common.os.mac.common.plist.parse.ValueArrayHelper;
import com.cloudpath.common.os.mac.common.plist.parse.ValueDataHelper;
import com.cloudpath.common.os.mac.common.plist.parse.ValueDateHelper;
import com.cloudpath.common.os.mac.common.plist.parse.ValueFalseHelper;
import com.cloudpath.common.os.mac.common.plist.parse.ValueIntegerHelper;
import com.cloudpath.common.os.mac.common.plist.parse.ValueRealHelper;
import com.cloudpath.common.os.mac.common.plist.parse.ValueStringHelper;
import com.cloudpath.common.os.mac.common.plist.parse.ValueTrueHelper;
import com.cloudpath.common.os.mac.common.plist.pojo.Plist;
import com.cloudpath.common.parse.ElementAssignment;
import com.cloudpath.common.parse.InvalidXmlException;
import com.cloudpath.common.parse.ParseManager;
import com.cloudpath.common.util.FileHandler;
import java.io.File;
import java.io.IOException;

public class PlistConstants {
    public static final String INDENT = "\t";
    public static final ElementAssignment[] PLIST_ELEMENTS = new ElementAssignment[]{new ElementAssignment("plist", new PlistHelper()), new ElementAssignment("dict", new DictHelper()), new ElementAssignment("array", new ValueArrayHelper()), new ElementAssignment("false", new ValueFalseHelper()), new ElementAssignment("true", new ValueTrueHelper()), new ElementAssignment("data", new ValueDataHelper()), new ElementAssignment("integer", new ValueIntegerHelper()), new ElementAssignment("real", new ValueRealHelper()), new ElementAssignment("string", new ValueStringHelper()), new ElementAssignment("date", new ValueDateHelper())};

    public static final Plist readPlist(CommandHandler commandHandler, FileHandler fileHandler, File file) throws IOException, InvalidXmlException {
        File file2 = File.createTempFile("xpc_", ".plist");
        CommandResponse commandResponse = commandHandler.executeCommand(new String[]{"cp", file.getAbsolutePath(), file2.getAbsolutePath()});
        commandResponse.waitFor();
        commandResponse = commandHandler.executeCommand(new String[]{"plutil", "-convert", "xml1", file2.getAbsolutePath()});
        commandResponse.waitFor();
        String string = fileHandler.readFile(file2);
        ParseManager parseManager = new ParseManager(PLIST_ELEMENTS);
        Plist plist = (Plist)parseManager.parse(string);
        if (!file2.delete()) {
            file2.deleteOnExit();
        }
        return plist;
    }

    public static final String readRawPlist(CommandHandler commandHandler, FileHandler fileHandler, File file) throws IOException, InvalidXmlException {
        File file2 = File.createTempFile("xpc_", ".plist");
        CommandResponse commandResponse = commandHandler.executeCommand(new String[]{"cp", file.getAbsolutePath(), file2.getAbsolutePath()});
        commandResponse.waitFor();
        commandResponse = commandHandler.executeCommand(new String[]{"plutil", "-convert", "xml1", file2.getAbsolutePath()});
        commandResponse.waitFor();
        String string = fileHandler.readFile(file2);
        if (!file2.delete()) {
            file2.deleteOnExit();
        }
        return string;
    }

    public static final Plist readPlist(String string) throws IOException, InvalidXmlException {
        ParseManager parseManager = new ParseManager(PLIST_ELEMENTS);
        Plist plist = (Plist)parseManager.parse(string);
        return plist;
    }
}

