/*
 * Decompiled with CFR 0.152.
 */
package com.cloudpath.common.os.mac.common.network.networksetup;

import com.cloudpath.common.command.CommandHandler;
import com.cloudpath.common.command.CommandResponse;
import com.cloudpath.common.os.mac.common.network.networksetup.HardwarePort;
import com.cloudpath.common.os.mac.common.network.networksetup.Ipv6Behavior;
import com.cloudpath.common.os.mac.common.network.networksetup.NetworkServiceOrderItem;
import com.cloudpath.common.os.mac.common.network.networksetup.ServiceInfo;
import com.cloudpath.common.util.Util;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.log4j.Logger;

public abstract class NetworkSetupReader {
    private static final Logger log = Logger.getLogger(NetworkSetupReader.class);
    private final String cls_Path;
    private final String cls_scPath;
    protected final CommandHandler cls_CommandHandler;
    private HashMap<String, HardwarePort> cls_HardwarePorts = null;

    public NetworkSetupReader(String string, String string2, CommandHandler commandHandler) {
        this.cls_Path = string;
        this.cls_scPath = string2;
        this.cls_CommandHandler = commandHandler;
    }

    public HardwarePort getHardwarePort(String string) throws Exception {
        log.debug((Object)("Will get hardware port for device '" + string + "'."));
        if (this.cls_HardwarePorts == null) {
            this.cls_HardwarePorts = new HashMap();
            String[] stringArray = new String[]{this.getPath(), "-listallhardwareports"};
            CommandResponse commandResponse = this.cls_CommandHandler.executeCommand(stringArray);
            commandResponse.waitFor();
            String string2 = Util.join(commandResponse.getOutput());
            String[] stringArray2 = string2.split("\n\n");
            for (int i = 0; i < stringArray2.length; ++i) {
                HardwarePort hardwarePort = new HardwarePort(stringArray2[i]);
                this.cls_HardwarePorts.put(hardwarePort.getDeviceName(), hardwarePort);
            }
        }
        return this.cls_HardwarePorts.get(string);
    }

    public ServiceInfo getServiceInfo(String string) throws Exception {
        log.debug((Object)("Will get service info for '" + string + "'."));
        if (string != null) {
            String[] stringArray = new String[]{this.getPath(), "-getinfo", string};
            CommandResponse commandResponse = this.cls_CommandHandler.executeCommand(stringArray);
            commandResponse.waitFor();
            String string2 = Util.join(commandResponse.getOutput());
            ServiceInfo serviceInfo = new ServiceInfo(string, string2);
            return serviceInfo;
        }
        return null;
    }

    public void setNetworkServiceState(String string, boolean bl) {
        log.debug((Object)("Will set network service state for '" + string + "' to " + bl + "."));
        if (string != null) {
            try {
                String[] stringArray = new String[]{this.getPath(), "-setnetworkserviceenabled", string, bl ? "on" : "off"};
                this.cls_CommandHandler.executeCommand(stringArray).waitFor();
            }
            catch (IOException iOException) {
                log.error((Object)"Error occurred while setting network service state.", (Throwable)iOException);
            }
        }
    }

    protected String getPath() {
        return this.cls_Path;
    }

    protected String getScPath() {
        return this.cls_scPath;
    }

    public Ipv6Behavior getIpv6Behavior(String string) {
        log.debug((Object)("Will get IPv6 behavior for service name '" + string + "'."));
        try {
            ServiceInfo serviceInfo = this.getServiceInfo(string);
            if (serviceInfo != null) {
                return serviceInfo.getIpv6Behavior();
            }
            return Ipv6Behavior.OFF;
        }
        catch (Exception exception) {
            log.error((Object)("Unexpected error occurred while getting service info for " + string + "."), (Throwable)exception);
            return Ipv6Behavior.OFF;
        }
    }

    public void setIpv6Behavior(String string, Ipv6Behavior ipv6Behavior) throws IOException {
        log.debug((Object)("Will set IPv6 behavior for service name '" + string + "'."));
        if (string != null) {
            String[] stringArray = ipv6Behavior != null && ipv6Behavior.isAutomatic() ? new String[]{this.getPath(), "-setv6automatic", string} : (ipv6Behavior != null && ipv6Behavior.isManual() ? new String[]{this.getPath(), "-setv6manual", string, ipv6Behavior.getIpv6Address(), ipv6Behavior.getIpv6PrefixLength(), ipv6Behavior.getIpv6Router()} : new String[]{this.getPath(), "-setv6off", string});
            this.cls_CommandHandler.executeCommand(stringArray).waitFor();
        }
    }

    public void setAirportPower(String string, boolean bl) {
        log.debug((Object)("Will set airport power for '" + string + "' to " + bl + "."));
        this.checkInterfaceName(string);
        if (string != null) {
            try {
                String[] stringArray = new String[]{this.getPath(), "-setairportpower", string, bl ? "on" : "off"};
                CommandResponse commandResponse = this.cls_CommandHandler.executeCommand(stringArray);
                commandResponse.waitFor();
            }
            catch (Exception exception) {
                log.warn((Object)("An error occurred while setting airport '" + string + "' power to " + (bl ? "on" : "off") + "."), (Throwable)exception);
            }
        }
    }

    public boolean getAirportPower(String string) {
        log.debug((Object)("Will get airport power for '" + string + "'."));
        this.checkInterfaceName(string);
        if (string != null) {
            try {
                String[] stringArray = new String[]{this.getPath(), "-getairportpower", string};
                CommandResponse commandResponse = this.cls_CommandHandler.executeCommand(stringArray);
                commandResponse.waitFor();
                String string2 = Util.join(commandResponse.getOutput());
                String string3 = "";
                int n = string2.indexOf(": ");
                if (string2 != null && n >= 0 && string2.length() > n + 2) {
                    string3 = string2.substring(n + 2);
                }
                return !string3.toLowerCase().contains("off");
            }
            catch (Exception exception) {
                log.warn((Object)"An error occurred while getting airport power.", (Throwable)exception);
                return true;
            }
        }
        return true;
    }

    public void addNetworkService(String string, String string2) {
        log.debug((Object)("Will add network service for '" + string + "' on '" + string2 + "'."));
        if (string != null && string2 != null) {
            try {
                String[] stringArray = new String[]{this.getPath(), "-createnetworkservice", string, string2};
                CommandResponse commandResponse = this.cls_CommandHandler.executeCommand(stringArray);
                commandResponse.waitFor();
            }
            catch (Exception exception) {
                log.warn((Object)("An error occurred while creating network service '" + string + "' on interface '" + string2 + "'."), (Throwable)exception);
            }
        }
    }

    public void deleteNetworkService(String string) {
        log.debug((Object)("Will delete network service '" + string + "'."));
        if (string != null) {
            try {
                String[] stringArray = new String[]{this.getPath(), "-removenetworkservice", string};
                CommandResponse commandResponse = this.cls_CommandHandler.executeCommand(stringArray);
                commandResponse.waitFor();
            }
            catch (Exception exception) {
                log.warn((Object)("An error occurred while removing network service '" + string + "'."), (Throwable)exception);
            }
        }
    }

    public boolean getNetworkServiceState(String string) {
        log.debug((Object)("Will get network service state for '" + string + "'."));
        if (string != null) {
            try {
                String[] stringArray = new String[]{this.getPath(), "-getnetworkserviceenabled", string};
                CommandResponse commandResponse = this.cls_CommandHandler.executeCommand(stringArray);
                commandResponse.waitFor();
                String string2 = Util.join(commandResponse.getOutput());
                if (string2.contains("** Error:")) {
                    return false;
                }
                return !string2.toLowerCase().contains("disabled");
            }
            catch (Exception exception) {
                log.warn((Object)("An error occurred while getting state of network service '" + string + "'."), (Throwable)exception);
                return true;
            }
        }
        return true;
    }

    public void setNetworkServiceEnabled(String string, boolean bl) {
        log.debug((Object)("Will set network service state for '" + string + "' to " + bl + "."));
        if (string != null) {
            try {
                String[] stringArray = new String[]{this.getPath(), "-setnetworkserviceenabled", string, bl ? "on" : "off"};
                CommandResponse commandResponse = this.cls_CommandHandler.executeCommand(stringArray);
                commandResponse.waitFor();
            }
            catch (Exception exception) {
                log.warn((Object)("An error occurred while setting network service '" + string + "' state to " + (bl ? "on" : "off") + "."), (Throwable)exception);
            }
        }
    }

    public boolean doesNetworkServiceExist(String string) {
        log.debug((Object)("Does network service '" + string + "' exist?"));
        if (string != null) {
            String[] stringArray = this.getAllNetworkServicesRaw();
            for (int i = 0; i < stringArray.length; ++i) {
                if (!string.equals(stringArray[i]) && !("*" + string).equals(stringArray[i])) continue;
                return true;
            }
        }
        return false;
    }

    public String[] getAllEnabledNetworkServices() {
        log.debug((Object)"Will get all enabled network services.");
        String[] stringArray = this.getAllNetworkServicesRaw();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].startsWith("*")) continue;
            arrayList.add(stringArray[i]);
        }
        String[] stringArray2 = new String[arrayList.size()];
        arrayList.toArray(stringArray2);
        return stringArray2;
    }

    public String[] getAllNetworkServicesRaw() {
        try {
            String[] stringArray = new String[]{this.getPath(), "-listallnetworkservices"};
            CommandResponse commandResponse = this.cls_CommandHandler.executeCommand(stringArray);
            commandResponse.waitFor();
            String[] stringArray2 = commandResponse.getOutput();
            ArrayList<String> arrayList = new ArrayList<String>();
            for (int i = 1; i < stringArray2.length; ++i) {
                if (i <= 0 && stringArray2[i].startsWith("An asterisk")) continue;
                arrayList.add(stringArray2[i].trim());
            }
            String[] stringArray3 = new String[arrayList.size()];
            arrayList.toArray(stringArray3);
            return stringArray3;
        }
        catch (Exception exception) {
            log.warn((Object)"An error occurred while getting all network services.", (Throwable)exception);
            return new String[0];
        }
    }

    public String getMacAddress(String string) {
        log.debug((Object)("Will get mac address for '" + string + "'."));
        if (string != null) {
            try {
                String[] stringArray = new String[]{this.getPath(), "-getmacaddress", string};
                CommandResponse commandResponse = this.cls_CommandHandler.executeCommand(stringArray);
                commandResponse.waitFor();
                String string2 = Util.join(commandResponse.getOutput());
                if (string2.contains("** Error:")) {
                    return null;
                }
                String string3 = "";
                if (string2 != null && string2.indexOf(": ") > 0) {
                    string3 = string2.substring(string2.indexOf(": ") + 2);
                }
                if (string3.indexOf(" (") > 0) {
                    string3 = string3.substring(0, string3.indexOf(" ("));
                }
                return string3;
            }
            catch (Exception exception) {
                log.warn((Object)("An error occurred while getting mac address of '" + string + "'."), (Throwable)exception);
                return "";
            }
        }
        return "";
    }

    public String getNetworkServiceByInterfaceName(String string) {
        log.debug((Object)("Will get network service by '" + string + "'."));
        if (string != null && string.length() > 0) {
            NetworkServiceOrderItem[] networkServiceOrderItemArray = this.getNetworkServiceOrder();
            for (int i = 0; i < networkServiceOrderItemArray.length; ++i) {
                if (!string.equals(networkServiceOrderItemArray[i].getInterfaceName()) || !this.getNetworkServiceState(networkServiceOrderItemArray[i].getServiceName())) continue;
                return networkServiceOrderItemArray[i].getServiceName();
            }
        }
        return null;
    }

    public NetworkServiceOrderItem[] getNetworkServiceOrder() {
        log.debug((Object)"Will get network service order...");
        try {
            String[] stringArray = new String[]{this.getPath(), "-listnetworkserviceorder"};
            CommandResponse commandResponse = this.cls_CommandHandler.executeCommand(stringArray);
            commandResponse.waitFor();
            String[] stringArray2 = commandResponse.getOutput();
            ArrayList<NetworkServiceOrderItem> arrayList = new ArrayList<NetworkServiceOrderItem>();
            for (int i = 0; i < stringArray2.length; ++i) {
                if (!stringArray2[i].startsWith("(") || stringArray2[i].endsWith(")")) continue;
                String string = stringArray2[i];
                String string2 = "";
                if (stringArray2.length > i) {
                    string2 = stringArray2[i + 1];
                }
                NetworkServiceOrderItem networkServiceOrderItem = new NetworkServiceOrderItem(string, string2);
                arrayList.add(networkServiceOrderItem);
            }
            NetworkServiceOrderItem[] networkServiceOrderItemArray = new NetworkServiceOrderItem[arrayList.size()];
            arrayList.toArray(networkServiceOrderItemArray);
            return networkServiceOrderItemArray;
        }
        catch (Exception exception) {
            log.warn((Object)"An error occurred while getting network service order.", (Throwable)exception);
            return new NetworkServiceOrderItem[0];
        }
    }

    protected void checkInterfaceName(String string) {
        block0: {
            if (string == null || string.startsWith("en")) break block0;
            Exception exception = new Exception("**** ERROR: THE SERVICE NAME IS BEING PASSED RATHER THAN THE INTERFACE. '" + string + "'");
            exception.printStackTrace();
            log.error((Object)("The interfaceName '" + string + "' provided does not appear correct."), (Throwable)exception);
        }
    }
}

