/*
 * Decompiled with CFR 0.152.
 */
package com.cloudpath.common.os.mac.common.network.networksetup;

import com.cloudpath.common.os.mac.common.MacUtil;
import com.cloudpath.common.util.OsConstants;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.log4j.Logger;

public class HttpProxyBehavior {
    private static final Logger log = Logger.getLogger(HttpProxyBehavior.class);
    public static final HttpProxyBehavior DISABLED = new HttpProxyBehavior(HttpProxyType.DISABLED, "", "", "");
    public static final HttpProxyBehavior AUTODETECTED = new HttpProxyBehavior(HttpProxyType.AUTODETECT, "", "", "");
    private final String PROXY_ENABLED = "HTTPEnable : ";
    private final String PROXY_SERVER = "HTTPProxy : ";
    private final String PROXY_PORT = "HTTPPort : ";
    private final String PROXY_AUTOCONF = "ProxyAutoConfigEnable : ";
    private final String PROXY_URLSTRING = "ProxyAutoConfigURLString : ";
    private final String PROXY_AUTODISCOVER = "ProxyAutoDiscoveryEnable : ";
    private HttpProxyType cls_HttpProxyType;
    private String cls_HttpProxyServer;
    private String cls_HttpProxyPort;
    private String cls_ProxyEnabled;
    private String cls_ProxyAutoConf;
    private String cls_ProxyUrlString;
    private String cls_ProxyAutoDiscover;

    public HttpProxyBehavior() {
        this(HttpProxyType.DISABLED, "", "", "");
    }

    public HttpProxyBehavior(HttpProxyType httpProxyType) {
        this(httpProxyType, "", "", "");
    }

    public HttpProxyBehavior(HttpProxyType httpProxyType, String string, String string2, String string3) {
        this.cls_HttpProxyType = httpProxyType;
        this.cls_HttpProxyServer = string;
        this.cls_HttpProxyPort = string2;
        this.cls_ProxyUrlString = string3;
    }

    public boolean isDisabled() {
        return HttpProxyType.DISABLED.equals((Object)this.cls_HttpProxyType);
    }

    public boolean isManual() {
        return HttpProxyType.MANUAL.equals((Object)this.cls_HttpProxyType);
    }

    public boolean isAutodetect() {
        return HttpProxyType.AUTODETECT.equals((Object)this.cls_HttpProxyType);
    }

    public boolean isAutoByUrl() {
        return HttpProxyType.AUTO_BY_URL.equals((Object)this.cls_HttpProxyType);
    }

    public boolean isAutoOrByUrl() {
        return HttpProxyType.AUTO_OR_BY_URL.equals((Object)this.cls_HttpProxyType);
    }

    public HttpProxyType getHttpProxyType() {
        return this.cls_HttpProxyType;
    }

    public void setHttpProxyServer(String string) {
        this.cls_HttpProxyServer = string;
    }

    public String getHttpProxyServer() {
        return this.isManualProxyEnabled() ? this.cls_HttpProxyServer : "";
    }

    public void setHttpProxyPort(String string) {
        this.cls_HttpProxyPort = string;
    }

    public String getHttpProxyPort() {
        return this.cls_HttpProxyPort != null ? this.cls_HttpProxyPort : "";
    }

    public void setHttpProxyAutoconfUrl(String string) {
        this.cls_ProxyUrlString = string;
    }

    public String getHttpProxyAutoconfUrl() {
        return this.cls_ProxyUrlString;
    }

    public String getServerOnly() {
        URL uRL = null;
        try {
            uRL = new URL(this.cls_HttpProxyServer);
        }
        catch (MalformedURLException malformedURLException) {
            log.info((Object)("Proxy URL '" + this.cls_HttpProxyServer + "' is not in url format.  Will adjust as needed."));
            try {
                uRL = new URL("http://" + this.cls_HttpProxyServer);
            }
            catch (MalformedURLException malformedURLException2) {
                log.debug((Object)("Modified proxy URL 'http://" + this.cls_HttpProxyServer + "' is malformed in HttpProxyBehavior."));
                return "";
            }
        }
        return uRL.getHost();
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof HttpProxyBehavior) {
            if (this.getHttpProxyType().equals((Object)HttpProxyType.MANUAL)) {
                log.info((Object)("COMPARE: This  object : " + this.toString()));
                log.info((Object)("A        Other object : " + object));
                return ((HttpProxyBehavior)object).getHttpProxyType().equals((Object)this.getHttpProxyType()) && !((HttpProxyBehavior)object).getHttpProxyServer().startsWith("http") && ((HttpProxyBehavior)object).getServerOnly().equals(this.getServerOnly()) && ((HttpProxyBehavior)object).getHttpProxyPort().equals(this.getHttpProxyPort()) && ((HttpProxyBehavior)object).getHttpProxyAutoconfUrl().equals(this.getHttpProxyAutoconfUrl());
            }
            if (this.getHttpProxyType().equals((Object)HttpProxyType.AUTODETECT)) {
                log.info((Object)("COMPARE: This  object : " + this.toString()));
                log.info((Object)("B        Other object : " + object));
                return ((HttpProxyBehavior)object).getHttpProxyType().equals((Object)this.getHttpProxyType());
            }
            if (this.getHttpProxyType().equals((Object)HttpProxyType.AUTO_BY_URL)) {
                log.info((Object)("COMPARE: This  object : " + this.toString()));
                log.info((Object)("C        Other object : " + object));
                return ((HttpProxyBehavior)object).getHttpProxyType().equals((Object)this.getHttpProxyType()) && ((HttpProxyBehavior)object).getHttpProxyAutoconfUrl().equals(this.getHttpProxyAutoconfUrl());
            }
            log.info((Object)("(A) COMPARE:  This object : " + this.toString()));
            log.info((Object)("             Other object : " + object));
            if (this.getHttpProxyType().equals((Object)HttpProxyType.AUTO_OR_BY_URL)) {
                log.debug((Object)"Will compare AUTO_OR_BY_URL.");
                if (OsConstants.isMacLeopardOrBefore()) {
                    return ((HttpProxyBehavior)object).getHttpProxyType().equals((Object)HttpProxyType.AUTO_BY_URL) && this.proxySettingsMatch(object);
                }
                this.setHttpProxyAutoconfUrl("");
                return ((HttpProxyBehavior)object).getHttpProxyType().equals((Object)HttpProxyType.AUTODETECT) && this.proxySettingsMatch(object);
            }
            return ((HttpProxyBehavior)object).getHttpProxyType().equals((Object)this.getHttpProxyType()) && this.proxySettingsMatch(object);
        }
        return false;
    }

    private boolean proxySettingsMatch(Object object) {
        HttpProxyBehavior httpProxyBehavior = (HttpProxyBehavior)object;
        return httpProxyBehavior.getHttpProxyServer().equals(this.getHttpProxyServer()) && httpProxyBehavior.getHttpProxyPort().equals(this.getHttpProxyPort()) && httpProxyBehavior.getHttpProxyAutoconfUrl().equals(this.getHttpProxyAutoconfUrl());
    }

    public void parse(String string) {
        String[] stringArray = string.split("\n");
        log.info((Object)("Lines : " + stringArray.length));
        this.parse(stringArray);
    }

    private boolean isManualProxyEnabled() {
        return this.cls_ProxyEnabled != null && this.cls_ProxyEnabled.contentEquals("0");
    }

    public void parse(String[] stringArray) {
        log.info((Object)"Will parse proxy configuration...");
        for (int i = 0; i < stringArray.length; ++i) {
            this.parseLine(stringArray[i]);
        }
        log.info((Object)("ProxyEnabled: " + this.cls_ProxyEnabled));
        log.info((Object)("ProxyAutoConf: " + this.cls_ProxyAutoConf));
        log.info((Object)("ProxyAutoDiscover: " + this.cls_ProxyAutoDiscover));
        log.info((Object)("HttpProxyServer: " + this.cls_HttpProxyServer));
        log.info((Object)("HttpProxyPort: " + this.cls_HttpProxyPort));
        log.info((Object)("ProxyUrlString: " + this.cls_ProxyUrlString));
        if (this.cls_ProxyEnabled != null && this.cls_ProxyEnabled.contentEquals("0") && this.cls_ProxyAutoConf != null && this.cls_ProxyAutoConf.contentEquals("0") && this.cls_ProxyAutoDiscover != null && this.cls_ProxyAutoDiscover.contentEquals("0")) {
            log.info((Object)"Proxy type is disabled.");
            this.cls_HttpProxyType = HttpProxyType.DISABLED;
        } else if (this.cls_ProxyEnabled != null && this.cls_ProxyEnabled.contentEquals("1")) {
            log.info((Object)"Proxy type is manual.");
            this.cls_HttpProxyType = HttpProxyType.MANUAL;
        } else if (this.cls_ProxyAutoConf != null && this.cls_ProxyAutoConf.contentEquals("1") && (this.cls_ProxyAutoDiscover == null || this.cls_ProxyAutoDiscover.contentEquals("0"))) {
            log.info((Object)"Proxy type is autoByUrl.");
            this.cls_HttpProxyType = HttpProxyType.AUTO_BY_URL;
        } else if (this.cls_ProxyAutoDiscover != null && this.cls_ProxyAutoDiscover.contentEquals("1") && (this.cls_ProxyAutoConf == null || this.cls_ProxyAutoConf.contentEquals("0"))) {
            log.info((Object)"Proxy type is autoDetect.");
            this.cls_HttpProxyType = HttpProxyType.AUTODETECT;
        } else if (this.cls_ProxyAutoDiscover != null && this.cls_ProxyAutoDiscover.contentEquals("1") && this.cls_ProxyAutoConf != null && this.cls_ProxyAutoConf.contentEquals("1")) {
            log.info((Object)"Proxy type is autoByUrl2.");
            this.cls_HttpProxyType = HttpProxyType.AUTO_OR_BY_URL;
        }
    }

    private String checkNull(String string) {
        if (string == null || string.equals("(null)") || string.equals("none")) {
            return "";
        }
        return string;
    }

    private void parseLine(String string) {
        if ((string = string.trim()).startsWith("HTTPEnable : ")) {
            this.cls_ProxyEnabled = this.checkNull(MacUtil.parseSetting(string, "HTTPEnable : ", null));
        } else if (string.startsWith("HTTPProxy : ")) {
            this.cls_HttpProxyServer = this.checkNull(MacUtil.parseSetting(string, "HTTPProxy : ", null));
        } else if (string.startsWith("HTTPPort : ")) {
            this.cls_HttpProxyPort = this.checkNull(MacUtil.parseSetting(string, "HTTPPort : ", null));
        } else if (string.startsWith("ProxyAutoConfigEnable : ")) {
            this.cls_ProxyAutoConf = this.checkNull(MacUtil.parseSetting(string, "ProxyAutoConfigEnable : ", null));
        } else if (string.startsWith("ProxyAutoConfigURLString : ")) {
            this.cls_ProxyUrlString = this.checkNull(MacUtil.parseSetting(string, "ProxyAutoConfigURLString : ", null));
        } else if (string.startsWith("ProxyAutoDiscoveryEnable : ")) {
            this.cls_ProxyAutoDiscover = this.checkNull(MacUtil.parseSetting(string, "ProxyAutoDiscoveryEnable : ", null));
        }
    }

    public String toString() {
        return "[HttpProxyBehavior type='" + (Object)((Object)this.getHttpProxyType()) + "' httpProxyServer='" + this.getHttpProxyServer() + "' serverOnly='" + this.getServerOnly() + "' proxyPort='" + this.getHttpProxyPort() + "' autoconfUrl='" + this.getHttpProxyAutoconfUrl() + "']";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum HttpProxyType {
        DISABLED("Disabled", "0"),
        AUTODETECT("Auto-detect", "1"),
        MANUAL("Manual", "2"),
        AUTO_BY_URL("Auto configure via URL", "3"),
        AUTO_OR_BY_URL("Auto-detect, or configure by URL", "4");

        public final String Label;
        public final String DbValue;

        private HttpProxyType(String string2, String string3) {
            this.Label = string2;
            this.DbValue = string3;
        }

        public static HttpProxyType parse(String string) {
            for (int i = 0; i < HttpProxyType.values().length; ++i) {
                if (!HttpProxyType.values()[i].Label.equals(string)) continue;
                return HttpProxyType.values()[i];
            }
            return DISABLED;
        }

        public static HttpProxyType getByDbValue(String string) {
            for (int i = 0; i < HttpProxyType.values().length; ++i) {
                if (!HttpProxyType.values()[i].DbValue.equals(string)) continue;
                return HttpProxyType.values()[i];
            }
            return DISABLED;
        }
    }
}

