/*
 * Decompiled with CFR 0.152.
 */
package com.cloudpath.common.os.mac.common.network.airport;

import com.cloudpath.common.os.common.WirelessAssociation;
import com.cloudpath.common.os.common.WirelessProvider;
import com.cloudpath.common.os.mac.common.network.airport.SsidListener;
import com.cloudpath.common.util.Util;
import org.apache.log4j.Logger;

public class SsidMonitor
implements Runnable {
    private static final Logger log = Logger.getLogger(SsidMonitor.class);
    private final WirelessProvider cls_WirelessProvider;
    private boolean cls_Continue = true;
    private final String cls_LogicalGuid;
    private final String cls_DesiredSsid;
    private final SsidListener cls_SsidListener;
    private final Thread cls_Thread;
    private final int cls_BackoffRate;
    private int cls_PollingInterval;
    private final long cls_Timeout;

    public SsidMonitor(WirelessProvider wirelessProvider, String string, String string2, SsidListener ssidListener, int n, int n2, long l) {
        this.cls_WirelessProvider = wirelessProvider;
        this.cls_LogicalGuid = string;
        this.cls_DesiredSsid = string2;
        this.cls_SsidListener = ssidListener;
        this.cls_PollingInterval = n;
        this.cls_BackoffRate = n2;
        this.cls_Timeout = l > 0L ? System.currentTimeMillis() + l : Long.MAX_VALUE;
        this.cls_Thread = Util.runThread(this.getClass().getSimpleName(), this);
    }

    public void stop() {
        this.cls_Continue = false;
        this.cls_Thread.interrupt();
    }

    public boolean isClosed() {
        return !this.cls_Thread.isAlive();
    }

    public void run() {
        boolean bl = false;
        while (this.cls_Continue && System.currentTimeMillis() < this.cls_Timeout) {
            block7: {
                try {
                    WirelessAssociation wirelessAssociation = this.cls_WirelessProvider.getCurrentAssociation(this.cls_LogicalGuid);
                    if (wirelessAssociation != null && wirelessAssociation.isEnabled() && wirelessAssociation.isAssociated()) {
                        log.debug((Object)("Current ssid is " + wirelessAssociation.getSsid() + ", waiting for " + this.cls_DesiredSsid));
                        if (this.cls_DesiredSsid.equals(wirelessAssociation.getSsid()) && !bl && this.cls_Continue) {
                            this.cls_SsidListener.associated(wirelessAssociation.getSsid());
                            bl = true;
                            this.cls_Continue = false;
                        }
                    }
                }
                catch (Exception exception) {
                    log.error((Object)"ERROR", (Throwable)exception);
                }
                if (!this.cls_Continue) continue;
                try {
                    Thread.sleep(this.cls_PollingInterval);
                }
                catch (Exception exception) {
                    if (!this.cls_Continue) break block7;
                    log.debug((Object)"Thread failed to sleep.", (Throwable)exception);
                }
            }
            this.cls_PollingInterval += this.cls_BackoffRate;
        }
        log.debug((Object)(this.getClass().getSimpleName() + " thread is exiting."));
    }
}

