/*
 * Decompiled with CFR 0.152.
 */
package com.cloudpath.common.os.mac.common.network.airport;

import com.cloudpath.common.command.CommandHandler;
import com.cloudpath.common.command.CommandResponse;
import com.cloudpath.common.os.common.WirelessAssociation;
import com.cloudpath.common.os.common.WirelessProvider;
import com.cloudpath.common.util.FileHandler;
import java.io.IOException;
import org.apache.log4j.Logger;

public abstract class AbstractAirportReader
implements WirelessProvider {
    private static final Logger log = Logger.getLogger(AbstractAirportReader.class);
    public static final String PATH = "/System/Library/PrivateFrameworks/Apple80211.framework/Versions/Current/Resources/airport";
    private final FileHandler cls_FileHandler;
    private final CommandHandler cls_CommandHandler;

    public AbstractAirportReader(FileHandler fileHandler, CommandHandler commandHandler) {
        this.cls_FileHandler = fileHandler;
        this.cls_CommandHandler = commandHandler;
    }

    protected final CommandHandler getCommandHandler() {
        return this.cls_CommandHandler;
    }

    protected final FileHandler getFileHandler() {
        return this.cls_FileHandler;
    }

    public abstract WirelessAssociation getCurrentAssociation(String var1) throws Exception;

    public final void connectToOpenSsid(String string, String string2) {
        String[] stringArray = new String[]{PATH, "-A", "--ssid=" + string2};
        try {
            this.execute(stringArray, true);
        }
        catch (Exception exception) {
            log.debug((Object)("An error occurred while connecting to open ssid " + string2));
        }
    }

    public final void connectToPskSsid(String string, String string2, String string3) {
        if (string3 == null || string3.length() == 0 || "NONE".equalsIgnoreCase(string3)) {
            this.connectToOpenSsid(string, string2);
            return;
        }
        String[] stringArray = new String[]{PATH, "-A", "--ssid=" + string2, "--password=" + string3};
        try {
            this.execute(stringArray, true);
        }
        catch (Exception exception) {
            log.debug((Object)("An error occurred while connecting to psk ssid " + string2));
        }
    }

    public final void connect(String string, String string2, WirelessProvider.WirelessType wirelessType, String string3) {
        if (WirelessProvider.WirelessType.OPEN.equals((Object)wirelessType)) {
            this.connectToOpenSsid(string, string2);
        } else if (WirelessProvider.WirelessType.PSK.equals((Object)wirelessType)) {
            this.connectToPskSsid(string, string2, string3);
        } else {
            this.connectToDot1xSsid(string, string2);
        }
    }

    public abstract void connectToDot1xSsid(String var1, String var2);

    public abstract void disconnect(String var1) throws Exception;

    public abstract void abandon() throws IOException;

    public abstract void associationComplete() throws Exception;

    protected String[] execute(String[] stringArray, boolean bl) throws Exception {
        CommandResponse commandResponse = this.cls_CommandHandler.executeCommand(stringArray);
        commandResponse.waitFor();
        String[] stringArray2 = commandResponse.getOutput();
        if (bl) {
            return stringArray2;
        }
        for (int i = 0; i < 4 && (stringArray2.length == 0 || stringArray2.length == 1 && stringArray2[0].length() == 0); ++i) {
            log.debug((Object)"Airport returned a blank response.  Will retry.");
            Thread.sleep(100L);
            commandResponse = this.cls_CommandHandler.executeCommand(stringArray);
            commandResponse.waitFor();
            stringArray2 = commandResponse.getOutput();
        }
        if (stringArray2.length == 0 || stringArray2.length == 1 && stringArray2[0].length() == 0) {
            log.error((Object)"Unable to get a response from airport.");
        }
        return stringArray2;
    }
}

