/*
 * Decompiled with CFR 0.152.
 */
package com.cloudpath.common.os.mac.common.network;

import com.cloudpath.common.command.CommandHandler;
import com.cloudpath.common.os.common.AbstractNicProvider;
import com.cloudpath.common.os.mac.common.network.ifconfig.IfconfigEntry;
import com.cloudpath.common.os.mac.common.network.ifconfig.IfconfigReader;
import com.cloudpath.common.os.mac.common.network.ifconfig.Ipconfig;
import com.cloudpath.common.os.mac.common.network.networksetup.HardwarePort;
import com.cloudpath.common.os.mac.common.network.networksetup.NetworkSetupReader;
import com.cloudpath.common.os.mac.common.network.networksetup.ServiceInfo;
import com.cloudpath.common.os.mac.common.util.SystemProfilerAirport;
import com.cloudpath.common.pojo.NetworkInterface;
import com.cloudpath.common.util.OsConstants;
import java.util.ArrayList;
import org.apache.log4j.Logger;

public class MacNicProvider
extends AbstractNicProvider {
    private static final Logger log = Logger.getLogger(MacNicProvider.class);
    private static final String MATCH = "en";
    private final CommandHandler cls_CommandHandler;
    private final IfconfigReader cls_IfconfigReader;
    private final NetworkSetupReader cls_NetworkSetupReader;

    public MacNicProvider(CommandHandler commandHandler, NetworkSetupReader networkSetupReader) {
        this.cls_CommandHandler = commandHandler;
        this.cls_IfconfigReader = new IfconfigReader(commandHandler);
        this.cls_NetworkSetupReader = networkSetupReader;
    }

    protected NetworkInterface[] loadAllInterfaces(boolean bl) throws Exception {
        log.debug((Object)"Will load all interfaces.");
        IfconfigEntry[] ifconfigEntryArray = this.cls_IfconfigReader.readAllInterfaces(bl ? null : MATCH);
        log.debug((Object)("Loaded " + ifconfigEntryArray.length + " interface entries."));
        ArrayList<NetworkInterface> arrayList = new ArrayList<NetworkInterface>();
        for (int i = 0; i < ifconfigEntryArray.length; ++i) {
            log.debug((Object)(" - Loading entry 1: " + ifconfigEntryArray[i].getName()));
            String string = ifconfigEntryArray[i].getIpAddress();
            NetworkInterface networkInterface = new NetworkInterface();
            networkInterface.setIndex(i);
            networkInterface.setName(ifconfigEntryArray[i].getName());
            networkInterface.setLogicalGuid(ifconfigEntryArray[i].getName());
            networkInterface.setMacAddress(ifconfigEntryArray[i].getMacAddress());
            networkInterface.setIpAddress(string);
            networkInterface.setDefaultGateway("0.0.0.0");
            networkInterface.setDhcpEnabled(true);
            networkInterface.setDhcpLeaseObtainedTimestamp("" + System.currentTimeMillis());
            networkInterface.setDnsServer("");
            networkInterface.setGatewayMetric(0);
            networkInterface.setInterfaceType(3);
            networkInterface.setManufacturer("Apple");
            networkInterface.setPhysicalCardName(ifconfigEntryArray[i].getName());
            networkInterface.setSubnetMask("0xffffff00");
            HardwarePort hardwarePort = this.cls_NetworkSetupReader.getHardwarePort(ifconfigEntryArray[i].getName());
            if (hardwarePort != null) {
                Object object;
                String string2;
                block20: {
                    if (OsConstants.isMacSnowLeopardOrBefore()) {
                        networkInterface.setName(hardwarePort.getHardwarePort());
                    }
                    log.info((Object)("Hardware port is: " + hardwarePort.getHardwarePort()));
                    if (hardwarePort.isEthernet()) {
                        networkInterface.setInterfaceType(1);
                    } else if (hardwarePort.isAirport()) {
                        networkInterface.setInterfaceType(2);
                        try {
                            string2 = SystemProfilerAirport.getWirelessCardType(this.cls_CommandHandler);
                            if (string2 != null) {
                                string2 = string2.replace("spairport_wireless_card_type_", "");
                                string2 = string2.replace("airport_extreme", "AirPort Extreme");
                            }
                            object = SystemProfilerAirport.getWirelessCardPhys(this.cls_CommandHandler);
                            networkInterface.setPhysicalCardName(string2 + (object != null && ((String)object).length() > 0 ? " - " + (String)object : ""));
                            String string3 = SystemProfilerAirport.getWirelessCardFirmwareVersion(this.cls_CommandHandler);
                            networkInterface.setDriverVersion(string3);
                            if (string3 == null) break block20;
                            if (string3.indexOf(" ") > 0) {
                                networkInterface.setDriverProvider(string3.substring(0, string3.indexOf(" ")));
                                break block20;
                            }
                            networkInterface.setDriverProvider(string3);
                        }
                        catch (Exception exception) {
                            log.error((Object)"An error occurred while reading nic information.  This will only affect reporting.", (Throwable)exception);
                        }
                    } else {
                        networkInterface.setInterfaceType(3);
                    }
                }
                string2 = this.cls_NetworkSetupReader.getNetworkServiceByInterfaceName(networkInterface.getLogicalGuid());
                networkInterface.setServiceName(string2 != null ? string2 : "");
                if (string2 != null) {
                    object = this.cls_NetworkSetupReader.getServiceInfo(string2);
                    if (object != null) {
                        if (networkInterface.getIpAddress() == null || networkInterface.getIpAddress().length() == 0) {
                            networkInterface.setIpAddress(((ServiceInfo)object).getIpAddress());
                        }
                        if (networkInterface.getDefaultGateway() == null || networkInterface.getDefaultGateway().length() == 0 || "0.0.0.0".equals(networkInterface.getDefaultGateway())) {
                            networkInterface.setDefaultGateway(((ServiceInfo)object).getRouter());
                        }
                        networkInterface.setDhcpEnabled(((ServiceInfo)object).isDhcp());
                        if (((ServiceInfo)object).isDhcp()) {
                            networkInterface.setDhcpLeaseObtainedTimestamp(Ipconfig.getDhcpLeaseTime(this.cls_CommandHandler, ifconfigEntryArray[i].getName()));
                        } else {
                            networkInterface.setDhcpLeaseObtainedTimestamp("0");
                        }
                        networkInterface.setSubnetMask(((ServiceInfo)object).getSubnetMask());
                    } else {
                        log.debug((Object)"Service Info for Port is null.");
                    }
                } else {
                    log.warn((Object)("ServiceName could not be located for '" + networkInterface.getLogicalGuid() + "'."));
                }
            } else {
                log.warn((Object)"Port is null.");
            }
            arrayList.add(networkInterface);
        }
        NetworkInterface[] networkInterfaceArray = new NetworkInterface[arrayList.size()];
        arrayList.toArray(networkInterfaceArray);
        return networkInterfaceArray;
    }
}

