/*
 * Decompiled with CFR 0.152.
 */
package com.cloudpath.common.os.mac.common.ioreg;

import com.cloudpath.common.command.CommandHandler;
import com.cloudpath.common.command.CommandResponse;
import com.cloudpath.common.os.mac.common.ioreg.IoRegClass;
import com.cloudpath.common.os.mac.common.network.ifconfig.IfconfigEntry;
import com.cloudpath.common.os.mac.common.network.ifconfig.IfconfigReader;
import com.cloudpath.common.util.OsConstants;
import com.cloudpath.common.util.Util;
import java.io.IOException;
import java.util.HashMap;
import org.apache.log4j.Logger;

public class IoRegController {
    private static final Logger log = Logger.getLogger(IoRegController.class);
    public static final String UUID_MAC_ADDRESS_MASK = "00000000-0000-1000-8000-";
    private static HashMap<String, IoRegClass> MAPPING = new HashMap();
    public static final String SECTION_IO_PLATFORM_EXPERT_DEVICE = "IOPlatformExpertDevice";
    public static final String IO_PLATFORM_UUID = "IOPlatformUUID";
    public static final String IO_SERIAL_NUMBER = "serial-number";
    public static final String IO_MANUFACTURER = "manufacturer";
    public static final String IO_MODEL = "model";
    private static String SYSTEM_ID = null;

    public static final IoRegClass getIoRegClass(CommandHandler commandHandler, String string) throws IOException {
        if (MAPPING.get(string) != null) {
            return MAPPING.get(string);
        }
        String[] stringArray = OsConstants.isMacTigerOrBefore() ? new String[]{"ioreg", "-w", "0", "-c", string} : new String[]{"ioreg", "-w", "0", "-rd1", "-c", string};
        CommandResponse commandResponse = commandHandler.executeCommand(stringArray);
        commandResponse.waitFor();
        String string2 = Util.join(commandResponse.getError());
        String string3 = Util.join(commandResponse.getOutput());
        if (string2 != null && string2.length() > 0) {
            log.error((Object)("The following error was returned while querying system Id: " + string2));
        } else if (string3 != null && string3.length() > 0) {
            return IoRegController.setSectionOutput(string, string3);
        }
        return new IoRegClass("");
    }

    public static void clearCache() {
        MAPPING.clear();
    }

    protected static IoRegClass setSectionOutput(String string, String string2) {
        IoRegClass ioRegClass = new IoRegClass(string2);
        MAPPING.put(string, ioRegClass);
        return ioRegClass;
    }

    public static final void clearSystemId_ForTest() {
        SYSTEM_ID = null;
    }

    public static final String getSystemId(CommandHandler commandHandler) throws Exception {
        IfconfigEntry ifconfigEntry;
        if (SYSTEM_ID != null && SYSTEM_ID.length() > 0) {
            return SYSTEM_ID;
        }
        String string = IoRegController.getIoRegClass(commandHandler, SECTION_IO_PLATFORM_EXPERT_DEVICE).getValue(IO_PLATFORM_UUID);
        if ((string == null || string.length() == 0) && (ifconfigEntry = new IfconfigReader(commandHandler).readInterface("en0")) != null) {
            String string2 = ifconfigEntry.getMacAddress();
            if (string2 != null) {
                string2 = string2.replace(":", "").toUpperCase();
            }
            string = UUID_MAC_ADDRESS_MASK + string2;
        }
        SYSTEM_ID = string;
        return string;
    }

    public static final String getOsSerialNumber(CommandHandler commandHandler) throws Exception {
        return IoRegController.getIoRegClass(commandHandler, SECTION_IO_PLATFORM_EXPERT_DEVICE).getValue(IO_SERIAL_NUMBER);
    }

    public static final String getComputerManufacturer(CommandHandler commandHandler) throws Exception {
        return IoRegController.getIoRegClass(commandHandler, SECTION_IO_PLATFORM_EXPERT_DEVICE).getValue(IO_MANUFACTURER, "Apple Inc.");
    }

    public static final String getComputerModel(CommandHandler commandHandler) throws Exception {
        return IoRegController.getIoRegClass(commandHandler, SECTION_IO_PLATFORM_EXPERT_DEVICE).getValue(IO_MODEL);
    }

    public static final String getComputerModelName(CommandHandler commandHandler) throws Exception {
        String string = IoRegController.getIoRegClass(commandHandler, SECTION_IO_PLATFORM_EXPERT_DEVICE).getValue(IO_MODEL);
        if (string != null && string.length() > 3) {
            string = string.substring(0, string.length() - 3);
        }
        return string;
    }
}

