/*
 * Decompiled with CFR 0.152.
 */
package com.cloudpath.common.os.mac.common;

import com.cloudpath.common.command.CommandHandler;
import com.cloudpath.common.command.CommandResponse;
import com.cloudpath.common.compare.VersionCompare;
import com.cloudpath.common.os.mac.common.ioreg.IoRegClass;
import com.cloudpath.common.os.mac.common.ioreg.IoRegController;
import com.cloudpath.common.util.FileHandler;
import com.cloudpath.common.util.FileUtil;
import com.cloudpath.common.util.Util;
import java.io.File;
import java.io.IOException;
import org.apache.log4j.Logger;

public class MacUtil {
    private static final Logger log = Logger.getLogger(MacUtil.class);
    public static final String USER_PREFERENCES_DIRECTORY = "/Library/Preferences";
    public static final String USER_PREFERENCES_BYHOST_DIRECTORY = "/Library/Preferences/ByHost";
    public static final String SYSTEM_PREFERENCES_DIRECTORY = "/Library/Preferences";
    public static final String BYHOST_DIRECTORY = "/Library/Preferences/ByHost";
    public static final String IO_PLATFORM_UUID = "IOPlatformUUID";
    private static String SYSTEM_ID = null;
    public static final String REGEX_PATTERN_UUID = "^(\\{{0,1}([0-9a-fA-F]){8}-([0-9a-fA-F]){4}-([0-9a-fA-F]){4}-([0-9a-fA-F]){4}-([0-9a-fA-F]){12}\\}{0,1})$";

    public static final String parseSetting(String string, String string2, String string3) {
        int n = string.indexOf(string2);
        if (n >= 0) {
            n += string2.length();
            int n2 = -1;
            if (string3 != null && string3.length() > 0) {
                n2 = string.indexOf(string3, n);
            }
            if (n2 < 0) {
                n2 = string.length();
            }
            return string.substring(n, n2);
        }
        return "";
    }

    public static final void runApplescript(CommandHandler commandHandler, FileHandler fileHandler, String string) throws IOException {
        File file = File.createTempFile("xpc_", ".applescript");
        fileHandler.writeFile(file, string);
        commandHandler.executeCommand(new String[]{"osascript", file.getAbsolutePath()}).waitFor();
        if (!file.delete()) {
            file.deleteOnExit();
        }
    }

    public static final void openSoftwareUpdateGui(CommandHandler commandHandler) {
        String[] stringArray = new String[]{"open", "/System/Library/CoreServices/Software Update.app"};
        try {
            CommandResponse commandResponse = commandHandler.executeCommand(stringArray);
            commandResponse.waitFor();
        }
        catch (IOException iOException) {
            log.warn((Object)"An error occurred while opening software updates.", (Throwable)iOException);
        }
    }

    public static final String getSystemSoftwareVersion() {
        return System.getProperty("os.version");
    }

    public static final long getSystemSoftwarePatchLevel() {
        return MacUtil.getSystemSoftwarePatchLevel(MacUtil.getSystemSoftwareVersion());
    }

    public static final long getSystemSoftwarePatchLevel(String string) {
        long[] lArray = VersionCompare.getSplitVersion(string);
        if (lArray == null || lArray.length <= 2) {
            return 0L;
        }
        return lArray[2];
    }

    public static final void killAllInstances(CommandHandler commandHandler, String string) {
        String[] stringArray = new String[]{"killall", string};
        try {
            CommandResponse commandResponse = commandHandler.executeCommand(stringArray);
            commandResponse.waitFor();
        }
        catch (IOException iOException) {
            log.warn((Object)("An error occurred while kill application '" + string + "'."), (Throwable)iOException);
        }
    }

    public static final String[] getProcesses(CommandHandler commandHandler) throws IOException {
        CommandResponse commandResponse = commandHandler.executeCommand(new String[]{"ps", "-A", "-o", "command="});
        commandResponse.waitFor();
        String[] stringArray = commandResponse.getOutput();
        return stringArray;
    }

    public static final String getSystemId(CommandHandler commandHandler) throws Exception {
        if (SYSTEM_ID != null) {
            return SYSTEM_ID;
        }
        String string = null;
        String[] stringArray = new String[]{"ioreg", "-rd1", "-c", "IOPlatformExpertDevice"};
        CommandResponse commandResponse = commandHandler.executeCommand(stringArray);
        commandResponse.waitFor();
        String string2 = Util.join(commandResponse.getError());
        String string3 = Util.join(commandResponse.getOutput());
        if (string2 != null && string2.length() > 0) {
            log.error((Object)("The following error was returned while querying system Id: " + string2));
        } else if (string3 != null && string3.length() > 0) {
            IoRegClass ioRegClass = new IoRegClass(string3);
            string = ioRegClass.getValue(IO_PLATFORM_UUID);
        }
        if (string == null || string.length() == 0) {
            throw new Exception("System id returned invalid value '" + string + "' with output:\n" + string3 + "\nAnd error:\n" + string2 + ".");
        }
        log.info((Object)("The System ID is '" + string + "'."));
        SYSTEM_ID = string;
        return string;
    }

    public static final String formatSystemIdForByHost(String string) {
        String string2 = "00000000-0000-1000-8000-";
        if (string == null) {
            log.error((Object)"The System ID is null.");
            return "";
        }
        if (string.startsWith(string2)) {
            if (string.length() >= 24) {
                log.info((Object)"The System ID is based on the mac address.");
                return string.substring(24, string.length()).toLowerCase();
            }
            log.error((Object)("The System ID '" + string + "' is not a valid format."));
            return "";
        }
        log.info((Object)"The System ID is based on a GUID.");
        return string.toUpperCase();
    }

    public static final boolean isUUID(String string) {
        return string != null && string.matches(REGEX_PATTERN_UUID);
    }

    public static final boolean openSystemPrefsDateAndTime(CommandHandler commandHandler) {
        try {
            commandHandler.executeCommand(new String[]{"/usr/bin/open", "/System/Library/PreferencePanes/DateAndTime.prefPane"});
            return true;
        }
        catch (IOException iOException) {
            log.error((Object)"Exception while opening system preferences to Date & Time.", (Throwable)iOException);
            return false;
        }
    }

    public static final File getFileFromUserPreferences(String string) {
        return FileUtil.getUserFile("/Library/Preferences/" + string + ".plist");
    }

    public static final File getFileFromSystemPreferences(String string) {
        return FileUtil.getUserFile("/Library/Preferences/" + string + ".plist");
    }

    public static final File getFileFromUserPreferencesByHost(CommandHandler commandHandler, String string) {
        try {
            String string2 = IoRegController.getSystemId(commandHandler);
            string2 = MacUtil.formatSystemIdForByHost(string2);
            return FileUtil.getUserFile("/Library/Preferences/ByHost/" + string + "." + string2 + ".plist");
        }
        catch (Exception exception) {
            File file = new File("/Library/Preferences/ByHost");
            if (file.exists() && file.isDirectory()) {
                File[] fileArray = file.listFiles();
                for (int i = 0; i < fileArray.length; ++i) {
                    if (!fileArray[i].getName().startsWith(string + ".") || !fileArray[i].getName().endsWith(".plist")) continue;
                    return fileArray[i];
                }
            }
            return null;
        }
    }

    public static final boolean openSystemPrefs(CommandHandler commandHandler, String string) {
        try {
            commandHandler.executeCommand(new String[]{"/usr/bin/open", "/System/Library/PreferencePanes/" + string + ".prefPane"});
            return true;
        }
        catch (IOException iOException) {
            log.error((Object)"Exception while opening Software Update system preferences.", (Throwable)iOException);
            return false;
        }
    }

    public static final boolean isPharosPackageInstalled(String string) {
        File file = new File("/Library/Application Support/Pharos/Packages/", string);
        log.debug((Object)("Will check if Pharos package '" + string + "' exists by checking for file '" + file.getAbsolutePath() + "'."));
        boolean bl = file.exists();
        log.debug((Object)("  - " + (bl ? "Pharos package exists." : "Pharos package does not exist.")));
        return bl;
    }
}

