/*
 * Decompiled with CFR 0.152.
 */
package com.cloudpath.common.os.mac.common;

import com.cloudpath.common.command.CommandHandler;
import com.cloudpath.common.command.CommandResponse;
import com.cloudpath.common.os.common.ApplicationProvider;
import com.cloudpath.common.os.common.NicProvider;
import com.cloudpath.common.os.common.OsProvider;
import com.cloudpath.common.os.common.WirelessProvider;
import com.cloudpath.common.os.mac.common.ioreg.IoRegController;
import com.cloudpath.common.os.mac.common.network.MacNicProvider;
import com.cloudpath.common.os.mac.common.network.networksetup.NetworkSetupReader;
import com.cloudpath.common.os.mac.common.provider.MacApplicationProvider;
import com.cloudpath.common.os.mac.leopard.cmd.Maccmd;
import com.cloudpath.common.os.mac.leopard.network.airport.LeopardAirportReader;
import com.cloudpath.common.os.mac.leopard.network.networksetup.LeopardNetworkSetupReader;
import com.cloudpath.common.os.mac.snowleopard.network.airport.SnowLeopardAirportReader;
import com.cloudpath.common.os.mac.snowleopard.network.networksetup.SnowLeopardNetworkSetupReader;
import com.cloudpath.common.os.mac.tiger.network.airport.TigerAirportReader;
import com.cloudpath.common.os.mac.tiger.network.networksetup.TigerNetworkSetupReader;
import com.cloudpath.common.pojo.NetworkInterface;
import com.cloudpath.common.util.FileHandler;
import com.cloudpath.common.util.OsConstants;
import com.cloudpath.common.util.OsInfo;
import com.cloudpath.common.util.Util;
import java.io.File;
import java.util.UUID;
import org.apache.log4j.Logger;

public abstract class MacOsProvider
implements OsProvider {
    private static final Logger log = Logger.getLogger(MacOsProvider.class);
    private final OsInfo cls_OsInfo = OsConstants.getOsInfo();
    private final FileHandler cls_FileHandler;
    private final CommandHandler cls_CommandHandler;
    private final NicProvider cls_NicProvider;
    private final WirelessProvider cls_WirelessProvider;
    private final NetworkSetupReader cls_NetworkSetupReader;
    private final MacApplicationProvider cls_ApplicationProvider;
    private final Maccmd cls_Maccmd;
    private static String cls_Arch = null;

    public MacOsProvider(FileHandler fileHandler, CommandHandler commandHandler) {
        this.cls_FileHandler = fileHandler;
        this.cls_CommandHandler = commandHandler;
        this.cls_Maccmd = new Maccmd(commandHandler);
        this.cls_ApplicationProvider = new MacApplicationProvider(fileHandler, commandHandler, this.cls_Maccmd);
        if (OsConstants.isMacTigerOrBefore()) {
            this.cls_WirelessProvider = new TigerAirportReader(fileHandler, commandHandler);
            this.cls_NetworkSetupReader = new TigerNetworkSetupReader(commandHandler);
        } else if (OsConstants.isMacLeopard()) {
            this.cls_WirelessProvider = new LeopardAirportReader(commandHandler, this.cls_Maccmd);
            this.cls_NetworkSetupReader = new LeopardNetworkSetupReader(commandHandler);
        } else {
            this.cls_NetworkSetupReader = new SnowLeopardNetworkSetupReader(commandHandler, this.cls_Maccmd);
            this.cls_WirelessProvider = new SnowLeopardAirportReader(commandHandler, (SnowLeopardNetworkSetupReader)this.cls_NetworkSetupReader);
        }
        this.cls_NicProvider = new MacNicProvider(commandHandler, this.cls_NetworkSetupReader);
    }

    public OsInfo getOsInfo() {
        return this.cls_OsInfo;
    }

    public FileHandler getFileHandler() {
        return this.cls_FileHandler;
    }

    public CommandHandler getCommandHandler() {
        return this.cls_CommandHandler;
    }

    public NicProvider getNicProvider() {
        return this.cls_NicProvider;
    }

    public WirelessProvider getWirelessProvider() {
        return this.cls_WirelessProvider;
    }

    public NetworkSetupReader getNetworkSetupReader() {
        return this.cls_NetworkSetupReader;
    }

    public ApplicationProvider getApplicationProvider() {
        return this.cls_ApplicationProvider;
    }

    public final Maccmd getMaccmd() {
        return this.cls_Maccmd;
    }

    public void openBrowser(String string) throws Exception {
        File file = new File("/Applications/Safari.app");
        if (file.exists()) {
            log.debug((Object)("Using Safari to open URL '" + string + "' using '" + file.getAbsolutePath() + "'."));
            CommandResponse commandResponse = this.getCommandHandler().executeCommand(new String[]{"open", "-a", file.getAbsolutePath(), string});
            commandResponse.waitFor();
            log.info((Object)("OUTPUT: " + Util.join(commandResponse.getOutput()) + Util.join(commandResponse.getError())));
        } else {
            File file2 = new File("/Applications/Firefox.app");
            if (file2.exists()) {
                log.debug((Object)"Using Firefox to open URL.");
                CommandResponse commandResponse = this.getCommandHandler().executeCommand(new String[]{"open", "-a", file2.getAbsolutePath(), string});
                commandResponse.waitFor();
            } else {
                log.debug((Object)"Punting to the OS to decide how to open the URL.");
                CommandResponse commandResponse = this.getCommandHandler().executeCommand(new String[]{"open", string});
                commandResponse.waitFor();
            }
        }
    }

    public abstract String generateSupportFile();

    protected void handle(StringBuffer stringBuffer, String[] stringArray) {
        stringBuffer.append("\n\n----------------------------------------------------\n");
        stringBuffer.append("\nWill execute: " + Util.join(stringArray).replace("\n", " ") + "\n");
        try {
            CommandResponse commandResponse = this.cls_CommandHandler.executeCommand(stringArray);
            commandResponse.waitFor();
            String[] stringArray2 = commandResponse.getOutput();
            stringBuffer.append("-- OUT:\n");
            for (int i = 0; i < stringArray2.length; ++i) {
                stringBuffer.append(stringArray2[i]);
                stringBuffer.append('\n');
            }
            String[] stringArray3 = commandResponse.getError();
            if (stringArray3.length > 0 && stringArray3[0] != null && stringArray3[0].length() > 0) {
                stringBuffer.append("-- ERROR:\n");
                for (int i = 0; i < stringArray3.length; ++i) {
                    stringBuffer.append(stringArray3[i]);
                    stringBuffer.append('\n');
                }
            }
        }
        catch (Exception exception) {
            log.error((Object)"Error while generating support file.", (Throwable)exception);
            stringBuffer.append("Error while generating support file: \n" + Util.getStackTrace(exception));
        }
        stringBuffer.append("----------------------------------------------------");
    }

    public abstract void runScript(String var1, boolean var2) throws Exception;

    public void renewIp(NetworkInterface networkInterface) {
        try {
            this.cls_NetworkSetupReader.setNetworkServiceState(networkInterface.getName(), true);
        }
        catch (Exception exception) {
            log.error((Object)("An error occurred while renewing ip for '" + networkInterface.getName() + "'."), (Throwable)exception);
        }
        try {
            this.cls_NetworkSetupReader.setNetworkServiceState(networkInterface.getName(), true);
        }
        catch (Exception exception) {
            log.error((Object)("An error occurred while renewing ip for '" + networkInterface.getName() + "'."), (Throwable)exception);
        }
    }

    public String getSystemId() {
        try {
            return IoRegController.getSystemId(this.cls_CommandHandler);
        }
        catch (Exception exception) {
            log.error((Object)"Unable to read system ID.", (Throwable)exception);
            return UUID.randomUUID().toString();
        }
    }

    public String getComputerManufacturer() {
        try {
            return IoRegController.getComputerManufacturer(this.cls_CommandHandler);
        }
        catch (Exception exception) {
            log.error((Object)"Unable to read computer manufacturer.", (Throwable)exception);
            return "[Apple]";
        }
    }

    public String getComputerModel() {
        try {
            return IoRegController.getComputerModel(this.cls_CommandHandler);
        }
        catch (Exception exception) {
            log.error((Object)"Unable to read computer model.", (Throwable)exception);
            return "[Unknown]";
        }
    }

    public String getComputerCpuName() {
        if (cls_Arch == null) {
            try {
                CommandResponse commandResponse = this.cls_CommandHandler.executeCommand(new String[]{"/usr/bin/arch"});
                commandResponse.waitFor();
                cls_Arch = Util.join(commandResponse.getOutput());
            }
            catch (Exception exception) {
                log.error((Object)"Error occurred while getting cpu name.", (Throwable)exception);
            }
        }
        return cls_Arch != null ? cls_Arch : "";
    }

    public String getComputerInstalledRam() {
        return "[Unknown]";
    }

    public boolean isOnDomain() {
        return false;
    }

    public String getOsServicePack() {
        MacOsProvider macOsProvider = this;
        return macOsProvider.cls_OsInfo.getMacUpdateLevel();
    }

    public String getOsBits() {
        String string = this.getComputerCpuName();
        if (string == null || string.length() == 0) {
            return "";
        }
        if (string.contains("64")) {
            return "64";
        }
        return "32";
    }
}

