/*
 * Decompiled with CFR 0.152.
 */
package com.cloudpath.common.os.mac.common;

import com.cloudpath.common.command.CommandHandlerImpl;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public class FireFoxProxy {
    private static final Logger log = Logger.getLogger(FireFoxProxy.class);

    private boolean isFirefoxProfileProxySettingSystem(String string) {
        String string2 = string + "/prefs.js";
        boolean bl = false;
        log.info((Object)("Looking at : " + string2));
        File file = new File(string2);
        try {
            BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
            String string3 = null;
            while ((string3 = bufferedReader.readLine()) != null) {
                if (!string3.contains("network.proxy.type")) continue;
                Pattern pattern = Pattern.compile("\\d+");
                Matcher matcher = pattern.matcher(string3);
                if (!matcher.find()) {
                    log.error((Object)"Unable to read the proxy type from the string!");
                    continue;
                }
                String string4 = string3.substring(matcher.start(), matcher.end());
                if (!string4.equals("5")) continue;
                bl = true;
            }
            bufferedReader.close();
        }
        catch (IOException iOException) {
            log.error((Object)iOException);
        }
        return bl;
    }

    public boolean isFirefoxInstalled() {
        String string = System.getProperty("user.home");
        String string2 = string + "/Library/Application Support/Firefox";
        String string3 = string2 + "/profiles.ini";
        File file = new File(string3);
        return file.exists();
    }

    public boolean areFirefoxProxySettingsSystem() {
        String string = System.getProperty("user.home");
        String string2 = string + "/Library/Application Support/Firefox";
        return this.areFirefoxProxySettingsSystemInDir(string2);
    }

    public boolean areFirefoxProxySettingsSystemInDir(String string) {
        boolean bl = false;
        String string2 = "";
        String string3 = string + "/profiles.ini";
        log.info((Object)("Firefox profile.ini is at : " + string3));
        File file = new File(string3);
        try {
            BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
            String string4 = null;
            while ((string4 = bufferedReader.readLine()) != null) {
                if ((string4 = string4.trim()).startsWith("[Profile")) {
                    bl = true;
                    string4 = string4.substring(1);
                    string2 = string4 = string4.substring(0, string4.length() - 1);
                    log.info((Object)("Working with profile : " + string2));
                    continue;
                }
                if (!bl || !string4.startsWith("Path=")) continue;
                string4 = string4.substring(5);
                log.info((Object)("Checking profile " + string2 + " with path of " + string4));
                if (this.isFirefoxProfileProxySettingSystem(string + "/" + string4)) continue;
                bufferedReader.close();
                return false;
            }
            bufferedReader.close();
        }
        catch (IOException iOException) {
            log.error((Object)iOException);
            return false;
        }
        return true;
    }

    private void setFirefoxProfileProxySettingSystem(String string) {
        String string2 = string + "/prefs.js";
        boolean bl = false;
        CommandHandlerImpl commandHandlerImpl = new CommandHandlerImpl();
        File file = new File(string2);
        File file2 = new File("/tmp/firefoxchanges.tmp");
        try {
            BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
            BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file2));
            String string3 = null;
            while ((string3 = bufferedReader.readLine()) != null) {
                if (string3.contains("network.proxy.type")) {
                    bl = true;
                    bufferedWriter.append("user_pref(\"network.proxy.type\", 5);\n");
                    continue;
                }
                bufferedWriter.append(string3 + "\n");
            }
            if (!bl) {
                bufferedWriter.append("user_pref(\"network.proxy.type\", 5);\n");
            }
            bufferedWriter.close();
            bufferedReader.close();
            String[] stringArray = new String[]{"cp", "/tmp/firefoxchanges.tmp", string2};
            commandHandlerImpl.executeCommand(stringArray).waitFor();
        }
        catch (IOException iOException) {
            log.error((Object)iOException);
        }
    }

    public void changeFirefoxProxySettingsToSystem() {
        String string = System.getProperty("user.home");
        String string2 = string + "/Library/Application Support/Firefox";
        this.changeFirefoxProxySettingsInDirToSystem(string2);
    }

    public void changeFirefoxProxySettingsInDirToSystem(String string) {
        String string2 = string + "/profiles.ini";
        boolean bl = false;
        String string3 = "";
        CommandHandlerImpl commandHandlerImpl = new CommandHandlerImpl();
        log.info((Object)("Firefox profile.ini is at : " + string2));
        File file = new File(string2);
        try {
            BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
            String string4 = null;
            while ((string4 = bufferedReader.readLine()) != null) {
                if ((string4 = string4.trim()).startsWith("[Profile")) {
                    bl = true;
                    string4 = string4.substring(1);
                    string3 = string4 = string4.substring(0, string4.length() - 1);
                    log.info((Object)("Working with profile : " + string3));
                    continue;
                }
                if (!bl || !string4.startsWith("Path=")) continue;
                string4 = string4.substring(5);
                log.info((Object)("Updating profile " + string3 + " with path of " + string4));
                this.setFirefoxProfileProxySettingSystem(string + "/" + string4);
            }
            bufferedReader.close();
        }
        catch (IOException iOException) {
            log.error((Object)iOException);
        }
    }
}

