/*
 * Decompiled with CFR 0.152.
 */
package com.cloudpath.common.dispatch;

import com.cloudpath.common.dispatch.AsyncHandler;
import com.cloudpath.common.dispatch.DispatchRequest;
import com.cloudpath.common.dispatch.DispatchResponse;
import com.cloudpath.common.dispatch.DoneRequest;
import com.cloudpath.common.dispatch.ErrorRequest;
import com.cloudpath.common.dispatch.RequestHandler;
import com.cloudpath.common.dispatch.ResponseHandler;
import com.cloudpath.common.dispatch.StartOverRequest;
import com.cloudpath.common.util.Util;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.log4j.Logger;

public class Dispatcher
implements Runnable,
AsyncHandler {
    private static final Logger log = Logger.getLogger(Dispatcher.class);
    private final ResponseHandler cls_ResponseHandler;
    private final RequestHandler cls_RequestHandler;
    private final BlockingQueue<Object> cls_Queue = new LinkedBlockingQueue<Object>();
    private final Thread cls_Thread;
    private boolean cls_Continue = true;
    private DispatchProcessor cls_LastRequestProcessor;
    private DispatchProcessor cls_LastSelectionProcessor;
    private long cls_ThreadCounter = 0L;
    private ThreadGroup cls_WorkerThreadGroup = new ThreadGroup("WorkerThreads");
    private int cls_ErrorCount;

    public Dispatcher(ResponseHandler responseHandler, RequestHandler requestHandler) {
        this.cls_ResponseHandler = responseHandler;
        this.cls_RequestHandler = requestHandler;
        this.cls_Thread = new Thread(this);
        this.cls_Thread.setName("RequestDispatcher");
        this.cls_Thread.setDaemon(true);
        this.cls_Thread.start();
    }

    public void processAsync(DispatchResponse dispatchResponse) {
        log.debug((Object)(this.getClass().getSimpleName() + " received selection " + dispatchResponse + " on thread " + Thread.currentThread()));
        if (dispatchResponse != null) {
            this.cls_Queue.offer(dispatchResponse);
        }
    }

    public void processAsync(DispatchRequest dispatchRequest) {
        log.debug((Object)(this.getClass().getSimpleName() + " received (processAsync) request " + dispatchRequest + " on thread " + Thread.currentThread()));
        if (dispatchRequest != null) {
            if (dispatchRequest instanceof StartOverRequest) {
                log.warn((Object)"Dispatcher received a startOverRequest.", (Throwable)new Exception("StartOverRequest Source"));
                DispatchRequest dispatchRequest2 = this.cls_ResponseHandler.processStartOver((StartOverRequest)dispatchRequest);
                log.info((Object)("Dispatcher got response: " + dispatchRequest2));
                if (dispatchRequest2 != null) {
                    this.cls_Queue.offer(dispatchRequest2);
                }
            } else {
                this.cls_Queue.offer(dispatchRequest);
            }
        }
    }

    public void waitFor() throws Exception {
        this.cls_Thread.join();
    }

    public void stop() {
        log.warn((Object)"Dispatcher is stopping...");
        this.cls_Continue = false;
        this.cls_Thread.interrupt();
        try {
            this.cls_Thread.join();
        }
        catch (Exception exception) {
            log.error((Object)"Exception while joining thread.", (Throwable)exception);
        }
        log.warn((Object)"Dispatcher has stopped.");
    }

    public void run() {
        String string = this.getClass().getSimpleName();
        log.info((Object)(string + " starting."));
        long l = 0L;
        while (this.cls_Continue) {
            long l2 = ++l;
            log.debug((Object)(string + " - " + l2 + " - Will block for next object."));
            log.debug((Object)(string + " - " + l2 + " - Active thread count: " + this.cls_WorkerThreadGroup.activeCount()));
            try {
                Object object = this.cls_Queue.take();
                log.info((Object)("DISPATCHER - TAKEN FROM QUEUE: " + object));
                if (object == null) continue;
                if (object instanceof DoneRequest) {
                    log.info((Object)(string + " - " + l2 + " - Received a DoneRequest.  Will exit."));
                    this.cls_Continue = false;
                    continue;
                }
                if (object instanceof DispatchResponse && this.cls_LastSelectionProcessor != null && this.cls_LastSelectionProcessor.isAlive()) {
                    log.info((Object)("DISPATCHER: Abandoning last request processor " + this.cls_LastSelectionProcessor));
                    this.cls_LastSelectionProcessor.abandon();
                } else if (object instanceof DispatchRequest && this.cls_LastRequestProcessor != null && this.cls_LastRequestProcessor.isAlive()) {
                    log.info((Object)("DISPATCHER: Abandoning last request processor " + this.cls_LastRequestProcessor));
                    this.cls_LastRequestProcessor.abandon();
                }
                DispatchProcessor dispatchProcessor = new DispatchProcessor("[" + this.cls_ThreadCounter++ + "] " + object.toString(), object);
                Util.runThread(this.cls_WorkerThreadGroup, "RequestDispatcherWorkerThread-" + this.cls_ThreadCounter++, dispatchProcessor);
                if (object instanceof DispatchResponse) {
                    this.cls_LastSelectionProcessor = dispatchProcessor;
                } else if (object instanceof DispatchRequest) {
                    this.cls_LastRequestProcessor = dispatchProcessor;
                }
                log.info((Object)("DISPATCHER:\n          LastSelection is now: " + this.cls_LastSelectionProcessor + "\n          LastRequest is now: " + this.cls_LastRequestProcessor));
            }
            catch (InterruptedException interruptedException) {
                if (!this.cls_Continue) continue;
                log.warn((Object)(string + " - " + l2 + " - Thread was interrupted."), (Throwable)interruptedException);
            }
        }
        log.info((Object)(string + "  exiting."));
    }

    public class DispatchProcessor
    implements Runnable {
        private final String cls_LogTag;
        private final Object cls_Object;
        private boolean cls_WasAbandoned = false;
        private boolean cls_IsAlive = true;

        public DispatchProcessor(String string, Object object) {
            this.cls_LogTag = string;
            this.cls_Object = object;
        }

        public boolean isAlive() {
            return this.cls_IsAlive;
        }

        public void abandon() {
            this.cls_WasAbandoned = true;
        }

        public void run() {
            block8: {
                try {
                    this.debug("Done blocking for object. Will process " + this.cls_Object + ".");
                    if (this.cls_Object instanceof DispatchRequest) {
                        this.debug("Sending request to gui.");
                        Dispatcher.this.cls_RequestHandler.addRequest((DispatchRequest)this.cls_Object);
                    } else if (this.cls_Object instanceof DispatchResponse) {
                        this.debug("Sending selection to workflow.");
                        log.info((Object)("WILL SEND: " + this.cls_Object + "\n\n"));
                        DispatchRequest dispatchRequest = Dispatcher.this.cls_ResponseHandler.addResponse((DispatchResponse)this.cls_Object);
                        log.info((Object)("Sent: " + this.cls_Object + "\nGot Back: " + dispatchRequest + "\n\n"));
                        if (this.cls_WasAbandoned) {
                            this.debug("Workflow returned abandoned request " + dispatchRequest + ".  Will discard.");
                        } else {
                            this.debug("Workflow returned request: " + dispatchRequest + ".  Will put in queue.");
                            if (dispatchRequest != null) {
                                Dispatcher.this.cls_Queue.offer(dispatchRequest);
                            }
                        }
                    }
                }
                catch (Throwable throwable) {
                    log.error((Object)("An error occurred in dispatcher worker thread (Processor" + this.cls_LogTag + ")."), throwable);
                    Dispatcher.this.cls_ErrorCount++;
                    if (Dispatcher.this.cls_ErrorCount >= 10) break block8;
                    Dispatcher.this.cls_Queue.offer(new ErrorRequest("Error occurred.", "An unexpected error occurred.<br><br>" + Util.getStackTrace(throwable), false, false));
                }
            }
            this.cls_IsAlive = false;
        }

        public String toString() {
            return "[Processor id=" + this.cls_LogTag + "]";
        }

        private void debug(String string) {
            log.debug((Object)("Processor" + this.cls_LogTag + " - " + string));
        }
    }
}

