/*
 * Decompiled with CFR 0.152.
 */
package com.cloudpath.common.command;

import com.cloudpath.common.util.Util;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommandResponse {
    private static final Logger log = Logger.getLogger(CommandResponse.class);
    public static final String NEW_LINE = System.getProperty("line.separator");
    private static final String PASSWORD = "Password:";
    private static final int OUTPUT = 0;
    private static final int ERROR = 1;
    private static final String ANNOYING = "cp: /Library/Preferences/SystemConfiguration/preferences.plist.old: Permission denied\n";
    private final String cls_CommandLine;
    private final Process cls_Process;
    private final String cls_Password;
    private int cls_ExitCode = -1;
    private final Thread cls_BlockingThread;
    private final Thread cls_ReadingThread;
    private IOException cls_Exception = null;
    private LinkedBlockingQueue<String> cls_OutputQueue = new LinkedBlockingQueue();
    private LinkedBlockingQueue<String> cls_ErrorQueue = new LinkedBlockingQueue();
    private String[] cls_Output = null;
    private String[] cls_Error = null;
    private String cls_LastOutput = "";
    private String cls_LastError = "";

    public CommandResponse(String string, Process process, final int n, String string2) throws IOException {
        this.cls_CommandLine = string;
        this.cls_Process = process;
        this.cls_Password = string2;
        this.cls_BlockingThread = Util.runThread("Command", new Runnable(){

            public void run() {
                try {
                    Thread.sleep(n);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        });
        if (process != null) {
            if (string2 != null && string2.length() > 0) {
                this.setSudoPassword(process, string2);
            }
            this.cls_ReadingThread = Util.runThread("RunCommand", new Runnable(){

                public void run() {
                    CommandResponse.this.handleProcess();
                }
            });
        } else {
            this.cls_ReadingThread = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSudoPassword(Process process, String string) {
        OutputStream outputStream = null;
        try {
            try {
                outputStream = process.getOutputStream();
                outputStream.write(string.getBytes());
                outputStream.write(10);
                outputStream.flush();
            }
            catch (IOException iOException) {
                Object var6_5 = null;
            }
            Object var6_4 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            throw throwable;
        }
    }

    public int getExitValue() {
        return this.cls_ExitCode;
    }

    protected void setExitValue(int n) {
        this.cls_ExitCode = n;
        this.cls_BlockingThread.interrupt();
    }

    public BlockingQueue<String> getOutputQueue() {
        return this.cls_OutputQueue;
    }

    public BlockingQueue<String> getErrorQueue() {
        return this.cls_OutputQueue;
    }

    public String[] getOutput() {
        return this.cls_Output != null ? this.cls_Output : this.getFromQueue(this.cls_OutputQueue);
    }

    public String[] getError() {
        return this.cls_Error != null ? this.cls_Error : this.getFromQueue(this.cls_ErrorQueue);
    }

    private String[] getFromQueue(BlockingQueue<String> blockingQueue) {
        ArrayList arrayList = new ArrayList();
        blockingQueue.drainTo(arrayList);
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < arrayList.size(); ++i) {
            stringBuffer.append((String)arrayList.get(i));
        }
        return stringBuffer.toString().split(NEW_LINE);
    }

    protected synchronized void addOutput(String string) {
        if (string != null) {
            this.cls_OutputQueue.add(string);
        }
    }

    protected synchronized void addError(String string) {
        if (string != null && string.length() > 0) {
            if (this.cls_Password != null && this.cls_Password.length() > 0 && string.startsWith(PASSWORD)) {
                this.setSudoPassword(this.cls_Process, this.cls_Password);
                string = string.length() == PASSWORD.length() ? "" : string.substring(PASSWORD.length());
            }
            if (!string.equals(ANNOYING)) {
                this.cls_ErrorQueue.add(string + NEW_LINE);
            }
        }
    }

    private void setException(IOException iOException) {
        this.cls_Exception = iOException;
        this.cls_BlockingThread.interrupt();
    }

    public void waitFor() throws IOException {
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)"  - Will block thread waiting for response.");
            }
            this.cls_BlockingThread.join();
        }
        catch (InterruptedException interruptedException) {
            log.debug((Object)"  - Blocking thread complete.");
        }
        if (this.cls_Exception != null) {
            throw this.cls_Exception;
        }
        this.cls_Output = this.getFromQueue(this.cls_OutputQueue);
        this.cls_Error = this.getFromQueue(this.cls_ErrorQueue);
        if (log.isDebugEnabled()) {
            String string = Util.join(this.cls_Output);
            if (string == null || string.length() == 0) {
                this.cls_LastOutput = string;
            } else if (!this.cls_LastOutput.equals(string)) {
                this.cls_LastOutput = string;
                log.debug((Object)("[CPN~]   - Out: '" + string.replace('\n', '_') + "'"));
            } else {
                log.debug((Object)"  - Out unchanged.");
            }
            String string2 = Util.join(this.cls_Error);
            if (string2 == null || string2.length() == 0) {
                this.cls_LastError = string2;
            } else if (!this.cls_LastError.equals(string2)) {
                this.cls_LastError = string2;
                log.debug((Object)("[CPN~]   - Err: '" + string2.replace('\n', '_') + "'"));
            } else {
                log.debug((Object)"  - Err unchanged.");
            }
        }
    }

    public void close() {
        try {
            this.cls_Process.destroy();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.cls_Exception = null;
        try {
            this.cls_ErrorQueue.clear();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            this.cls_OutputQueue.clear();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            if (this.cls_BlockingThread != null && !this.cls_BlockingThread.isInterrupted()) {
                this.cls_BlockingThread.interrupt();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            if (this.cls_ReadingThread != null && !this.cls_ReadingThread.isInterrupted()) {
                this.cls_ReadingThread.interrupt();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void handleProcess() {
        block23: {
            IOException iOException2222;
            InputStreamReader inputStreamReader;
            InputStreamReader inputStreamReader2;
            block20: {
                inputStreamReader2 = null;
                inputStreamReader = null;
                if (this.cls_Process == null) {
                    throw new Exception("Could not execute command: " + this.cls_CommandLine);
                }
                inputStreamReader2 = new InputStreamReader(this.cls_Process.getInputStream(), "UTF-8");
                inputStreamReader = new InputStreamReader(this.cls_Process.getErrorStream(), "UTF-8");
                InputStreamEaterQ inputStreamEaterQ = new InputStreamEaterQ(inputStreamReader2, this, 0);
                Thread thread = new Thread(inputStreamEaterQ);
                thread.setName("OutEater");
                thread.start();
                InputStreamEaterQ inputStreamEaterQ2 = new InputStreamEaterQ(inputStreamReader, this, 1);
                Thread thread2 = new Thread(inputStreamEaterQ2);
                thread2.setName("ErrorEater");
                thread2.start();
                int n = this.cls_Process.waitFor();
                thread.join();
                thread2.join();
                this.setExitValue(n);
                thread = null;
                thread2 = null;
                Object var9_10 = null;
                if (inputStreamReader2 == null) break block20;
                try {
                    inputStreamReader2.close();
                }
                catch (IOException iOException2222) {
                    // empty catch block
                }
                inputStreamReader2 = null;
            }
            if (inputStreamReader == null) break block23;
            try {
                inputStreamReader.close();
            }
            catch (IOException iOException2222) {
                // empty catch block
            }
            inputStreamReader = null;
            {
                break block23;
                catch (IOException iOException3) {
                    IOException iOException42222;
                    System.out.println("handleProcess IOException: " + iOException3);
                    this.setException(iOException3);
                    Object var9_11 = null;
                    if (inputStreamReader2 != null) {
                        try {
                            inputStreamReader2.close();
                        }
                        catch (IOException iOException42222) {
                            // empty catch block
                        }
                        inputStreamReader2 = null;
                    }
                    if (inputStreamReader == null) break block23;
                    try {
                        inputStreamReader.close();
                    }
                    catch (IOException iOException42222) {
                        // empty catch block
                    }
                    inputStreamReader = null;
                    break block23;
                }
                catch (Exception exception) {
                    IOException iOException52222;
                    System.out.println("handleProcess non-IOException: " + exception);
                    this.setException(new IOException("Could not execute command. " + exception));
                    Object var9_12 = null;
                    if (inputStreamReader2 != null) {
                        try {
                            inputStreamReader2.close();
                        }
                        catch (IOException iOException52222) {
                            // empty catch block
                        }
                        inputStreamReader2 = null;
                    }
                    if (inputStreamReader == null) break block23;
                    try {
                        inputStreamReader.close();
                    }
                    catch (IOException iOException52222) {
                        // empty catch block
                    }
                    inputStreamReader = null;
                }
            }
            catch (Throwable throwable) {
                IOException iOException62222;
                Object var9_13 = null;
                if (inputStreamReader2 != null) {
                    try {
                        inputStreamReader2.close();
                    }
                    catch (IOException iOException62222) {
                        // empty catch block
                    }
                    inputStreamReader2 = null;
                }
                if (inputStreamReader != null) {
                    try {
                        inputStreamReader.close();
                    }
                    catch (IOException iOException62222) {
                        // empty catch block
                    }
                    inputStreamReader = null;
                }
                throw throwable;
            }
        }
    }

    public void writeInput(String string) throws IOException {
        BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(this.cls_Process.getOutputStream()));
        bufferedWriter.write(string);
        if (string == null || !string.endsWith("\n")) {
            bufferedWriter.write("\n");
        }
        bufferedWriter.flush();
        try {
            bufferedWriter.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public class InputStreamEaterQ
    implements Runnable {
        private BufferedReader cls_In;
        private CommandResponse cls_Response;
        private final int cls_Type;

        public InputStreamEaterQ(InputStreamReader inputStreamReader, CommandResponse commandResponse2, int n) {
            this.cls_In = new BufferedReader(inputStreamReader);
            this.cls_Response = commandResponse2;
            this.cls_Type = n;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                try {
                    String string;
                    while ((string = this.cls_In.readLine()) != null) {
                        if (this.cls_Type == 0) {
                            this.cls_Response.addOutput(string + '\n');
                            continue;
                        }
                        this.cls_Response.addError(string + '\n');
                    }
                    Object var4_2 = null;
                    this.cls_Response = null;
                }
                catch (IOException iOException) {
                    System.out.println("InputStreamEater IOException: " + iOException);
                    Object var4_3 = null;
                    this.cls_Response = null;
                }
                catch (Exception exception) {
                    System.out.println("InputStreamEater non-IOException: " + exception);
                    Object var4_4 = null;
                    this.cls_Response = null;
                }
            }
            catch (Throwable throwable) {
                Object var4_5 = null;
                this.cls_Response = null;
                throw throwable;
            }
        }
    }
}

