/*
 * Decompiled with CFR 0.152.
 */
package com.cloudpath.common.cert;

import com.cloudpath.common.cert.CertUtil;
import java.security.cert.X509Certificate;
import java.text.SimpleDateFormat;
import java.util.Locale;

public class CertificateChain {
    private final X509Certificate cls_Certificate;
    private final X509Certificate cls_ReplacementCertificate;
    private final boolean cls_IsChainedToTrust;
    private final X509Certificate[] cls_ChainToTrust;
    private final X509Certificate[] cls_AltChainToTrust;
    private final boolean cls_IsChainedToRoot;
    private final X509Certificate[] cls_ChainToRoot;
    private static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd", Locale.US);

    public CertificateChain(X509Certificate x509Certificate, X509Certificate x509Certificate2, boolean bl, X509Certificate[] x509CertificateArray, X509Certificate[] x509CertificateArray2, boolean bl2, X509Certificate[] x509CertificateArray3) {
        this.cls_Certificate = x509Certificate;
        this.cls_ReplacementCertificate = x509Certificate2;
        this.cls_IsChainedToTrust = bl;
        X509Certificate[] x509CertificateArray4 = this.cls_ChainToTrust = bl ? x509CertificateArray : new X509Certificate[]{};
        this.cls_AltChainToTrust = bl ? (x509CertificateArray2 != null ? x509CertificateArray2 : new X509Certificate[]{}) : new X509Certificate[]{};
        this.cls_IsChainedToRoot = bl2;
        this.cls_ChainToRoot = bl2 ? x509CertificateArray3 : new X509Certificate[]{};
    }

    public X509Certificate getCertificate() {
        return this.cls_Certificate;
    }

    public X509Certificate getReplacementCertificate() {
        return this.cls_ReplacementCertificate;
    }

    public boolean isChainedToTrust() {
        return this.cls_IsChainedToTrust;
    }

    public X509Certificate[] getChainToTrust() {
        return this.cls_ChainToTrust;
    }

    public X509Certificate[] getAltChainToTrust() {
        return this.cls_AltChainToTrust;
    }

    public boolean isChainedToRoot() {
        return this.cls_IsChainedToRoot;
    }

    public X509Certificate[] getChainToRoot() {
        return this.cls_ChainToRoot;
    }

    public boolean hasAlternateTrustChain() {
        return this.cls_AltChainToTrust != null && this.cls_AltChainToTrust.length > 0;
    }

    public X509Certificate getAlternateIssuer() {
        if (this.getAltChainToTrust().length > 1) {
            return this.getAltChainToTrust()[1];
        }
        return null;
    }

    public X509Certificate getParentCertificate() {
        if (this.isChainedToTrust() && this.getChainToTrust().length > 1) {
            return this.getChainToTrust()[1];
        }
        if (this.isChainedToRoot() && this.getChainToRoot().length > 1) {
            return this.getChainToRoot()[1];
        }
        return null;
    }

    public String getSummary() throws Exception {
        int n;
        String string = "*****CERTIFICATE INFORMATION*****\n" + this.getSummary(this.getCertificate()) + "\nBehavior:\n" + "IsChainedToTrust: " + this.isChainedToTrust() + "\n" + "TrustChainSize: " + this.getChainToTrust().length + "\n" + "IsChainedToRoot: " + this.isChainedToRoot() + "\n" + "RootChainSize: " + this.getChainToRoot().length + "\n";
        if (this.getReplacementCertificate() == null) {
            string = string + "Certificate has not been replaced.\n";
        } else {
            string = string + "\n\n*** Certificate has been replaced by:\n\n";
            string = string + this.getSummary(this.getReplacementCertificate());
        }
        if (this.getChainToRoot().length > 1) {
            string = string + "\n\nChain To Root:\n\n";
            for (n = 1; n < this.getChainToRoot().length; ++n) {
                string = string + this.getSummary(this.getChainToRoot()[n]);
                string = string + "\n\n";
            }
        }
        if (this.getChainToTrust().length > 1) {
            string = string + "\n\nChain To Trust:\n\n";
            for (n = 1; n < this.getChainToTrust().length; ++n) {
                string = string + this.getSummary(this.getChainToTrust()[n]);
                string = string + "\n\n";
            }
        }
        if (this.getAltChainToTrust().length > 1) {
            string = string + "\n\nChain To Alt Trust:\n\n";
            for (n = 1; n < this.getAltChainToTrust().length; ++n) {
                string = string + this.getSummary(this.getAltChainToTrust()[n]);
                string = string + "\n\n";
            }
        }
        return string;
    }

    private String getSummary(X509Certificate x509Certificate) {
        String string = "Unknown";
        try {
            string = CertUtil.getThumbprint(x509Certificate);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "-----------------------------------------------------------------\nThumbprint: " + string + "\n" + "Common Name: " + CertUtil.getCommonName(x509Certificate) + "\n" + "Email Address: " + CertUtil.getEmailAddress(x509Certificate) + "\n" + "Subject: " + x509Certificate.getSubjectDN() + "\n" + "Public Key: " + CertUtil.hexify(x509Certificate.getPublicKey().getEncoded()) + "\n" + "Expiration Date: " + DATE_FORMAT.format(x509Certificate.getNotAfter()) + "\n" + "Start Date: " + DATE_FORMAT.format(x509Certificate.getNotBefore()) + "\n" + "-----------------------------------------------------------------";
    }
}

