/*
 * Decompiled with CFR 0.152.
 */
package com.cloudpath.common.app;

import com.cloudpath.common.app.Application;
import com.cloudpath.common.app.gui.ExternalInterface;
import com.cloudpath.common.app.gui.GuiTab;
import com.cloudpath.common.app.gui.GuiTabChangeListener;
import com.cloudpath.common.dispatch.AsyncHandler;
import com.cloudpath.common.dispatch.DispatchRequest;
import com.cloudpath.common.dispatch.DispatchResponse;
import com.cloudpath.common.dispatch.Dispatcher;
import com.cloudpath.common.dispatch.ErrorRequest;
import com.cloudpath.common.dispatch.ResponseHandler;
import com.cloudpath.common.dispatch.TerminateRequest;
import com.cloudpath.common.dispatch.TerminateSelection;
import com.cloudpath.common.dispatch.WaitRequest;
import com.cloudpath.common.util.GuiShutdownListener;
import com.cloudpath.common.util.Util;
import java.util.ArrayList;
import org.apache.log4j.Logger;

public class Controller
implements GuiTabChangeListener,
AsyncHandler {
    private static final Logger log = Logger.getLogger(Controller.class);
    private final ExternalInterface cls_Gui;
    private final Dispatcher cls_Dispatcher;
    private final GuiShutdownListener cls_GuiShutdownListener;

    public Controller(Application application, GuiShutdownListener guiShutdownListener) throws Exception {
        this.cls_GuiShutdownListener = guiShutdownListener;
        this.cls_Gui = application.getGui(this);
        final ResponseHandler responseHandler = application.getResponseHandler(this, this);
        this.cls_Dispatcher = new Dispatcher(responseHandler, this.cls_Gui);
        Util.runThread("InitThread", new Runnable(){

            public void run() {
                log.info((Object)"Adding first request into dispatcher.");
                try {
                    Controller.this.cls_Dispatcher.processAsync(responseHandler.doProcess());
                }
                catch (Exception exception) {
                    log.error((Object)"An error occurred during system initialization.", (Throwable)exception);
                    ErrorRequest errorRequest = new ErrorRequest("Loading Error", "An error occurred during loading.<br><br>" + Util.getStackTrace(exception), false, false);
                    Controller.this.cls_Dispatcher.processAsync(errorRequest);
                }
            }
        });
    }

    public void shutdown() {
        this.cls_Dispatcher.stop();
    }

    public void waitFor() throws Exception {
        log.warn((Object)"Will wait for dispatcher to exit.");
        this.cls_Dispatcher.waitFor();
        log.warn((Object)"Done waiting for dispatcher to exit.");
    }

    public void tabsChanged(GuiTab[] guiTabArray, GuiTab guiTab) {
        log.debug((Object)("Notified that tabs changed with selection at " + guiTab));
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = -1;
        for (int i = 0; i < guiTabArray.length; ++i) {
            if (guiTabArray[i] == null) continue;
            log.debug((Object)("Handling tab '" + (Object)((Object)guiTabArray[i].getResourceString()) + "'."));
            arrayList.add(guiTabArray[i].getResourceString().getValue());
            if (!guiTabArray[i].equals(guiTab)) continue;
            n = i;
        }
        String[] stringArray = new String[arrayList.size()];
        arrayList.toArray(stringArray);
        this.cls_Gui.setTabs(stringArray, n);
    }

    public void selectionChanged(GuiTab guiTab) {
        log.debug((Object)"Notified that tab selection changed.");
        this.cls_Gui.setSelectedTab(guiTab.getResourceString().getValue());
    }

    public void selectionChanged(int n) {
        log.debug((Object)"Notified that tab selection changed.");
        this.cls_Gui.setSelectedTab(n);
    }

    public void processAsync(DispatchRequest dispatchRequest) {
        if (this.cls_Dispatcher != null) {
            if (dispatchRequest instanceof TerminateRequest) {
                log.warn((Object)"User has requested to terminate application.");
                this.cls_Dispatcher.processAsync(new WaitRequest("Please Wait...", "The application is closing.", "/info.gif"));
                Util.runThread("Closing", new Runnable(){

                    public void run() {
                        try {
                            Thread.yield();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        log.warn((Object)"Will stop dispatcher.");
                        Controller.this.cls_Dispatcher.stop();
                        log.warn((Object)"Application is exiting.");
                        if (Controller.this.cls_GuiShutdownListener != null) {
                            Controller.this.cls_GuiShutdownListener.shutdown();
                        } else {
                            System.exit(0);
                        }
                    }
                });
            }
            this.cls_Dispatcher.processAsync(dispatchRequest);
        }
    }

    public void processAsync(DispatchResponse dispatchResponse) {
        if (dispatchResponse instanceof TerminateSelection) {
            log.warn((Object)"User has requested to terminate application.");
            this.cls_Dispatcher.processAsync(new WaitRequest("Please Wait...", "The application is closing.", "/info.gif"));
            Util.runThread("Closing", new Runnable(){

                public void run() {
                    try {
                        Thread.yield();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    log.warn((Object)"Will stop dispatcher.");
                    Controller.this.cls_Dispatcher.stop();
                    log.warn((Object)"Application is exiting.");
                    if (Controller.this.cls_GuiShutdownListener != null) {
                        Controller.this.cls_GuiShutdownListener.shutdown();
                    } else {
                        System.exit(0);
                    }
                }
            });
        } else if (this.cls_Dispatcher != null) {
            this.cls_Dispatcher.processAsync(dispatchResponse);
        }
    }
}

