/*
 * Decompiled with CFR 0.152.
 */
package com.cloudpath.assess.pojo.util;

import com.cloudpath.assess.pojo.Setting;
import com.cloudpath.assess.pojo.util.SettingValue;
import com.cloudpath.common.util.Constants;
import com.cloudpath.common.util.Util;
import java.awt.Color;
import org.apache.log4j.Logger;

public class SettingRuntime {
    private static final Logger log = Logger.getLogger(SettingRuntime.class);
    private final Setting cls_Setting;
    private SettingValue cls_OriginalValue = new SettingValue();
    private SettingValue cls_CurrentValue = new SettingValue();
    private int cls_IncorrectNotificationCount = 0;
    private boolean cls_WasSkipped = false;
    private boolean cls_WasNotified = false;
    private Constants.FixPreventionReason cls_FixPreventionReason = Constants.FixPreventionReason.NONE;
    private boolean cls_OriginalIsOverridden = false;

    public SettingRuntime(Setting setting) {
        this.cls_Setting = setting;
    }

    public void resetNotificationCount() {
        this.cls_IncorrectNotificationCount = 0;
    }

    public void incrementIncorrectNotificationCount() {
        ++this.cls_IncorrectNotificationCount;
        log.debug((Object)("Notification count for setting '" + (this.cls_Setting != null ? this.cls_Setting.getSettingId() : "NULL") + "' is being incremented to " + this.cls_IncorrectNotificationCount));
    }

    public int getIncorrectNotificationCount() {
        return this.cls_IncorrectNotificationCount;
    }

    public boolean getWasSkipped() {
        return this.cls_WasSkipped;
    }

    public void setWasSkipped(boolean bl) {
        this.cls_WasSkipped = bl;
    }

    public boolean getWasNotified() {
        return this.cls_WasNotified;
    }

    public void setWasNotified() {
        this.cls_WasNotified = true;
    }

    public Constants.FixPreventionReason getFixPreventionReason() {
        return this.cls_FixPreventionReason;
    }

    public void setFixPreventionReason(Constants.FixPreventionReason fixPreventionReason) {
        this.cls_FixPreventionReason = fixPreventionReason;
    }

    public SettingValue getCurrentValue() {
        return this.cls_CurrentValue;
    }

    public void setCurrentValue(SettingValue settingValue) {
        this.cls_CurrentValue = settingValue == null ? new SettingValue() : settingValue;
    }

    public SettingValue getOriginalValue() {
        return this.cls_OriginalValue;
    }

    public void setOriginalValue(SettingValue settingValue) {
        this.cls_OriginalValue = settingValue == null ? new SettingValue() : settingValue;
        this.setCurrentValue(settingValue == null ? new SettingValue() : settingValue.clone());
    }

    public void overrideOriginalValue(String string, String string2, String string3) {
        this.cls_OriginalIsOverridden = true;
        this.getOriginalValue().setValue(string);
        this.getOriginalValue().setAdditionalValue(string2);
        this.getOriginalValue().setUnenforcedValue(string3);
    }

    public boolean getIsOriginalValueOverridden() {
        return this.cls_OriginalIsOverridden;
    }

    public void skipReverting() {
        this.cls_OriginalValue.setValue(this.getCurrentValue().getValue());
        this.cls_OriginalValue.setAdditionalValue(this.getCurrentValue().getAdditionalValue());
        this.cls_OriginalValue.setUnenforcedValue(this.getCurrentValue().getUnenforcedValue());
    }

    public boolean getIsOriginalValue() {
        return this.getCurrentValue().equalsLiteral(this.getOriginalValue(), this.cls_Setting.getEnforceAdditionalValue());
    }

    public boolean isCurrentValueCorrect() {
        boolean bl = this.cls_Setting != null ? this.cls_Setting.getEnforceAdditionalValue() : false;
        return this.cls_Setting.getRequiredValue().qualifies(this.cls_Setting.getOperator(), this.getCurrentValue(), bl, this.cls_Setting.getAvOperator(), this.cls_Setting.getAvDatatype());
    }

    public Color getCurrentColor() {
        String string;
        Color color;
        if (this.isCurrentValueCorrect() || this.cls_Setting.getRuntime().getWasSkipped()) {
            color = Color.green;
            string = "Green";
        } else if (this.cls_Setting.getIsRequired()) {
            color = Color.red;
            string = "Red";
        } else {
            color = Color.yellow;
            string = "Yellow";
        }
        log.debug((Object)("     - Current State: " + (Object)((Object)this.cls_Setting.getSettingId()) + " (" + string + ")" + '\n' + "                              -- Current: " + this.getCurrentValue() + '\n' + "                              -- Required: " + this.cls_Setting.getRequiredValue()));
        return color;
    }

    public String getDisplayText() {
        String string = this.cls_Setting.getLabelWhenIncorrect();
        string = Util.replaceVariable(string, "ADDITIONAL_VALUE", this.cls_Setting.getRequiredValue().getAdditionalValue());
        return string;
    }

    public String getDisplayTextAfterFix() {
        String string = this.cls_Setting.getLabelWhenRepaired();
        string = Util.replaceVariable(string, "ADDITIONAL_VALUE", this.cls_Setting.getRequiredValue().getAdditionalValue());
        return string;
    }

    public boolean hasHelp() {
        return this.cls_Setting.getHelpLink().length() > 0;
    }

    public String getDisplayHelp() {
        String string = this.cls_Setting.getHelpLink();
        if (string.startsWith("http")) {
            String[] stringArray = string.split(";");
            string = stringArray.length > 1 ? stringArray[1] : "";
        }
        string = Util.replaceVariable(string, "ADDITIONAL_VALUE", this.cls_Setting.getRequiredValue().getAdditionalValue());
        return string;
    }

    public String getDisplayHelpUrl() {
        String string = this.cls_Setting.getHelpLink();
        if (string.startsWith("http")) {
            String[] stringArray = string.split(";");
            return stringArray[0];
        }
        return "";
    }

    public boolean isOptional() {
        return !this.cls_Setting.getIsRequired();
    }
}

